/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.repository.transport.client;

import com.ibm.ws.repository.common.enums.StateAction;
import com.ibm.ws.repository.transport.client.AbstractRepositoryClient;
import com.ibm.ws.repository.transport.client.DataModelSerializer;
import com.ibm.ws.repository.transport.client.RepositoryWriteableClient;
import com.ibm.ws.repository.transport.exceptions.BadVersionException;
import com.ibm.ws.repository.transport.exceptions.ClientFailureException;
import com.ibm.ws.repository.transport.exceptions.RequestFailureException;
import com.ibm.ws.repository.transport.model.AppliesToFilterInfo;
import com.ibm.ws.repository.transport.model.Asset;
import com.ibm.ws.repository.transport.model.Attachment;
import com.ibm.ws.repository.transport.model.AttachmentSummary;
import com.ibm.ws.repository.transport.model.WlpInformation;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonArrayBuilder;
import javax.json.JsonObject;
import javax.json.JsonReader;
import javax.json.JsonStructure;
import javax.json.JsonValue;
import javax.json.JsonWriter;
import javax.json.JsonWriterFactory;

public class SingleFileClient
extends AbstractRepositoryClient
implements RepositoryWriteableClient {
    private final File file;
    private long fileLastModified = 0L;
    private long fileLastSize = 0L;
    private Map<String, JsonObject> assets;
    private AtomicInteger idCounter;

    public SingleFileClient(File jsonFile) {
        this.file = jsonFile;
    }

    private synchronized Map<String, JsonObject> getAssetMap() throws IOException {
        if (!this.file.canRead()) {
            throw new IOException("Cannot read repository file: " + this.file.getAbsolutePath());
        }
        if (this.assets == null || this.file.lastModified() != this.fileLastModified || this.file.length() != this.fileLastSize) {
            this.assets = null;
            this.fileLastModified = this.file.lastModified();
            this.fileLastSize = this.file.length();
            this.idCounter = new AtomicInteger(1);
            this.assets = new HashMap<String, JsonObject>();
            JsonReader reader = Json.createReader((InputStream)new FileInputStream(this.file));
            JsonArray assetList = reader.readArray();
            for (JsonValue val : assetList) {
                String id = Integer.toString(this.idCounter.getAndIncrement());
                if (val.getValueType() != JsonValue.ValueType.OBJECT) continue;
                this.assets.put(id, (JsonObject)val);
            }
        }
        return this.assets;
    }

    @Override
    public Asset getAsset(String assetId) throws IOException, BadVersionException, RequestFailureException {
        JsonObject assetJson = this.getAssetMap().get(assetId);
        if (assetJson == null) {
            throw new RequestFailureException(404, "Asset does not exist", this.file.toURI().toURL(), "Asset does not exist");
        }
        Asset asset = DataModelSerializer.deserializeObject(assetJson, Asset.class, DataModelSerializer.Verification.VERIFY);
        asset.set_id(assetId);
        this.addWlpInformation(asset);
        return asset;
    }

    @Override
    public Collection<Asset> getAllAssets() throws IOException, RequestFailureException {
        ArrayList<Asset> result = new ArrayList<Asset>();
        for (Map.Entry<String, JsonObject> entry : this.getAssetMap().entrySet()) {
            if (entry.getValue() == null) continue;
            try {
                Asset asset = DataModelSerializer.deserializeObject(entry.getValue(), Asset.class, DataModelSerializer.Verification.VERIFY);
                asset.set_id(entry.getKey());
                this.addWlpInformation(asset);
                result.add(asset);
            }
            catch (BadVersionException e) {}
        }
        return result;
    }

    @Override
    public InputStream getAttachment(Asset asset, Attachment attachment) throws IOException, BadVersionException, RequestFailureException {
        throw new UnsupportedOperationException("Single file repositories do not support attachments");
    }

    @Override
    public void checkRepositoryStatus() throws IOException, RequestFailureException {
        if (!this.file.canRead()) {
            throw new IOException("Cannot read repository file " + this.file.getAbsolutePath());
        }
    }

    @Override
    public void updateState(String assetId, StateAction action) throws IOException, RequestFailureException {
    }

    @Override
    public Asset addAsset(Asset asset) throws IOException, BadVersionException, RequestFailureException, SecurityException, ClientFailureException {
        if (asset.get_id() != null) {
            throw new ClientFailureException("Asset id is not null when adding a new asset", asset.get_id());
        }
        try {
            Map<String, JsonObject> assetMap = this.getAssetMap();
            JsonObject json = (JsonObject)DataModelSerializer.serializeAsJson(asset.createMinimalAssetForJSON());
            String id = Integer.toString(this.idCounter.getAndIncrement());
            assetMap.put(id, json);
            this.rewriteFile();
            return this.getAsset(id);
        }
        catch (IllegalAccessException ex) {
            throw new IOException("Unable to create JSON for asset", ex);
        }
    }

    @Override
    public Asset updateAsset(Asset asset) throws IOException, BadVersionException, RequestFailureException, SecurityException, ClientFailureException {
        throw new UnsupportedOperationException("Single file repositories do not support updates");
    }

    @Override
    public Attachment addAttachment(String assetId, AttachmentSummary attSummary) throws IOException, BadVersionException, RequestFailureException, SecurityException {
        return null;
    }

    @Override
    public Attachment updateAttachment(String assetId, AttachmentSummary summary) throws IOException, BadVersionException, RequestFailureException, SecurityException {
        throw new UnsupportedOperationException("Single file repositories do not support attachments");
    }

    @Override
    public void deleteAttachment(String assetId, String attachmentId) throws IOException, RequestFailureException {
        throw new UnsupportedOperationException("Single file repositories do not support attachments");
    }

    @Override
    public void deleteAssetAndAttachments(String assetId) throws IOException, RequestFailureException {
        Map<String, JsonObject> assets = this.getAssetMap();
        if (assets.containsKey(assetId)) {
            assets.remove(assetId);
        }
        this.rewriteFile();
    }

    private void addWlpInformation(Asset asset) {
        WlpInformation wlpInfo = asset.getWlpInformation();
        if (wlpInfo == null) {
            wlpInfo = new WlpInformation();
            asset.setWlpInformation(wlpInfo);
        }
        if (wlpInfo.getAppliesToFilterInfo() == null) {
            wlpInfo.setAppliesToFilterInfo(new ArrayList<AppliesToFilterInfo>());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void rewriteFile() throws FileNotFoundException, IOException {
        JsonArrayBuilder jsonToStore = Json.createArrayBuilder();
        Map<Object, Object> assetMap = this.assets == null ? Collections.emptyMap() : this.assets;
        for (int i = 1; i < this.idCounter.get(); ++i) {
            JsonObject json = (JsonObject)assetMap.get(Integer.toString(i));
            if (json == null) {
                jsonToStore.addNull();
                continue;
            }
            jsonToStore.add((JsonValue)json);
        }
        try (FileOutputStream out = null;){
            HashMap<String, Boolean> config = new HashMap<String, Boolean>();
            config.put("javax.json.stream.JsonGenerator.prettyPrinting", true);
            JsonWriterFactory writerFactory = Json.createWriterFactory(config);
            out = new FileOutputStream(this.file);
            JsonWriter streamWriter = writerFactory.createWriter((OutputStream)out);
            streamWriter.write((JsonStructure)jsonToStore.build());
        }
    }
}

