/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.messaging.jms.j2ee.mbeans.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.messaging.jms.j2ee.mbeans.JmsServiceProviderMBeanImpl;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.kernel.service.location.WsLocationAdmin;
import com.ibm.wsspi.kernel.service.utils.AtomicServiceReference;
import java.io.IOException;
import java.util.Dictionary;
import java.util.Hashtable;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@Component(configurationPolicy=ConfigurationPolicy.IGNORE, immediate=true, property={"service.vendor=IBM"})
public class JMSMbeansActivator {
    private static final TraceComponent tc = Tr.register(JMSMbeansActivator.class);
    private static final String KEY_JMX_OBJECTNAME = "jmx.objectname";
    private static final String KEY_SERVICE_VENDOR = "service.vendor";
    private static final String KEY_JMS2_PROVIDER = "JMS-2.0Provider";
    private static final String KEY_LOCATION_ADMIN = "locationAdmin";
    private final AtomicServiceReference<WsLocationAdmin> locationAdminRef = new AtomicServiceReference("locationAdmin");
    ServiceRegistration<?> jmsProvderMBean;
    static final long serialVersionUID = -5852349524624891986L;

    @Activate
    protected void activate(ComponentContext context) throws IOException {
        this.locationAdminRef.activate(context);
        this.jmsProvderMBean = this.registerMBeanService(KEY_JMS2_PROVIDER, context.getBundleContext());
    }

    @Deactivate
    protected void deactivate(ComponentContext context) {
        this.locationAdminRef.deactivate(context);
        this.jmsProvderMBean.unregister();
    }

    @Reference(name="locationAdmin", service=WsLocationAdmin.class, cardinality=ReferenceCardinality.MANDATORY)
    protected void setLocationAdmin(ServiceReference<WsLocationAdmin> ref) {
        this.locationAdminRef.setReference(ref);
    }

    protected void unsetLocationAdmin(ServiceReference<WsLocationAdmin> ref) {
        this.locationAdminRef.unsetReference(ref);
    }

    private String getServerName() {
        WsLocationAdmin locationAdmin = (WsLocationAdmin)this.locationAdminRef.getService();
        if (locationAdmin == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"locationAdmin is not bound. Hence j2EEServer name will be null ", (Object[])new Object[0]);
            }
            return null;
        }
        return locationAdmin.getServerName();
    }

    private ServiceRegistration<?> registerMBeanService(String jmsResourceName, BundleContext bundleContext) {
        Hashtable<String, String> props = new Hashtable<String, String>();
        ((Dictionary)props).put(KEY_SERVICE_VENDOR, "IBM");
        JmsServiceProviderMBeanImpl jmsProviderMBean = new JmsServiceProviderMBeanImpl(this.getServerName(), KEY_JMS2_PROVIDER);
        ((Dictionary)props).put(KEY_JMX_OBJECTNAME, jmsProviderMBean.getobjectName());
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("JmsQueueMBeanImpl=" + jmsProviderMBean.getobjectName() + " props=" + props), (Object[])new Object[0]);
        }
        return bundleContext.registerService(JmsServiceProviderMBeanImpl.class, (Object)jmsProviderMBean, props);
    }
}

