/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.rsadapter.jdbc;

import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.rsadapter.jdbc.WSJdbcWrapper;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.sql.CommonDataSource;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.DataSource;
import javax.sql.PooledConnection;
import javax.sql.XADataSource;
import javax.transaction.xa.XAResource;

public abstract class WSJdbcProxyMethod {
    static final Set<String> unsafeMethods;
    static final Set<String> overrideUnsafeReturnTypeMethods;
    static final Set<String> alwaysBeginTranMethods;
    static final Map<Method, WSJdbcProxyMethod> specialCaseMethods;
    private static final Set<String> clientInfoSetterMethods;

    public static final WSJdbcProxyMethod getSpecialCase(Method meth) {
        return specialCaseMethods.get(meth);
    }

    public abstract Object invoke(WSJdbcWrapper var1, Object var2, Method var3, Object[] var4) throws Throwable;

    public static final boolean isClientInfoSetter(String methodName) {
        return clientInfoSetterMethods.contains(methodName);
    }

    public static final boolean isSafe(Method meth) {
        String fullyQualifiedName = meth.getDeclaringClass().getName() + '.' + meth.getName();
        return !unsafeMethods.contains(meth.getName()) && !unsafeMethods.contains(fullyQualifiedName);
    }

    static boolean overrideUnsafeReturnType(Method meth) {
        return overrideUnsafeReturnTypeMethods.contains(meth.getName());
    }

    static boolean isSafeReturnType(Class<?> type) {
        return !ConnectionPoolDataSource.class.isAssignableFrom(type) && !CommonDataSource.class.isAssignableFrom(type) && !XADataSource.class.isAssignableFrom(type) && !DataSource.class.isAssignableFrom(type) && !PooledConnection.class.isAssignableFrom(type) && !Connection.class.isAssignableFrom(type) && !DatabaseMetaData.class.isAssignableFrom(type) && !Statement.class.isAssignableFrom(type) && !ResultSet.class.isAssignableFrom(type) && !XAResource.class.isAssignableFrom(type);
    }

    static {
        alwaysBeginTranMethods = new HashSet<String>();
        clientInfoSetterMethods = new HashSet<String>(Arrays.asList("setAccountingInfo", "setApplicationName", "setAttribute", "setClientAccountingInfo", "setClientAccountingInformation", "setClientAcctInfo", "setClientApplicationInformation", "setClientApplicationName", "setClientAppName", "setClientHostName", "setClientUser", "setClientWorkstation"));
        unsafeMethods = new HashSet<String>(47);
        unsafeMethods.add("_getPC");
        unsafeMethods.add("abort");
        unsafeMethods.add("abortConnection");
        unsafeMethods.add("applyConnectionAttributes");
        unsafeMethods.add("attachServerConnection");
        unsafeMethods.add("beginRequest");
        unsafeMethods.add("cancel");
        unsafeMethods.add("cleanupAndClose");
        unsafeMethods.add("close");
        unsafeMethods.add("closeInternal");
        unsafeMethods.add("closeLogicalConnection");
        unsafeMethods.add("closeWithKey");
        unsafeMethods.add("commit");
        unsafeMethods.add("createConnectionBuilder");
        unsafeMethods.add("createPooledConnectionBuilder");
        unsafeMethods.add("createXAConnectionBuilder");
        unsafeMethods.add("detachServerConnection");
        unsafeMethods.add("doClose");
        unsafeMethods.add("endRequest");
        unsafeMethods.add("getDB2Object");
        unsafeMethods.add("getLogicalConnection");
        unsafeMethods.add("getObjectInstance");
        unsafeMethods.add("getPassword");
        unsafeMethods.add("getPhysicalConnection");
        unsafeMethods.add("getWrapper");
        unsafeMethods.add("getXAResource");
        unsafeMethods.add("init");
        unsafeMethods.add("oracleReleaseSavepoint");
        unsafeMethods.add("oracleRollback");
        unsafeMethods.add("oracleSetSavepoint");
        unsafeMethods.add("prepareCallWithKey");
        unsafeMethods.add("prepareStatementWithKey");
        unsafeMethods.add("realObject");
        unsafeMethods.add("resetUser");
        unsafeMethods.add("setAutoClose");
        unsafeMethods.add("setCurrentUser");
        unsafeMethods.add("setShardingKeyIfValid");
        unsafeMethods.add("setShardingKey");
        unsafeMethods.add("setUsingXAFlag");
        unsafeMethods.add("setWrapper");
        unsafeMethods.add("setXAErrorFlag");
        unsafeMethods.add("unwrap");
        unsafeMethods.add("com.ddtek.jdbc.extensions.ExtDataSource.setLongDataCacheSize");
        unsafeMethods.add("com.ddtek.jdbc.extensions.ExtDataSource.setQueryTimeout");
        unsafeMethods.add("com.microsoft.sqlserver.jdbc.ISQLServerDataSource.setResponseBuffering");
        overrideUnsafeReturnTypeMethods = new HashSet<String>();
        overrideUnsafeReturnTypeMethods.add("getCursor");
        overrideUnsafeReturnTypeMethods.add("getReturnResultSet");
        overrideUnsafeReturnTypeMethods.add("getSingletonResultSet");
        overrideUnsafeReturnTypeMethods.add("physicalConnectionWithin");
        overrideUnsafeReturnTypeMethods.add("prepareSQLJCall");
        overrideUnsafeReturnTypeMethods.add("prepareSQLJStatement");
        alwaysBeginTranMethods.add("executeBatch");
        alwaysBeginTranMethods.add("prepareSQLJCall");
        alwaysBeginTranMethods.add("prepareSQLJStatement");
        specialCaseMethods = new HashMap<Method, WSJdbcProxyMethod>();
        try {
            specialCaseMethods.put(Object.class.getMethod("hashCode", null), new WSJdbcProxyMethod(){

                @Override
                public Object invoke(WSJdbcWrapper wrapper, Object proxy, Method method, Object[] args) throws Throwable {
                    return System.identityHashCode(proxy);
                }
            });
            specialCaseMethods.put(Object.class.getMethod("equals", Object.class), new WSJdbcProxyMethod(){

                @Override
                public Object invoke(WSJdbcWrapper wrapper, Object proxy, Method method, Object[] args) throws Throwable {
                    return proxy == args[0] ? Boolean.TRUE : Boolean.FALSE;
                }
            });
            specialCaseMethods.put(Object.class.getMethod("toString", null), new WSJdbcProxyMethod(){

                @Override
                public Object invoke(WSJdbcWrapper wrapper, Object proxy, Method method, Object[] args) throws Throwable {
                    return "Proxy@" + Integer.toHexString(System.identityHashCode(proxy));
                }
            });
        }
        catch (NoSuchMethodException methX) {
            FFDCFilter.processException((Throwable)methX, (String)(WSJdbcProxyMethod.class.getName() + ".<init>"), (String)"152");
            throw new ExceptionInInitializerError(methX);
        }
    }
}

