/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ejbcontainer.async.osgi.internal;

import com.ibm.ejs.container.ClientAsyncResult;
import com.ibm.ejs.container.EJBMethodInfoImpl;
import com.ibm.ejs.container.EJSWrapperBase;
import com.ibm.ejs.container.RemoteAsyncResult;
import com.ibm.ejs.container.WrapperInterface;
import com.ibm.ejs.container.util.ExceptionUtil;
import com.ibm.websphere.csi.J2EEName;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.ManualTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.ejbcontainer.EJBMethodInterface;
import com.ibm.ws.ejbcontainer.EJBPMICollaborator;
import com.ibm.ws.ejbcontainer.async.osgi.internal.AsyncMethodWrapperImpl;
import com.ibm.ws.ejbcontainer.async.osgi.internal.RemoteAsyncResultImpl;
import com.ibm.ws.ejbcontainer.async.osgi.internal.RemoteAsyncResultReaper;
import com.ibm.ws.ejbcontainer.async.osgi.internal.ServerAsyncResultImpl;
import com.ibm.ws.ejbcontainer.osgi.EJBAsyncRuntime;
import com.ibm.ws.ejbcontainer.osgi.EJBRemoteRuntime;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.kernel.service.utils.AtomicServiceReference;
import com.ibm.wsspi.threadcontext.ThreadContextDescriptor;
import com.ibm.wsspi.threadcontext.WSContextService;
import java.rmi.RemoteException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@Component(service={EJBAsyncRuntime.class}, configurationPid={"com.ibm.ws.ejbcontainer.asynchronous.runtime"}, configurationPolicy=ConfigurationPolicy.OPTIONAL, property={"contextService.target=(id=unbound)"})
public class EJBAsyncRuntimeImpl
implements EJBAsyncRuntime {
    private static final TraceComponent tc = Tr.register(EJBAsyncRuntimeImpl.class);
    private static final long DEFAULT_UNCLAIMED_REMOTE_RESULT_TIMEOUT_MILLIS = 86400000L;
    private static final int DEFAULT_MAX_UNCLAIMED_REMOTE_RESULTS = 1000;
    private static final String MANAGEDTASK_IDENTITY_NAME = "javax.enterprise.concurrent.IDENTITY_NAME";
    private static final Map<String, ?>[] DEFAULT_ASYNC_REQUIRED_CONTEXTS = new Map[]{Collections.singletonMap("threadContextProvider", "com.ibm.ws.security.context.provider")};
    private WSContextService defaultContextService;
    private ExecutorService executorService;
    private RemoteAsyncResultReaper remoteAsyncResultReaper;
    private long unclaimedRemoteResultTimeoutMillis;
    private int maxUnclaimedRemoteResults;
    private static final String REFERENCE_CONTEXT_SERVICE = "contextService";
    private static final String REFERENCE_REMOTE_RUNTIME = "remoteRuntime";
    private static final String REFERENCE_SCHEDULED_EXECUTOR_SERVICE = "scheduledExecutorService";
    private final AtomicServiceReference<WSContextService> contextServiceRef = new AtomicServiceReference("contextService");
    private final AtomicServiceReference<EJBRemoteRuntime> remoteRuntimeRef = new AtomicServiceReference("remoteRuntime");
    private final AtomicServiceReference<ScheduledExecutorService> scheduledExecutorServiceRef = new AtomicServiceReference("scheduledExecutorService");
    static final long serialVersionUID = 8931986015964748441L;

    @Reference(target="(service.pid=com.ibm.ws.context.manager)")
    protected void setDefaultContextService(WSContextService contextService) {
        this.defaultContextService = contextService;
    }

    protected void unsetDefaultContextService(WSContextService contextService) {
        this.defaultContextService = null;
    }

    @Reference
    protected void setExecutorService(ExecutorService executor) {
        this.executorService = executor;
    }

    protected void unsetExecutorService(ExecutorService executor) {
        this.executorService = null;
    }

    @Reference(name="contextService", service=WSContextService.class, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY, cardinality=ReferenceCardinality.OPTIONAL)
    protected void setContextService(ServiceReference<WSContextService> ref) {
        this.contextServiceRef.setReference(ref);
    }

    protected void updatedContextService(ServiceReference<WSContextService> ref) {
    }

    protected void unsetContextService(ServiceReference<WSContextService> ref) {
        this.contextServiceRef.unsetReference(ref);
    }

    @Reference(name="remoteRuntime", service=EJBRemoteRuntime.class, cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC)
    protected void setRemoteRuntime(ServiceReference<EJBRemoteRuntime> ref) {
        this.remoteRuntimeRef.setReference(ref);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unsetRemoteRuntime(ServiceReference<EJBRemoteRuntime> ref) {
        EJBAsyncRuntimeImpl eJBAsyncRuntimeImpl = this;
        synchronized (eJBAsyncRuntimeImpl) {
            if (this.remoteAsyncResultReaper != null) {
                this.remoteAsyncResultReaper.finalReap();
                this.remoteAsyncResultReaper = null;
            }
        }
        this.remoteRuntimeRef.unsetReference(ref);
    }

    @Reference(name="scheduledExecutorService", service=ScheduledExecutorService.class, target="(deferrable=true)")
    protected void setScheduledExecutorService(ServiceReference<ScheduledExecutorService> ref) {
        this.scheduledExecutorServiceRef.setReference(ref);
    }

    protected void unsetScheduledExecutor(ServiceReference<ScheduledExecutorService> ref) {
        this.scheduledExecutorServiceRef.unsetReference(ref);
    }

    @Activate
    protected void activate(ComponentContext cc, Map<String, Object> properties) {
        this.contextServiceRef.activate(cc);
        this.remoteRuntimeRef.activate(cc);
        this.scheduledExecutorServiceRef.activate(cc);
        this.modified(properties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Modified
    protected synchronized void modified(Map<String, Object> properties) {
        Long unclaimedRemoteResultTimeout = (Long)properties.get("unclaimedRemoteResultTimeout");
        this.unclaimedRemoteResultTimeoutMillis = unclaimedRemoteResultTimeout != null ? TimeUnit.MILLISECONDS.convert(unclaimedRemoteResultTimeout, TimeUnit.SECONDS) : 86400000L;
        Integer maxUnclaimedRemoteResults = (Integer)properties.get("maxUnclaimedRemoteResults");
        this.maxUnclaimedRemoteResults = maxUnclaimedRemoteResults != null ? maxUnclaimedRemoteResults : 1000;
        EJBAsyncRuntimeImpl eJBAsyncRuntimeImpl = this;
        synchronized (eJBAsyncRuntimeImpl) {
            if (this.remoteAsyncResultReaper != null) {
                this.remoteAsyncResultReaper.configure(this.unclaimedRemoteResultTimeoutMillis, this.maxUnclaimedRemoteResults);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deactivate
    protected void deactivate(ComponentContext cc) {
        EJBAsyncRuntimeImpl eJBAsyncRuntimeImpl = this;
        synchronized (eJBAsyncRuntimeImpl) {
            if (this.remoteAsyncResultReaper != null) {
                this.remoteAsyncResultReaper.finalReap();
                this.remoteAsyncResultReaper = null;
            }
        }
        this.contextServiceRef.deactivate(cc);
        this.remoteRuntimeRef.deactivate(cc);
        this.scheduledExecutorServiceRef.deactivate(cc);
    }

    @Trivial
    @ManualTrace
    @FFDCIgnore(value={Throwable.class})
    public Future<?> scheduleAsync(EJSWrapperBase wrapper, EJBMethodInfoImpl methodInfo, int methodId, Object[] args) throws RemoteException {
        ServerAsyncResultImpl clientResult;
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("scheduleAsync : " + wrapper.beanId + ", " + methodInfo.getMethodName()), (Object[])new Object[0]);
        }
        RemoteAsyncResultImpl remoteResult = null;
        EJBPMICollaborator pmiBean = wrapper.ivPmiBean;
        boolean isVoidReturnType = methodInfo.getMethod().getReturnType() == Void.TYPE;
        boolean startWorkAttemped = false;
        J2EEName j2eeName = wrapper.beanId.getJ2EEName();
        String taskOwner = j2eeName.getApplication() + "/" + j2eeName.getModule() + "/" + j2eeName.getComponent();
        String taskIdentity = taskOwner + "-" + methodInfo.getMethodName();
        try {
            ServerAsyncResultImpl serverResult;
            if (!isVoidReturnType) {
                if (methodInfo.getEJBMethodInterface() == EJBMethodInterface.REMOTE) {
                    remoteResult = new RemoteAsyncResultImpl((EJBRemoteRuntime)this.remoteRuntimeRef.getServiceWithException(), this.getRemoteAsyncResultReaper(), pmiBean);
                    RemoteAsyncResult remoteStub = remoteResult.exportObject();
                    serverResult = remoteResult;
                    boolean isBusinessRmiRemote = wrapper.ivInterface == WrapperInterface.BUSINESS_RMI_REMOTE;
                    clientResult = new ClientAsyncResult(remoteStub, isBusinessRmiRemote);
                } else {
                    clientResult = serverResult = new ServerAsyncResultImpl(pmiBean);
                }
            } else {
                serverResult = null;
                clientResult = null;
            }
            AsyncMethodWrapperImpl asyncWrapper = new AsyncMethodWrapperImpl(wrapper, methodId, args, serverResult);
            HashMap<String, String> executionProperties = new HashMap<String, String>();
            executionProperties.put(MANAGEDTASK_IDENTITY_NAME, taskIdentity);
            executionProperties.put("com.ibm.ws.concurrent.TASK_OWNER", taskOwner);
            Map[] requiredContexts = null;
            WSContextService contextService = (WSContextService)this.contextServiceRef.getService();
            if (contextService == null) {
                contextService = this.defaultContextService;
                requiredContexts = DEFAULT_ASYNC_REQUIRED_CONTEXTS;
                if (isTraceOn && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Using default contextService : " + contextService), (Object[])new Object[0]);
                }
            } else if (isTraceOn && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Using configured contextService : " + contextService), (Object[])new Object[0]);
            }
            ThreadContextDescriptor tcDescriptor = contextService.captureThreadContext(executionProperties, requiredContexts);
            Runnable asyncTask = (Runnable)contextService.createContextualProxy(tcDescriptor, (Object)asyncWrapper, Runnable.class);
            if (isTraceOn && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Submitting Async Task : " + asyncTask + ", wrapper : " + (Object)((Object)asyncWrapper) + ", result : " + (Object)((Object)serverResult)), (Object[])new Object[0]);
            }
            if (pmiBean != null) {
                pmiBean.asyncQueSizeIncrement();
                startWorkAttemped = true;
            }
            if (serverResult != null) {
                serverResult.ivTaskFuture = this.executorService.submit(asyncTask);
            } else {
                this.executorService.execute(asyncTask);
            }
        }
        catch (Throwable t) {
            if (pmiBean != null) {
                if (isVoidReturnType) {
                    pmiBean.asyncFNFFailed();
                }
                if (startWorkAttemped) {
                    pmiBean.asyncQueSizeDecrement();
                }
            }
            if (remoteResult != null) {
                remoteResult.unexportObject();
            }
            if (isTraceOn && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)("scheduleAsync : EJBException: " + t));
            }
            throw ExceptionUtil.EJBException((String)"Failed to schedule asynchronous work", (Throwable)t);
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("scheduleAsync : " + (Object)((Object)clientResult)));
        }
        return clientResult;
    }

    @Trivial
    private synchronized RemoteAsyncResultReaper getRemoteAsyncResultReaper() {
        RemoteAsyncResultReaper reaper = this.remoteAsyncResultReaper;
        if (reaper == null) {
            reaper = new RemoteAsyncResultReaper((ScheduledExecutorService)this.scheduledExecutorServiceRef.getServiceWithException());
            reaper.configure(this.unclaimedRemoteResultTimeoutMillis, this.maxUnclaimedRemoteResults);
            this.remoteAsyncResultReaper = reaper;
        }
        return reaper;
    }
}

