/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.processor.impl;

import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.sib.exception.SIResourceException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.admin.SIBExceptionBase;
import com.ibm.ws.sib.msgstore.transactions.Transaction;
import com.ibm.ws.sib.processor.impl.BaseDestinationHandler;
import com.ibm.ws.sib.processor.impl.DestinationManager;
import com.ibm.ws.sib.processor.impl.MessageProcessor;
import com.ibm.ws.sib.processor.impl.interfaces.MPDestinationChangeListener;
import com.ibm.ws.sib.processor.impl.store.SIMPTransactionManager;
import com.ibm.ws.sib.processor.impl.store.itemstreams.PtoPMessageItemStream;
import com.ibm.ws.sib.processor.impl.store.itemstreams.PtoPXmitMsgsItemStream;
import com.ibm.ws.sib.processor.runtime.impl.AnycastInputControl;
import com.ibm.ws.sib.trm.dlm.Capability;
import com.ibm.ws.sib.trm.dlm.DestinationLocationChangeListener;
import com.ibm.ws.sib.utils.SIBUuid12;
import com.ibm.ws.sib.utils.SIBUuid8;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public final class DestinationChangeListener
implements DestinationLocationChangeListener {
    private static final TraceComponent tc = SibTr.register(DestinationChangeListener.class, (String)"SIBProcessor", (String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private MessageProcessor _messageProcessor;
    private DestinationManager _destinationManager;
    private SIMPTransactionManager _txManager;
    private List<MPDestinationChangeListener> _destinationChangeListeners = new ArrayList<MPDestinationChangeListener>();

    public DestinationChangeListener(MessageProcessor messageProcessor) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"DestinationChangeListener", (Object)messageProcessor);
        }
        this._messageProcessor = messageProcessor;
        this._destinationManager = messageProcessor.getDestinationManager();
        this._txManager = messageProcessor.getTXManager();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"DestinationChangeListener", (Object)this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destinationLocationChange(SIBUuid12 destId, Set additions, Set deletions, Capability capability) {
        BaseDestinationHandler destinationHandler;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"destinationLocationChange", (Object)new Object[]{destId, additions, deletions, capability});
        }
        if ((destinationHandler = (BaseDestinationHandler)this._destinationManager.getDestinationInternal(destId, false)) != null) {
            Set localitySet = this.getDestinationLocalitySet(destinationHandler, capability);
            BaseDestinationHandler baseDestinationHandler = destinationHandler;
            synchronized (baseDestinationHandler) {
                if (!destinationHandler.isToBeDeleted()) {
                    for (SIBUuid8 meUuid : deletions) {
                        PtoPXmitMsgsItemStream ptoPMessageItemStream;
                        if (meUuid.equals((Object)this._messageProcessor.getMessagingEngineUuid()) || (ptoPMessageItemStream = destinationHandler.getXmitQueuePoint(meUuid)) == null || localitySet != null && localitySet.contains(meUuid.toString())) continue;
                        this.cleanupDestination(ptoPMessageItemStream, destinationHandler, meUuid, capability);
                    }
                    if (capability != Capability.GET) {
                        destinationHandler.requestReallocation();
                    }
                }
            }
        }
        for (int i = 0; i < this._destinationChangeListeners.size(); ++i) {
            MPDestinationChangeListener listener = this._destinationChangeListeners.get(i);
            if (listener == null) continue;
            listener.destinationLocationChange(destId, additions, deletions, capability);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"destinationLocationChange");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destinationUnavailable(SIBUuid12 destId, Capability capability) {
        boolean isNotLink;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"destinationUnavailable", (Object)new Object[]{destId, capability});
        }
        HashSet available = new HashSet();
        HashSet<SIBUuid8> unavailable = new HashSet<SIBUuid8>();
        BaseDestinationHandler destinationHandler = (BaseDestinationHandler)this._destinationManager.getDestinationInternal(destId, false);
        if (destinationHandler != null && !destinationHandler.isLink()) {
            Set localitySet = this.getDestinationLocalitySet(destinationHandler, capability);
            BaseDestinationHandler baseDestinationHandler = destinationHandler;
            synchronized (baseDestinationHandler) {
                if (!destinationHandler.isToBeDeleted()) {
                    Iterator<PtoPMessageItemStream> i = null;
                    i = destinationHandler.getLocalisationManager().getXmitQueueIterator();
                    while (i.hasNext()) {
                        PtoPMessageItemStream ptoPMessageItemStream = i.next();
                        SIBUuid8 meUuid = ptoPMessageItemStream.getLocalizingMEUuid();
                        unavailable.add(meUuid);
                        if (localitySet != null && localitySet.contains(meUuid.toString())) continue;
                        this.cleanupDestination(ptoPMessageItemStream, destinationHandler, meUuid, capability);
                    }
                    Iterator<AnycastInputControl> it = destinationHandler.getAIControlAdapterIterator();
                    while (it.hasNext()) {
                        unavailable.add(it.next().getDMEUuid());
                    }
                    if (capability != Capability.GET) {
                        destinationHandler.requestReallocation();
                    }
                }
            }
        }
        boolean bl = isNotLink = destinationHandler == null || destinationHandler != null && !destinationHandler.isLink();
        if (isNotLink) {
            for (int i = 0; i < this._destinationChangeListeners.size(); ++i) {
                MPDestinationChangeListener listener = this._destinationChangeListeners.get(i);
                if (listener == null) continue;
                listener.destinationLocationChange(destId, available, unavailable, capability);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"destinationUnavailable");
        }
    }

    public void addMPDestinationChangeListener(MPDestinationChangeListener destinationChangeListener) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"addMPDestinationChangeListener", (Object)new Object[]{destinationChangeListener});
        }
        this._destinationChangeListeners.add(destinationChangeListener);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"addMPDestinationChangeListener");
        }
    }

    public void removeMPDestinationChangeListener(MPDestinationChangeListener destinationChangeListener) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"removeMPDestinationChangeListener", (Object)new Object[]{destinationChangeListener});
        }
        this._destinationChangeListeners.remove(destinationChangeListener);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"removeMPDestinationChangeListener");
        }
    }

    private Set getDestinationLocalitySet(BaseDestinationHandler destinationHandler, Capability capability) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getDestinationLocalitySet", (Object)new Object[]{destinationHandler, capability});
        }
        Set localitySet = null;
        try {
            localitySet = this._messageProcessor.getSIBDestinationLocalitySet(null, destinationHandler.getUuid().toString(), true);
        }
        catch (SIBExceptionBase e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.DestinationChangeListener.getDestinationLocalitySet", (String)"1:368:1.45", (Object)this);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getDestinationLocalitySet", (Object)localitySet);
        }
        return localitySet;
    }

    private void cleanupDestination(PtoPMessageItemStream ptoPMessageItemStream, BaseDestinationHandler destinationHandler, SIBUuid8 meUuid, Capability capability) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"cleanupDestination", (Object)new Object[]{ptoPMessageItemStream, destinationHandler, meUuid, capability});
        }
        try {
            ptoPMessageItemStream.markAsToBeDeleted((Transaction)this._txManager.createAutoCommitTransaction());
            destinationHandler.closeRemoteConsumer(meUuid);
        }
        catch (SIResourceException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.DestinationChangeListener.cleanupDestination", (String)"1:424:1.45", (Object)this);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"cleanupDestination");
        }
    }
}

