/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.processor.impl;

import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.sib.processor.impl.exceptions.InvalidFlowsException;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.messagecontrol.Flow;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;

public class JSConsumerClassifications {
    private static final TraceComponent tc = SibTr.register(JSConsumerClassifications.class, (String)"SIBProcessor", (String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private Flow[] flows = null;
    private int numberOfClasses;
    private Random rand;
    private HashMap<String, ClassWeight> messageClasses = null;
    private ArrayList<String> classificationNames = null;
    private HashMap<Integer, Integer> weightMap = null;

    public JSConsumerClassifications(String csLabel) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"JSConsumerClassifications", (Object)csLabel);
        }
        this.numberOfClasses = 0;
        this.rand = new Random(System.currentTimeMillis());
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"JSConsumerClassifications", (Object)this);
        }
    }

    public boolean setClassifications(Flow[] newFlows) throws InvalidFlowsException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"setClassifications", (Object)newFlows);
        }
        boolean noClassChange = true;
        if (this.flows == null || this.flows.length != newFlows.length) {
            noClassChange = false;
        }
        ArrayList<String> newClassificationNames = new ArrayList<String>();
        HashMap<String, ClassWeight> newMessageClasses = new HashMap<String, ClassWeight>();
        HashMap<Integer, Integer> newWeightMap = new HashMap<Integer, Integer>();
        newClassificationNames.add(0, "$SIdefault");
        for (int i = 0; i < newFlows.length; ++i) {
            ClassWeight classWeight;
            ClassWeight cw;
            String nextClassificationName = newFlows[i].getClassification();
            if (noClassChange && !this.classificationNames.contains(nextClassificationName)) {
                noClassChange = false;
            }
            if ((cw = newMessageClasses.put(nextClassificationName, classWeight = new ClassWeight(i + 1, newFlows[i].getWeighting()))) != null) {
                InvalidFlowsException ife = new InvalidFlowsException();
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"setClassifications", (Object)ife);
                }
                throw ife;
            }
            newClassificationNames.add(i + 1, nextClassificationName);
            newWeightMap.put(i + 1, newFlows[i].getWeighting());
        }
        this.classificationNames = newClassificationNames;
        this.messageClasses = newMessageClasses;
        this.weightMap = newWeightMap;
        this.flows = (Flow[])newFlows.clone();
        this.numberOfClasses = this.flows.length;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"setClassifications", (Object)noClassChange);
        }
        return noClassChange;
    }

    public int getNumberOfClasses() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getNumberOfClasses");
            SibTr.exit((TraceComponent)tc, (String)"getNumberOfClasses", (Object)this.numberOfClasses);
        }
        return this.numberOfClasses;
    }

    public int getPosition(String classificationName) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getPosition", (Object)classificationName);
        }
        int classPos = 0;
        ClassWeight cw = this.messageClasses.get(classificationName);
        if (cw != null) {
            classPos = cw.getPosition();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getPosition", (Object)classPos);
        }
        return classPos;
    }

    public int getWeight(String classificationName) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getWeight", (Object)classificationName);
        }
        int weight = 0;
        ClassWeight cw = this.messageClasses.get(classificationName);
        if (cw != null) {
            weight = cw.getWeight();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getWeight", (Object)weight);
        }
        return weight;
    }

    public HashMap<Integer, Integer> getWeightings() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getWeightings");
        }
        HashMap clonedWeightMap = (HashMap)this.weightMap.clone();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getWeightings", (Object)clonedWeightMap);
        }
        return clonedWeightMap;
    }

    public int findClassIndex(HashMap<Integer, Integer> weightMap) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"findClassIndex");
        }
        int classPos = 0;
        int randWeight = 0;
        int totalWeight = 0;
        for (Integer weight : weightMap.values()) {
            totalWeight += weight.intValue();
        }
        if (totalWeight > 0) {
            randWeight = Math.abs(this.rand.nextInt() % totalWeight);
            Iterator<Map.Entry<Integer, Integer>> iter2 = weightMap.entrySet().iterator();
            int aggregateWeight = 0;
            while (iter2.hasNext()) {
                Map.Entry<Integer, Integer> entry = iter2.next();
                Integer mappos = entry.getKey();
                Integer weight = entry.getValue();
                classPos = mappos;
                if (randWeight > (aggregateWeight += weight.intValue())) continue;
                break;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"findClassIndex", (Object)classPos);
        }
        return classPos;
    }

    public synchronized String getClassification(int index) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getClassification", (Object)index);
        }
        String name = this.classificationNames.get(index);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getClassification", (Object)name);
        }
        return name;
    }

    public Flow[] getFlows() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getFlows");
        }
        Flow[] clonedFlows = (Flow[])this.flows.clone();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getFlows", (Object)clonedFlows);
        }
        return clonedFlows;
    }

    private static class ClassWeight {
        private int position;
        private int weight;

        public ClassWeight(int position, int weight) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"ClassWeight", (Object)new Object[]{position, weight});
                SibTr.exit((TraceComponent)tc, (String)"ClassWeight");
            }
            this.position = position;
            this.weight = weight;
        }

        public String toString() {
            return "index: " + this.position + ", weight: " + this.weight;
        }

        public int getPosition() {
            return this.position;
        }

        public int getWeight() {
            return this.weight;
        }
    }
}

