/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.processor.impl.destination;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.sib.exception.SIErrorException;
import com.ibm.websphere.sib.exception.SIIncorrectCallException;
import com.ibm.websphere.sib.exception.SIResourceException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.msgstore.transactions.Transaction;
import com.ibm.ws.sib.processor.impl.BaseDestinationHandler;
import com.ibm.ws.sib.processor.impl.MessageProcessor;
import com.ibm.ws.sib.processor.impl.PtoPOutputHandler;
import com.ibm.ws.sib.processor.impl.destination.JSPtoPRealization;
import com.ibm.ws.sib.processor.impl.destination.LocalisationManager;
import com.ibm.ws.sib.processor.impl.interfaces.OutputHandler;
import com.ibm.ws.sib.processor.impl.store.itemstreams.PtoPMessageItemStream;
import com.ibm.ws.sib.processor.impl.store.itemstreams.PtoPXmitMsgsItemStream;
import com.ibm.ws.sib.transactions.LocalTransaction;
import com.ibm.ws.sib.transactions.TransactionCallback;
import com.ibm.ws.sib.transactions.TransactionCommon;
import com.ibm.ws.sib.trm.links.LinkManager;
import com.ibm.ws.sib.trm.links.LinkSelection;
import com.ibm.ws.sib.utils.SIBUuid12;
import com.ibm.ws.sib.utils.SIBUuid8;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.util.HashMap;
import java.util.Iterator;

public class LinkState
extends JSPtoPRealization {
    private static final TraceComponent tc = SibTr.register(LinkState.class, (String)"SIBProcessor", (String)"com.ibm.ws.sib.processor.CWSIPMessages");
    static final TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private OutputHandler _lastKnownMEOutputHandler = null;
    HashMap _deletedQueuePoints = null;

    public LinkState(BaseDestinationHandler myBaseDestinationHandler, MessageProcessor messageProcessor, LocalisationManager localisationManager) {
        super(myBaseDestinationHandler, messageProcessor, localisationManager);
    }

    @Override
    public void initialise() {
        super.initialise();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"initialise");
        }
        this._deletedQueuePoints = new HashMap();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"initialise");
        }
    }

    public OutputHandler choosePtoPOutputHandler(SIBUuid12 linkUuid) throws SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"choosePtoPOutputHandler", (Object)linkUuid);
        }
        OutputHandler result = null;
        LinkSelection s = null;
        if (this.isLocalMsgsItemStream()) {
            result = (OutputHandler)((Object)this.getLocalPtoPConsumerManager());
            result.setWLMGuess(false);
        } else {
            s = this._localisationManager.getTRMFacade().chooseLink(linkUuid);
            if (s == null) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)"Link not available in WLM");
                }
                if (this._lastKnownMEOutputHandler == null) {
                    SIBUuid8 localisingME = new SIBUuid8("0000000000000001");
                    this.updateLocalisationSet(localisingME, localisingME);
                }
                result = this._lastKnownMEOutputHandler;
                result.setWLMGuess(true);
            } else {
                SIBUuid8 choiceUuid = s.getInboundMeUuid();
                SIBUuid8 routingUuid = s.getOutboundMeUuid();
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)("InboundMeUuid is " + choiceUuid + " OutboundMeUuid is  " + routingUuid));
                }
                if (choiceUuid == null) {
                    choiceUuid = s.getOutboundMeUuid();
                }
                if ((result = this.getQueuePointOutputHandler(choiceUuid)) == null) {
                    this.updateLocalisationSet(choiceUuid, routingUuid);
                    result = this.getQueuePointOutputHandler(choiceUuid);
                }
                result.setWLMGuess(false);
                if (routingUuid != null) {
                    if (routingUuid.equals((Object)this._messageProcessor.getMessagingEngineUuid())) {
                        routingUuid = choiceUuid;
                    }
                    ((PtoPOutputHandler)result).updateRoutingCellule(routingUuid);
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"choosePtoPOutputHandler", (Object)result);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SIBUuid8 updateLocalisationSet(SIBUuid8 newLocalisingMEUuid, SIBUuid8 newRoutingMEUuid) throws SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"updateLocalisationSet", (Object)new Object[]{newLocalisingMEUuid, newRoutingMEUuid});
        }
        LocalTransaction transaction = this._baseDestinationHandler.getTransactionManager().createLocalTransaction(false);
        Transaction msTran = this._messageProcessor.resolveAndEnlistMsgStoreTransaction((TransactionCommon)transaction);
        boolean rollback = true;
        SIBUuid8 existingUuid = null;
        try {
            HashMap hashMap = this._localisationManager.getAllXmitQueuePoints();
            synchronized (hashMap) {
                HashMap<SIBUuid8, PtoPXmitMsgsItemStream> validXmits = new HashMap<SIBUuid8, PtoPXmitMsgsItemStream>();
                for (PtoPXmitMsgsItemStream xmit : this._localisationManager.getAllXmitQueuePoints().values()) {
                    if (xmit.isToBeDeleted()) {
                        this._deletedQueuePoints.put(xmit.getLocalizingMEUuid(), xmit);
                        continue;
                    }
                    validXmits.put(xmit.getLocalizingMEUuid(), xmit);
                }
                if (validXmits.size() > 1 || validXmits.size() > 0 && this._pToPLocalMsgsItemStream != null) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        SibTr.exit((TraceComponent)tc, (String)"updateLocalisationSet");
                    }
                    SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0001", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.LinkHandler", "1:302:1.21"});
                    throw new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0001", new Object[]{"com.ibm.ws.sib.processor.impl.destination.LinkState", "1:308:1.21"}, null));
                }
                PtoPMessageItemStream deletingItemStream = (PtoPMessageItemStream)this._deletedQueuePoints.get(newLocalisingMEUuid);
                if (deletingItemStream != null && !deletingItemStream.isInStore()) {
                    deletingItemStream = null;
                }
                if (validXmits.size() == 0 && this._pToPLocalMsgsItemStream == null) {
                    if (deletingItemStream != null) {
                        deletingItemStream.unmarkAsToBeDeleted(msTran);
                        this._deletedQueuePoints.remove(newLocalisingMEUuid);
                        this._localisationManager.attachRemotePtoPLocalisation(deletingItemStream, this._remoteSupport);
                        this.assignQueuePointOutputHandler(deletingItemStream.getOutputHandler(), newLocalisingMEUuid);
                    } else {
                        PtoPMessageItemStream newStream = this._localisationManager.addNewRemotePtoPLocalization((TransactionCommon)transaction, newLocalisingMEUuid, null, true, this._remoteSupport);
                        ((PtoPOutputHandler)newStream.getOutputHandler()).updateRoutingCellule(newRoutingMEUuid);
                    }
                } else {
                    PtoPMessageItemStream ptoPMessageItemStream = null;
                    if (this._pToPLocalMsgsItemStream == null) {
                        PtoPOutputHandler outputHandler;
                        block36: {
                            Iterator transmitQueueIterator = validXmits.values().iterator();
                            ptoPMessageItemStream = (PtoPMessageItemStream)transmitQueueIterator.next();
                            outputHandler = (PtoPOutputHandler)ptoPMessageItemStream.getOutputHandler();
                            existingUuid = ptoPMessageItemStream.getLocalizingMEUuid();
                            if (!newLocalisingMEUuid.toString().equals("0000000000000001")) {
                                if (existingUuid.equals((Object)newLocalisingMEUuid) || existingUuid.equals((Object)new SIBUuid8("0000000000000001"))) {
                                    ptoPMessageItemStream.replaceUuid(newLocalisingMEUuid, msTran);
                                    this._localisationManager.removeXmitQueuePoint(existingUuid);
                                    this._localisationManager.addXmitQueuePoint(newLocalisingMEUuid, ptoPMessageItemStream);
                                    outputHandler.updateTargetCellule(newLocalisingMEUuid);
                                    this._localisationManager.updateQueuePointOutputHandler(newLocalisingMEUuid, outputHandler, existingUuid);
                                } else {
                                    if (deletingItemStream != null) {
                                        deletingItemStream.unmarkAsToBeDeleted(msTran);
                                        this._deletedQueuePoints.remove(newLocalisingMEUuid);
                                        this._localisationManager.addXmitQueuePoint(deletingItemStream.getLocalizingMEUuid(), deletingItemStream);
                                        this.assignQueuePointOutputHandler(deletingItemStream.getOutputHandler(), newLocalisingMEUuid);
                                    } else {
                                        PtoPMessageItemStream newStream = this._localisationManager.addNewRemotePtoPLocalization((TransactionCommon)transaction, newLocalisingMEUuid, null, true, this._remoteSupport);
                                        ((PtoPOutputHandler)newStream.getOutputHandler()).updateRoutingCellule(newRoutingMEUuid);
                                    }
                                    LocalisationManager localisationManager = this._localisationManager;
                                    localisationManager.getClass();
                                    transaction.registerCallback((TransactionCallback)new LocalisationManager.LocalizationRemoveTransactionCallback(localisationManager, ptoPMessageItemStream));
                                    ptoPMessageItemStream.markAsToBeDeleted(msTran);
                                    this._deletedQueuePoints.put(existingUuid, ptoPMessageItemStream);
                                    this._destinationManager.markDestinationAsCleanUpPending(this._baseDestinationHandler);
                                    if (this._messageProcessor.getProxyHandler().getNeighbour(existingUuid, true) != null) {
                                        try {
                                            this._messageProcessor.getProxyHandler().deleteNeighbourForced(existingUuid, this._baseDestinationHandler.getBus(), (Transaction)transaction);
                                        }
                                        catch (Exception e) {
                                            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.destination.LinkState.updateLocalisationSet", (String)"1:473:1.21", (Object)this);
                                            if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block36;
                                            SibTr.debug((TraceComponent)tc, (String)("Caught exception when deleting neighbour, however this is not always an issue as it might have already been removed: " + e));
                                        }
                                    }
                                }
                            }
                        }
                        if (newRoutingMEUuid != null) {
                            if (newRoutingMEUuid.equals((Object)this._messageProcessor.getMessagingEngineUuid())) {
                                newRoutingMEUuid = newLocalisingMEUuid;
                            }
                            outputHandler.updateRoutingCellule(newRoutingMEUuid);
                        }
                    }
                }
            }
            rollback = false;
        }
        finally {
            try {
                if (rollback) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        SibTr.debug((TraceComponent)tc, (String)"Update failed, transaction rolling back");
                    }
                    transaction.rollback();
                } else {
                    transaction.commit();
                }
            }
            catch (SIIncorrectCallException e) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"updateLocalisationSet", (Object)((Object)e));
                }
                throw new SIResourceException((Throwable)e);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"updateLocalisationSet", (Object)existingUuid);
        }
        return existingUuid;
    }

    @Override
    public void assignQueuePointOutputHandler(OutputHandler outputHandler, SIBUuid8 messagingEngineUuid) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"assignQueuePointOutputHandler", (Object)new Object[]{outputHandler, messagingEngineUuid});
        }
        this._localisationManager.assignQueuePointOutputHandler(outputHandler, messagingEngineUuid);
        this._lastKnownMEOutputHandler = outputHandler;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"assignQueuePointOutputHandler");
        }
    }

    public SIBUuid8 getRemoteMEUuid(SIBUuid12 linkUuid) throws SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getRemoteMEUuid", (Object)linkUuid);
        }
        LinkSelection s = null;
        SIBUuid8 remoteMEUuid = null;
        s = this._localisationManager.getTRMFacade().chooseLink(linkUuid);
        remoteMEUuid = s == null ? null : s.getInboundMeUuid();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getRemoteMEUuid", (Object)remoteMEUuid);
        }
        return remoteMEUuid;
    }

    public void setLinkManager(LinkManager linkManager) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"setLinkManager", (Object)linkManager);
        }
        this._localisationManager.getTRMFacade().setLinkManager(linkManager);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"setLinkManager");
        }
    }

    @Override
    public void registerControlAdapters() {
    }
}

