/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.processor.proxyhandler;

import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.sib.Reliability;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.mfp.control.SubscriptionMessage;
import com.ibm.ws.sib.mfp.control.SubscriptionMessageType;
import com.ibm.ws.sib.mfp.impl.ControlMessageFactory;
import com.ibm.ws.sib.processor.impl.MessageProcessor;
import com.ibm.ws.sib.processor.proxyhandler.MESubscription;
import com.ibm.ws.sib.processor.proxyhandler.MultiMEProxyHandler;
import com.ibm.ws.sib.utils.SIBUuid8;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.util.ArrayList;
import java.util.List;

final class SubscriptionMessageHandler {
    private static final TraceComponent tc = SibTr.register(SubscriptionMessageHandler.class, (String)"SIBProcessor", (String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private SubscriptionMessage iSubscriptionMessage;
    private List iTopics;
    private List iTopicSpaces;
    private List iTopicSpaceMappings;
    private String iMEName;
    private SIBUuid8 iMEUUID;
    private String iBusName;
    private MultiMEProxyHandler iProxyHandler;
    private boolean iInitialised = false;

    protected SubscriptionMessageHandler(MultiMEProxyHandler proxyHandler) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"SubscriptionMessageHandler", (Object)((Object)proxyHandler));
        }
        this.iProxyHandler = proxyHandler;
        this.iTopics = new ArrayList();
        this.iTopicSpaces = new ArrayList();
        this.iTopicSpaceMappings = new ArrayList();
        this.iMEName = null;
        this.iMEUUID = null;
        this.iBusName = null;
        this.iMEName = this.iProxyHandler.getMessageProcessor().getMessagingEngineName();
        this.iMEUUID = this.iProxyHandler.getMessageProcessor().getMessagingEngineUuid();
        this.iBusName = this.iProxyHandler.getMessageProcessor().getMessagingEngineBus();
        this.iSubscriptionMessage = this.createSubscriptionMessage();
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"SubscriptionMessageHandler", (Object)this);
        }
    }

    private SubscriptionMessage createSubscriptionMessage() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"createSubscriptionMessage");
        }
        ControlMessageFactory factory = null;
        SubscriptionMessage subscriptionMessage = null;
        try {
            factory = MessageProcessor.getControlMessageFactory();
            subscriptionMessage = factory.createNewSubscriptionMessage();
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.proxyhandler.SubscriptionMessageHandler.createSubscriptionMessage", (String)"1:162:1.34", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)e);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"createSubscriptionMessage", (Object)subscriptionMessage);
        }
        return subscriptionMessage;
    }

    private void reset() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"reset");
        }
        if (this.iInitialised) {
            this.iTopics.clear();
            this.iTopicSpaces.clear();
            this.iTopicSpaceMappings.clear();
            this.iSubscriptionMessage = this.createSubscriptionMessage();
        } else {
            this.iInitialised = true;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"reset");
        }
    }

    protected void resetCreateSubscriptionMessage(MESubscription subscription, boolean isLocalBus) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"resetCreateSubscriptionMessage", (Object)new Object[]{subscription, new Boolean(isLocalBus)});
        }
        this.reset();
        this.iSubscriptionMessage.setSubscriptionMessageType(SubscriptionMessageType.CREATE);
        this.iTopics.add(subscription.getTopic());
        if (isLocalBus) {
            this.iTopicSpaces.add(subscription.getTopicSpaceUuid().toString());
        } else {
            this.iTopicSpaces.add(subscription.getTopicSpaceName().toString());
        }
        this.iTopicSpaceMappings.add(subscription.getForeignTSName());
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"resetCreateSubscriptionMessage");
        }
    }

    protected void resetDeleteSubscriptionMessage(MESubscription subscription, boolean isLocalBus) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"resetDeleteSubscriptionMessage", (Object)new Object[]{subscription, new Boolean(isLocalBus)});
        }
        this.reset();
        this.iSubscriptionMessage.setSubscriptionMessageType(SubscriptionMessageType.DELETE);
        this.iTopics.add(subscription.getTopic());
        if (isLocalBus) {
            this.iTopicSpaces.add(subscription.getTopicSpaceUuid().toString());
        } else {
            this.iTopicSpaces.add(subscription.getTopicSpaceName().toString());
        }
        this.iTopicSpaceMappings.add(subscription.getForeignTSName());
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"resetDeleteSubscriptionMessage");
        }
    }

    protected void resetDeleteSubscriptionMessage() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"resetDeleteSubscriptionMessage");
        }
        this.reset();
        this.iSubscriptionMessage.setSubscriptionMessageType(SubscriptionMessageType.DELETE);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"resetDeleteSubscriptionMessage");
        }
    }

    protected void resetResetSubscriptionMessage() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"resetResetSubscriptionMessage");
        }
        this.reset();
        this.iSubscriptionMessage.setSubscriptionMessageType(SubscriptionMessageType.RESET);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"resetResetSubscriptionMessage");
        }
    }

    protected void resetReplySubscriptionMessage() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"resetReplySubscriptionMessage");
        }
        this.reset();
        this.iSubscriptionMessage.setSubscriptionMessageType(SubscriptionMessageType.REPLY);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"resetReplySubscriptionMessage");
        }
    }

    protected void addSubscriptionToMessage(MESubscription subscription, boolean isLocalBus) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"addSubscriptionToMessage", (Object)new Object[]{subscription, new Boolean(isLocalBus)});
        }
        this.iTopics.add(subscription.getTopic());
        if (isLocalBus) {
            this.iTopicSpaces.add(subscription.getTopicSpaceUuid().toString());
        } else {
            this.iTopicSpaces.add(subscription.getTopicSpaceName().toString());
        }
        this.iTopicSpaceMappings.add(subscription.getForeignTSName());
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"addSubscriptionToMessage");
        }
    }

    protected SubscriptionMessage getSubscriptionMessage() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getSubscriptionMessage");
        }
        this.iSubscriptionMessage.setTopics(this.iTopics);
        this.iSubscriptionMessage.setMEName(this.iMEName);
        this.iSubscriptionMessage.setMEUUID(this.iMEUUID.toByteArray());
        this.iSubscriptionMessage.setBusName(this.iBusName);
        this.iSubscriptionMessage.setReliability(Reliability.ASSURED_PERSISTENT);
        this.iSubscriptionMessage.setTopicSpaces(this.iTopicSpaces);
        this.iSubscriptionMessage.setTopicSpaceMappings(this.iTopicSpaceMappings);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getSubscriptionMessage", (Object)new Object[]{this.iTopics, this.iMEName, this.iMEUUID, this.iBusName, this.iTopicSpaces, this.iTopicSpaceMappings});
        }
        return this.iSubscriptionMessage;
    }
}

