/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.processor.runtime.impl;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.ws.sib.processor.impl.exceptions.InvalidOperationException;
import com.ibm.ws.sib.processor.impl.interfaces.ControllableResource;
import com.ibm.ws.sib.processor.runtime.SIMPControllable;
import com.ibm.ws.sib.processor.runtime.SIMPIterator;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class ControllableIterator
implements SIMPIterator {
    private static final TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private Iterator parent;
    SIMPControllable next = null;

    public ControllableIterator(Iterator parent) {
        this.parent = parent;
    }

    public boolean hasNext() {
        while (this.next == null) {
            try {
                this.next = (SIMPControllable)this.next();
            }
            catch (NoSuchElementException e) {
                // empty catch block
                break;
            }
        }
        boolean hasNext = this.next != null;
        return hasNext;
    }

    public Object next() {
        SIMPControllable control = null;
        if (this.next == null) {
            ControllableResource controllable = (ControllableResource)this.parent.next();
            if (controllable != null) {
                control = controllable.getControlAdapter();
            }
            while (control == null) {
                controllable = (ControllableResource)this.parent.next();
                if (controllable == null) continue;
                control = controllable.getControlAdapter();
            }
        } else {
            control = this.next;
            this.next = null;
        }
        return control;
    }

    public void remove() {
        throw new InvalidOperationException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0001", new Object[]{"com.ibm.ws.sib.processor.runtime.ControllableIterator", "1:110:1.12"}, null));
    }

    public void finished() {
        if (this.parent instanceof SIMPIterator) {
            ((SIMPIterator)this.parent).finished();
        }
    }
}

