/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.event.internal;

import com.ibm.websphere.event.Event;
import com.ibm.websphere.event.EventEngine;
import com.ibm.websphere.event.EventHandle;
import com.ibm.websphere.event.ExecutorServiceFactory;
import com.ibm.websphere.event.Topic;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.event.internal.CurrentEvent;
import com.ibm.ws.event.internal.EventImpl;
import com.ibm.ws.event.internal.HandlerHolder;
import com.ibm.ws.event.internal.TopicBasedCache;
import com.ibm.ws.event.internal.TopicData;
import com.ibm.ws.event.internal.adapter.BundleEventAdapter;
import com.ibm.ws.event.internal.adapter.FrameworkEventAdapter;
import com.ibm.ws.event.internal.adapter.ServiceEventAdapter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleListener;
import org.osgi.framework.FrameworkListener;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.event.EventAdmin;
import org.osgi.service.event.EventHandler;
import org.osgi.service.event.TopicPermission;
import org.osgi.service.log.LogService;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@Component(configurationPid={"com.ibm.ws.event"}, property={"service.vendor=IBM"})
public class EventEngineImpl
implements EventEngine,
EventAdmin {
    private static final TraceComponent tc = Tr.register(EventEngineImpl.class);
    static final String OSGI_EVENT_HANDLER_REFERENCE_NAME = "OsgiEventHandler";
    static final String WS_EVENT_HANDLER_REFERENCE_NAME = "WsEventHandler";
    private static final String CFG_KEY_REENTRANT_HANDLER_DEFAULT = "reentrant.handler.default";
    private static final String CFG_KEY_STAGE_PREFIX = "stage.topics.";
    private final TopicBasedCache topicCache = new TopicBasedCache(this);
    private ComponentContext componentContext;
    private BundleContext bundleContext;
    private LogService logService;
    private FrameworkEventAdapter frameworkEventAdapter;
    private BundleEventAdapter bundleEventAdapter;
    private ServiceEventAdapter serviceEventAdapter;
    protected ExecutorServiceFactory executorServiceFactory;
    private boolean defaultReentrancy = false;
    private static final boolean skipSchedule = Boolean.getBoolean("com.ibm.ws.event.skipSchedule");
    static final long serialVersionUID = -3714378010555321089L;

    @Override
    public EventImpl createEvent(Topic topic) {
        return new EventImpl(topic);
    }

    @Override
    public EventImpl createEvent(String topic) {
        return new EventImpl(this.getTopic(topic));
    }

    Topic getTopic(String topicName) {
        return new Topic(topicName);
    }

    @Override
    public EventHandle sendEvent(Topic topic, Map<?, ?> properties) {
        EventImpl event = this.createEvent(topic);
        if (null != properties) {
            for (Map.Entry<?, ?> entry : properties.entrySet()) {
                event.setProperty((String)entry.getKey(), entry.getValue());
            }
        }
        return this.sendEvent(event);
    }

    @Override
    public EventHandle sendEvent(String topic, Map<?, ?> properties) {
        EventImpl event = this.createEvent(topic);
        if (null != properties) {
            for (Map.Entry<?, ?> entry : properties.entrySet()) {
                event.setProperty((String)entry.getKey(), entry.getValue());
            }
        }
        return this.sendEvent(event);
    }

    @Override
    public EventHandle sendEvent(Event event) {
        return this.publishEvent(event, false);
    }

    @Override
    public void sendEvent(org.osgi.service.event.Event event) {
        this.publishOsgiEvent(event, false);
    }

    @Override
    public EventHandle postEvent(Event event) {
        return this.publishEvent(event, true);
    }

    @Override
    public EventHandle postEvent(String topic, Map<?, ?> properties) {
        EventImpl event = this.createEvent(topic);
        if (null != properties) {
            for (Map.Entry<?, ?> entry : properties.entrySet()) {
                event.setProperty((String)entry.getKey(), entry.getValue());
            }
        }
        return this.postEvent(event);
    }

    @Override
    public EventHandle postEvent(Topic topic, Map<?, ?> properties) {
        return this.postEvent(topic, properties, null);
    }

    @Override
    public EventHandle postEvent(Topic topic, Map<?, ?> properties, Event parent) {
        EventImpl event = this.createEvent(topic);
        if (null != properties) {
            for (Map.Entry<?, ?> entry : properties.entrySet()) {
                event.setProperty((String)entry.getKey(), entry.getValue());
            }
        }
        if (parent != null) {
            event.setParent((EventImpl)parent);
        }
        return this.postEvent(event);
    }

    @Override
    public void postEvent(org.osgi.service.event.Event event) {
        this.publishOsgiEvent(event, true);
    }

    void publishOsgiEvent(org.osgi.service.event.Event event, boolean async) {
        String topic = event.getTopic();
        EventImpl e = this.createEvent(topic);
        for (String key : event.getPropertyNames()) {
            e.setProperty(key, event.getProperty(key));
        }
        this.publishEvent(e, async);
    }

    public EventImpl publishEvent(Event event, boolean async) {
        Topic topic;
        EventImpl eventImpl = (EventImpl)event;
        eventImpl.setReadOnly(true);
        EventImpl currentEvent = (EventImpl)CurrentEvent.get();
        if (null != currentEvent) {
            eventImpl.setParent(currentEvent);
        }
        String topicName = (topic = eventImpl.getTopicObject()) != null ? topic.getName() : eventImpl.getTopic();
        TopicData topicData = this.topicCache.getTopicData(topic, topicName);
        eventImpl.setTopicData(topicData);
        this.checkTopicPublishPermission(topicName);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)"Publishing Event", (Object[])new Object[]{topicName});
        }
        List<HandlerHolder> holders = topicData.getEventHandlers();
        ExecutorService executor = topicData.getExecutorService();
        if (async) {
            int i = 0;
            Future[] futures = new Future[holders.size()];
            for (HandlerHolder holder : holders) {
                holder.addEvent(eventImpl);
                futures[i++] = this.queueWorkRequest(holder, executor);
            }
            eventImpl.setFutures(futures);
        } else {
            for (HandlerHolder holder : holders) {
                holder.fireSynchronousEvent(eventImpl);
            }
        }
        return eventImpl;
    }

    void checkTopicPublishPermission(String topic) {
        SecurityManager sm = System.getSecurityManager();
        if (sm == null) {
            return;
        }
        sm.checkPermission(new TopicPermission(topic, "publish"));
    }

    @Activate
    protected void activate(ComponentContext componentContext, Map<String, Object> props) {
        this.componentContext = componentContext;
        this.bundleContext = componentContext.getBundleContext();
        this.frameworkEventAdapter = new FrameworkEventAdapter(this);
        this.bundleContext.addFrameworkListener((FrameworkListener)this.frameworkEventAdapter);
        this.bundleEventAdapter = new BundleEventAdapter(this);
        this.bundleContext.addBundleListener((BundleListener)this.bundleEventAdapter);
        this.serviceEventAdapter = new ServiceEventAdapter(this);
        this.bundleContext.addServiceListener((ServiceListener)this.serviceEventAdapter);
        this.processConfigProperties(props);
    }

    @Modified
    protected void modified(Map<String, Object> props) {
        this.processConfigProperties(props);
    }

    @Deactivate
    protected void deactivate(ComponentContext componentContext) {
        this.bundleContext.removeFrameworkListener((FrameworkListener)this.frameworkEventAdapter);
        this.frameworkEventAdapter = null;
        this.bundleContext.removeBundleListener((BundleListener)this.bundleEventAdapter);
        this.bundleEventAdapter = null;
        this.bundleContext.removeServiceListener((ServiceListener)this.serviceEventAdapter);
        this.serviceEventAdapter = null;
        this.bundleContext = null;
        this.componentContext = null;
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    protected void setOsgiEventHandler(ServiceReference<EventHandler> handlerReference) {
        this.topicCache.addHandler(handlerReference, true);
    }

    protected void updatedOsgiEventHandler(ServiceReference<EventHandler> handlerReference) {
        this.topicCache.updateHandler(handlerReference, true);
    }

    protected void unsetOsgiEventHandler(ServiceReference<EventHandler> handlerReference) {
        this.topicCache.removeHandler(handlerReference);
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    protected void setWsEventHandler(ServiceReference<com.ibm.websphere.event.EventHandler> handlerReference) {
        this.topicCache.addHandler(handlerReference, false);
    }

    protected void updatedWsEventHandler(ServiceReference<com.ibm.websphere.event.EventHandler> handlerReference) {
        this.topicCache.updateHandler(handlerReference, false);
    }

    protected void unsetWsEventHandler(ServiceReference<com.ibm.websphere.event.EventHandler> handlerReference) {
        this.topicCache.removeHandler(handlerReference);
    }

    private void processConfigProperties(Map<String, Object> properties) {
        Object value = properties.get(CFG_KEY_REENTRANT_HANDLER_DEFAULT);
        this.defaultReentrancy = value instanceof Boolean ? (Boolean)value : Boolean.parseBoolean((String)value);
        this.processWorkStageProperties(properties);
    }

    protected void processWorkStageProperties(Map<String, Object> config) {
        for (Map.Entry<String, Object> entry : config.entrySet()) {
            if (!entry.getKey().startsWith(CFG_KEY_STAGE_PREFIX)) continue;
            Object o = entry.getValue();
            String[] topics = o instanceof String[] ? (String[])o : (o instanceof String ? new String[]{(String)o} : new String[]{});
            String stageName = entry.getKey().substring(CFG_KEY_STAGE_PREFIX.length());
            this.topicCache.setStageTopics(stageName, topics);
        }
    }

    BundleContext getBundleContext() {
        return this.bundleContext;
    }

    ComponentContext getComponentContext() {
        return this.componentContext;
    }

    boolean getDefaultReentrancy() {
        return this.defaultReentrancy;
    }

    @Reference(cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC)
    protected synchronized void setLogService(LogService logService) {
        this.logService = logService;
    }

    protected synchronized void unsetLogService(LogService logService) {
        if (logService == this.logService) {
            this.logService = null;
        }
    }

    synchronized void log(ServiceReference serviceReference, int level, String message, Throwable exception) {
        if (this.logService != null) {
            this.logService.log(serviceReference, level, message, exception);
        }
    }

    protected synchronized ExecutorService getExecutorService(String stageName) {
        if (this.executorServiceFactory != null) {
            return this.executorServiceFactory.getExecutorService(stageName);
        }
        return null;
    }

    @Reference
    protected synchronized void setExecutorServiceFactory(ExecutorServiceFactory executorServiceFactory) {
        this.executorServiceFactory = executorServiceFactory;
    }

    protected synchronized void unsetExecutorServiceFactory(ExecutorServiceFactory executorServiceFactory) {
        if (this.executorServiceFactory == executorServiceFactory) {
            this.executorServiceFactory = null;
        }
    }

    Future<?> queueWorkRequest(Runnable runnable, ExecutorService executor) {
        Future<?> future = null;
        if (skipSchedule) {
            runnable.run();
        } else {
            future = executor.submit(runnable);
        }
        return future;
    }
}

