/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.event.internal.adapter;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.osgi.framework.AllServiceListener;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceReference;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventAdmin;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public final class ServiceEventAdapter
implements AllServiceListener {
    private static final String SERVICE_EVENT_TOPIC_PREFIX = "org/osgi/framework/ServiceEvent/";
    private final EventAdmin eventAdmin;
    static final long serialVersionUID = 408387796793790680L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public ServiceEventAdapter(EventAdmin eventAdmin) {
        this.eventAdmin = eventAdmin;
    }

    public void serviceChanged(ServiceEvent serviceEvent) {
        String topic = this.getTopic(serviceEvent);
        if (topic == null) {
            return;
        }
        HashMap<String, Object> eventProperties = new HashMap<String, Object>();
        eventProperties.put("event", serviceEvent);
        ServiceReference serviceReference = serviceEvent.getServiceReference();
        if (serviceReference != null) {
            String[] objectClass;
            eventProperties.put("service", serviceReference);
            Long serviceId = (Long)serviceReference.getProperty("service.id");
            eventProperties.put("service.id", serviceId);
            List<String> servicePersistentId = serviceReference.getProperty("service.pid");
            if (servicePersistentId != null) {
                if (servicePersistentId instanceof String[]) {
                    servicePersistentId = Arrays.asList((String[])servicePersistentId);
                }
                eventProperties.put("service.pid", servicePersistentId);
            }
            if ((objectClass = (String[])serviceReference.getProperty("objectClass")) != null) {
                eventProperties.put("service.objectClass", objectClass);
            }
        }
        Event event = new Event(topic, eventProperties);
        this.eventAdmin.postEvent(event);
    }

    private String getTopic(ServiceEvent serviceEvent) {
        StringBuilder topic = new StringBuilder(SERVICE_EVENT_TOPIC_PREFIX);
        switch (serviceEvent.getType()) {
            case 1: {
                topic.append("REGISTERED");
                break;
            }
            case 2: {
                topic.append("MODIFIED");
                break;
            }
            case 4: {
                topic.append("UNREGISTERING");
                break;
            }
            default: {
                return null;
            }
        }
        return topic.toString();
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(ServiceEventAdapter.class);
    }
}

