/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.kernel.feature.internal.cmdline;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.kernel.boot.cmdline.Arguments;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class ArgumentsImpl
implements Arguments {
    private final String _command;
    private final Map<String, String> _options = new HashMap<String, String>();
    private final List<String> _args = new ArrayList<String>();
    static final long serialVersionUID = 6376857460651367578L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public ArgumentsImpl(String[] args) {
        if (args.length > 0) {
            this._command = args[0];
            for (int i = 1; i < args.length; ++i) {
                String arg = args[i];
                if (arg.startsWith("--")) {
                    String key;
                    int index = arg.indexOf(61);
                    String value = "";
                    if (index != -1) {
                        key = arg.substring(2, index);
                        value = arg.substring(index + 1);
                    } else {
                        key = arg.substring(2);
                    }
                    this._options.put(key.toLowerCase(Locale.ENGLISH), value);
                    continue;
                }
                this._args.add(args[i]);
            }
        } else {
            this._command = null;
        }
    }

    public String getOption(String name) {
        return this._options.get(name);
    }

    public List<String> findInvalidOptions(List<String> expectedOptions) {
        ArrayList<String> processedEO = new ArrayList<String>();
        for (String op : expectedOptions) {
            if (!op.startsWith("--")) continue;
            processedEO.add(op.substring(2).toLowerCase(Locale.ENGLISH));
        }
        ArrayList<String> arguments = new ArrayList<String>(this._options.keySet());
        arguments.removeAll(processedEO);
        return arguments;
    }

    public List<String> getPositionalArguments() {
        return this._args;
    }

    public String getAction() {
        return this._command;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(ArgumentsImpl.class);
    }
}

