/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.kernel.feature.internal.generator;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.kernel.boot.cmdline.Utils;
import com.ibm.ws.kernel.feature.internal.cmdline.FeatureToolException;
import com.ibm.ws.kernel.feature.internal.cmdline.NLS;
import com.ibm.ws.kernel.feature.internal.cmdline.ReturnCode;
import com.ibm.ws.kernel.feature.internal.generator.KernelFeatureListDefinition;
import com.ibm.ws.kernel.feature.internal.subsystem.SubsystemFeatureDefinitionImpl;
import com.ibm.ws.kernel.feature.provisioning.ProvisioningFeatureDefinition;
import com.ibm.ws.kernel.provisioning.BundleRepositoryRegistry;
import com.ibm.ws.kernel.provisioning.ContentBasedLocalBundleRepository;
import com.ibm.ws.kernel.provisioning.ProductExtension;
import com.ibm.ws.kernel.provisioning.ProductExtensionInfo;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.kernel.service.location.WsLocationAdmin;
import com.ibm.wsspi.kernel.service.utils.PathUtils;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class ManifestFileProcessor {
    protected static final String FEATURE_DIR = "lib/features";
    protected static final String PLATFORM_DIR = "lib/platform";
    protected static final String ASSET_DIR = "lib/assets";
    protected static final String USER_FEATURE_DIR = "extension/lib/features";
    protected HashMap<String, ProductExtensionInfo> productExtNameInfoMap;
    public static final String MF_EXTENSION = ".mf";
    public static final String CORE_PRODUCT_NAME = "core";
    public static final String USR_PRODUCT_EXT_NAME = "usr";
    private static FileFilter MFFilter;
    static final long serialVersionUID = -2232757077919722193L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public Map<String, ProvisioningFeatureDefinition> getFeatureDefinitions(String productName) {
        if (productName.equals(CORE_PRODUCT_NAME)) {
            return this.getCoreProductFeatureDefinitions();
        }
        if (productName.equals(USR_PRODUCT_EXT_NAME)) {
            return this.getUsrProductFeatureDefinitions();
        }
        return this.getProductExtFeatureDefinitions(productName);
    }

    /*
     * WARNING - void declaration
     */
    public Map<String, ProvisioningFeatureDefinition> getCoreFeatureDefinitionsExceptPlatform() {
        TreeMap<String, ProvisioningFeatureDefinition> features = new TreeMap<String, ProvisioningFeatureDefinition>();
        File featureDir = this.getCoreFeatureDir();
        if (!featureDir.isDirectory() && !featureDir.mkdir()) {
            throw new FeatureToolException("Unable to find or create feature directory: " + featureDir, MessageFormat.format(NLS.messages.getString("tool.feature.dir.not.found"), featureDir), null, ReturnCode.MISSING_CONTENT);
        }
        File[] manifestFiles = featureDir.listFiles(MFFilter);
        if (manifestFiles != null) {
            for (File file : manifestFiles) {
                try {
                    SubsystemFeatureDefinitionImpl fd = new SubsystemFeatureDefinitionImpl("", file);
                    if (!fd.isSupportedFeatureVersion()) continue;
                    features.put(fd.getSymbolicName(), fd);
                }
                catch (IOException fd) {
                    void e;
                    FFDCFilter.processException((Throwable)fd, (String)"com.ibm.ws.kernel.feature.internal.generator.ManifestFileProcessor", (String)"110", (Object)this, (Object[])new Object[0]);
                    throw new FeatureToolException("Unable to read core feature manifest: " + file, (String)null, (Throwable)e, ReturnCode.BAD_FEATURE_DEFINITION);
                }
            }
        }
        return features;
    }

    /*
     * WARNING - void declaration
     */
    public Map<String, ProvisioningFeatureDefinition> getInstallFeatureDefinitions() {
        TreeMap<String, ProvisioningFeatureDefinition> features = new TreeMap<String, ProvisioningFeatureDefinition>();
        File assetDir = this.getCoreAssetDir();
        if (!assetDir.exists()) {
            return features;
        }
        if (!assetDir.isDirectory()) {
            throw new FeatureToolException("Unable to find or create asset directory: " + assetDir, MessageFormat.format(NLS.messages.getString("tool.feature.dir.not.found"), assetDir), null, ReturnCode.MISSING_CONTENT);
        }
        File[] manifestFiles = assetDir.listFiles(MFFilter);
        if (manifestFiles != null) {
            for (File file : manifestFiles) {
                try {
                    SubsystemFeatureDefinitionImpl fd = new SubsystemFeatureDefinitionImpl("", file);
                    if (!fd.isSupportedFeatureVersion()) continue;
                    features.put(fd.getSymbolicName(), fd);
                }
                catch (IOException fd) {
                    void e;
                    FFDCFilter.processException((Throwable)fd, (String)"com.ibm.ws.kernel.feature.internal.generator.ManifestFileProcessor", (String)"148", (Object)this, (Object[])new Object[0]);
                    throw new FeatureToolException("Unable to read install feature manifest: " + file, (String)null, (Throwable)e, ReturnCode.BAD_FEATURE_DEFINITION);
                }
            }
        }
        return features;
    }

    public Map<String, ProvisioningFeatureDefinition> getFeatureDefinitions() {
        TreeMap<String, ProvisioningFeatureDefinition> featureDefs = new TreeMap<String, ProvisioningFeatureDefinition>();
        featureDefs.putAll(this.getCoreProductFeatureDefinitions());
        Map<String, ProvisioningFeatureDefinition> userFeatureDefs = this.getUsrProductFeatureDefinitions();
        if (userFeatureDefs != null && !userFeatureDefs.isEmpty()) {
            featureDefs.putAll(userFeatureDefs);
        }
        this.readProductExtFeatureLocations();
        if (!this.productExtNameInfoMap.isEmpty()) {
            for (String productExtName : BundleRepositoryRegistry.keys()) {
                Map<String, ProvisioningFeatureDefinition> prodExtFeatureDefs;
                if (productExtName.isEmpty() || USR_PRODUCT_EXT_NAME.equals(productExtName) || (prodExtFeatureDefs = this.getProductExtFeatureDefinitions(productExtName)) == null || prodExtFeatureDefs.isEmpty()) continue;
                featureDefs.putAll(prodExtFeatureDefs);
            }
        }
        return featureDefs;
    }

    public Map<String, Map<String, ProvisioningFeatureDefinition>> getFeatureDefinitionsByProduct() {
        TreeMap<String, Map<String, ProvisioningFeatureDefinition>> prodFeatureMap = new TreeMap<String, Map<String, ProvisioningFeatureDefinition>>();
        prodFeatureMap.put(CORE_PRODUCT_NAME, this.getCoreProductFeatureDefinitions());
        Map<String, ProvisioningFeatureDefinition> userFeatureDefs = this.getUsrProductFeatureDefinitions();
        if (userFeatureDefs != null && !userFeatureDefs.isEmpty()) {
            prodFeatureMap.put(USR_PRODUCT_EXT_NAME, userFeatureDefs);
        }
        this.readProductExtFeatureLocations();
        if (!BundleRepositoryRegistry.isEmpty()) {
            for (String productExtName : BundleRepositoryRegistry.keys()) {
                Map<String, ProvisioningFeatureDefinition> prodExtFeatureDefs;
                if (productExtName.isEmpty() || USR_PRODUCT_EXT_NAME.equals(productExtName) || (prodExtFeatureDefs = this.getProductExtFeatureDefinitions(productExtName)) == null || prodExtFeatureDefs.isEmpty()) continue;
                prodFeatureMap.put(productExtName, prodExtFeatureDefs);
            }
        }
        return prodFeatureMap;
    }

    /*
     * WARNING - void declaration
     */
    private Map<String, ProvisioningFeatureDefinition> getCoreProductFeatureDefinitions() {
        SubsystemFeatureDefinitionImpl fd2;
        TreeMap<String, ProvisioningFeatureDefinition> features = new TreeMap<String, ProvisioningFeatureDefinition>();
        File featureDir = this.getCoreFeatureDir();
        if (!featureDir.isDirectory() && !featureDir.mkdir()) {
            throw new FeatureToolException("Unable to find or create feature directory: " + featureDir, MessageFormat.format(NLS.messages.getString("tool.feature.dir.not.found"), featureDir), null, ReturnCode.MISSING_CONTENT);
        }
        File platformDir = this.getCorePlatformDir();
        File[] manifestFiles = featureDir.listFiles(MFFilter);
        if (manifestFiles != null) {
            for (File file : manifestFiles) {
                try {
                    fd2 = new SubsystemFeatureDefinitionImpl("", file);
                    if (!fd2.isSupportedFeatureVersion()) continue;
                    features.put(fd2.getSymbolicName(), fd2);
                }
                catch (IOException fd2) {
                    void e;
                    FFDCFilter.processException((Throwable)fd2, (String)"com.ibm.ws.kernel.feature.internal.generator.ManifestFileProcessor", (String)"252", (Object)this, (Object[])new Object[0]);
                    throw new FeatureToolException("Unable to read core feature manifest: " + file, (String)null, (Throwable)e, ReturnCode.BAD_FEATURE_DEFINITION);
                }
            }
        }
        if ((manifestFiles = platformDir.listFiles(MFFilter)) != null) {
            for (File file : manifestFiles) {
                try {
                    fd2 = new KernelFeatureListDefinition(file);
                    features.put(fd2.getSymbolicName(), fd2);
                }
                catch (IOException fd3) {
                    void e;
                    FFDCFilter.processException((Throwable)fd3, (String)"com.ibm.ws.kernel.feature.internal.generator.ManifestFileProcessor", (String)"269", (Object)this, (Object[])new Object[0]);
                    throw new FeatureToolException("Unable to read core manifest: " + file, (String)null, (Throwable)e, ReturnCode.BAD_FEATURE_DEFINITION);
                }
            }
        }
        return features;
    }

    /*
     * WARNING - void declaration
     */
    private Map<String, ProvisioningFeatureDefinition> getUsrProductFeatureDefinitions() {
        File userFeatureDir;
        TreeMap<String, SubsystemFeatureDefinitionImpl> features = null;
        File userDir = Utils.getUserDir();
        if (userDir != null && userDir.exists() && (userFeatureDir = new File(userDir, USER_FEATURE_DIR)).exists()) {
            features = new TreeMap<String, SubsystemFeatureDefinitionImpl>();
            File[] userManifestFiles = userFeatureDir.listFiles(MFFilter);
            if (userManifestFiles != null) {
                for (File file : userManifestFiles) {
                    try {
                        SubsystemFeatureDefinitionImpl fd = new SubsystemFeatureDefinitionImpl(USR_PRODUCT_EXT_NAME, file);
                        features.put(fd.getSymbolicName(), fd);
                    }
                    catch (IOException fd) {
                        void e;
                        FFDCFilter.processException((Throwable)fd, (String)"com.ibm.ws.kernel.feature.internal.generator.ManifestFileProcessor", (String)"300", (Object)this, (Object[])new Object[0]);
                        throw new FeatureToolException("Unable to read feature manifest from user extension: " + file, (String)null, (Throwable)e, ReturnCode.BAD_FEATURE_DEFINITION);
                    }
                }
            }
        }
        return features;
    }

    /*
     * WARNING - void declaration
     */
    private Map<String, ProvisioningFeatureDefinition> getProductExtFeatureDefinitions(String productName) {
        File featuresDir;
        File productInstallDir;
        this.readProductExtFeatureLocations();
        TreeMap<String, SubsystemFeatureDefinitionImpl> features = null;
        BundleRepositoryRegistry.BundleRepositoryHolder featureData = BundleRepositoryRegistry.getRepositoryHolder((String)productName);
        if (featureData != null && (productInstallDir = new File(featureData.getInstallDir())).exists() && (featuresDir = new File(productInstallDir, FEATURE_DIR)).exists()) {
            features = new TreeMap<String, SubsystemFeatureDefinitionImpl>();
            File[] productManifestFiles = featuresDir.listFiles(MFFilter);
            if (productManifestFiles != null) {
                for (File productManifestFile : productManifestFiles) {
                    try {
                        SubsystemFeatureDefinitionImpl fd = new SubsystemFeatureDefinitionImpl(productName, productManifestFile);
                        features.put(fd.getSymbolicName(), fd);
                    }
                    catch (IOException fd) {
                        void e;
                        FFDCFilter.processException((Throwable)fd, (String)"com.ibm.ws.kernel.feature.internal.generator.ManifestFileProcessor", (String)"339", (Object)this, (Object[])new Object[]{productName});
                        throw new FeatureToolException("Unable to read feature manifest from product extension: " + productManifestFile, (String)null, (Throwable)e, ReturnCode.BAD_FEATURE_DEFINITION);
                    }
                }
            }
        }
        return features;
    }

    private void readProductExtFeatureLocations() {
        if (this.productExtNameInfoMap != null) {
            return;
        }
        this.productExtNameInfoMap = new HashMap();
        File installDir = Utils.getInstallDir();
        for (ProductExtensionInfo prodExt : ProductExtension.getProductExtensions((File)installDir)) {
            File productInstallDir;
            String prodName = prodExt.getName();
            String prodLocation = prodExt.getLocation();
            this.productExtNameInfoMap.put(prodName, prodExt);
            if (prodLocation == null || prodLocation.isEmpty()) continue;
            String normalizedPath = PathUtils.normalize((String)prodLocation);
            if (!PathUtils.pathIsAbsolute((String)normalizedPath)) {
                File parentfile = installDir.getParentFile();
                String parentPath = parentfile.getAbsolutePath();
                normalizedPath = parentPath + "/" + prodLocation + "/";
                normalizedPath = PathUtils.normalize((String)normalizedPath);
            }
            if (normalizedPath == null || !(productInstallDir = new File(normalizedPath)).exists()) continue;
            BundleRepositoryRegistry.addBundleRepository((String)normalizedPath, (String)prodName);
        }
    }

    public String getProdFeatureLocation(String productName) {
        String location = null;
        if (productName.equals(CORE_PRODUCT_NAME)) {
            location = Utils.getInstallDir().getAbsolutePath();
        } else if (productName.equals(USR_PRODUCT_EXT_NAME)) {
            location = Utils.getUserDir().getAbsolutePath();
        } else {
            this.readProductExtFeatureLocations();
            if (this.productExtNameInfoMap.containsKey(productName)) {
                location = this.productExtNameInfoMap.get(productName).getLocation();
            }
        }
        return location;
    }

    public String getProdFeatureId(String productName) {
        String productId = null;
        if (!productName.equals(CORE_PRODUCT_NAME) && !productName.equals(USR_PRODUCT_EXT_NAME)) {
            this.readProductExtFeatureLocations();
            if (this.productExtNameInfoMap.containsKey(productName)) {
                productId = this.productExtNameInfoMap.get(productName).getProductID();
            }
        }
        return productId;
    }

    public File getCoreFeatureDir() {
        File featureDir = null;
        File installDir = Utils.getInstallDir();
        if (installDir != null) {
            featureDir = new File(installDir, FEATURE_DIR);
        }
        if (featureDir == null) {
            throw new RuntimeException("Feature Directory not found");
        }
        return featureDir;
    }

    public File getCorePlatformDir() {
        File platformDir = null;
        File installDir = Utils.getInstallDir();
        if (installDir != null) {
            platformDir = new File(installDir, PLATFORM_DIR);
        }
        if (platformDir == null) {
            throw new RuntimeException("Platform Directory not found");
        }
        return platformDir;
    }

    public File getCoreAssetDir() {
        File assetDir = null;
        File installDir = Utils.getInstallDir();
        if (installDir != null) {
            assetDir = new File(installDir, ASSET_DIR);
        }
        if (assetDir == null) {
            throw new RuntimeException("Asset Directory not found");
        }
        return assetDir;
    }

    public ContentBasedLocalBundleRepository getBundleRepository(String featureName, WsLocationAdmin locService) {
        return BundleRepositoryRegistry.getRepositoryHolder((String)featureName).getBundleRepository();
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(ManifestFileProcessor.class);
        MFFilter = new FileFilter(){
            static final long serialVersionUID = 6807056401199893175L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public boolean accept(File file) {
                if (file != null && file.isFile()) {
                    String name = file.getName();
                    int pos = name.lastIndexOf(46);
                    if (pos < 0) {
                        return false;
                    }
                    if (name.regionMatches(true, pos, ManifestFileProcessor.MF_EXTENSION, 0, 3)) {
                        return true;
                    }
                }
                return false;
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register(1.class);
            }
        };
    }
}

