/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jaxrs20.server;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.ws.rs.BeanParam;
import javax.ws.rs.CookieParam;
import javax.ws.rs.Encoded;
import javax.ws.rs.FormParam;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.MatrixParam;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Provider;
import javax.xml.bind.JAXBElement;
import javax.xml.namespace.QName;
import org.apache.cxf.Bus;
import org.apache.cxf.BusFactory;
import org.apache.cxf.common.classloader.ClassLoaderUtils;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.helpers.DOMUtils;
import org.apache.cxf.jaxrs.ext.xml.ElementClass;
import org.apache.cxf.jaxrs.ext.xml.XMLName;
import org.apache.cxf.jaxrs.model.ClassResourceInfo;
import org.apache.cxf.jaxrs.model.MethodDispatcher;
import org.apache.cxf.jaxrs.model.OperationResourceInfo;
import org.apache.cxf.jaxrs.model.Parameter;
import org.apache.cxf.jaxrs.model.ParameterType;
import org.apache.cxf.jaxrs.model.ResourceTypes;
import org.apache.cxf.jaxrs.model.URITemplate;
import org.apache.cxf.jaxrs.model.UserOperation;
import org.apache.cxf.jaxrs.model.UserResource;
import org.apache.cxf.jaxrs.provider.JAXBElementProvider;
import org.apache.cxf.jaxrs.utils.AnnotationUtils;
import org.apache.cxf.jaxrs.utils.InjectionUtils;
import org.apache.cxf.jaxrs.utils.JAXRSUtils;
import org.apache.cxf.message.Message;
import org.apache.cxf.resource.ResourceManager;
import org.apache.cxf.staxutils.StaxUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public final class ResourceUtils {
    private static final TraceComponent tc = Tr.register(ResourceUtils.class);
    private static final String CLASSPATH_PREFIX = "classpath:";
    private static final Set<String> SERVER_PROVIDER_CLASS_NAMES = new HashSet<String>();
    static final long serialVersionUID = -2312808767265621519L;

    private ResourceUtils() {
    }

    public static Method findPostConstructMethod(Class<?> c) {
        return ResourceUtils.findPostConstructMethod(c, null);
    }

    public static Method findPostConstructMethod(Class<?> c, String name) {
        if (Object.class == c || null == c) {
            return null;
        }
        for (Method m : c.getDeclaredMethods()) {
            if (!(name != null ? m.getName().equals(name) : m.getAnnotation(PostConstruct.class) != null)) continue;
            return m;
        }
        Method m = ResourceUtils.findPostConstructMethod(c.getSuperclass(), name);
        if (m != null) {
            return m;
        }
        for (Class<?> i : c.getInterfaces()) {
            m = ResourceUtils.findPostConstructMethod(i, name);
            if (m == null) continue;
            return m;
        }
        return null;
    }

    public static Method findPreDestroyMethod(Class<?> c) {
        return ResourceUtils.findPreDestroyMethod(c, null);
    }

    public static Method findPreDestroyMethod(Class<?> c, String name) {
        if (Object.class == c || null == c) {
            return null;
        }
        for (Method m : c.getDeclaredMethods()) {
            if (!(name != null ? m.getName().equals(name) : m.getAnnotation(PreDestroy.class) != null)) continue;
            return m;
        }
        Method m = ResourceUtils.findPreDestroyMethod(c.getSuperclass(), name);
        if (m != null) {
            return m;
        }
        for (Class<?> i : c.getInterfaces()) {
            m = ResourceUtils.findPreDestroyMethod(i, name);
            if (m == null) continue;
            return m;
        }
        return null;
    }

    public static ClassResourceInfo createClassResourceInfo(Map<String, UserResource> resources, UserResource model, boolean isRoot, boolean enableStatic) {
        return ResourceUtils.createClassResourceInfo(resources, model, isRoot, enableStatic, BusFactory.getThreadDefaultBus());
    }

    public static ClassResourceInfo createClassResourceInfo(Map<String, UserResource> resources, UserResource model, boolean isRoot, boolean enableStatic, Bus bus) {
        Class<?> sClass = ResourceUtils.loadClass(model.getName());
        return ResourceUtils.createServiceClassResourceInfo(resources, model, sClass, isRoot, enableStatic, bus);
    }

    public static ClassResourceInfo createServiceClassResourceInfo(Map<String, UserResource> resources, UserResource model, Class<?> sClass, boolean isRoot, boolean enableStatic, Bus bus) {
        if (model == null) {
            throw new RuntimeException("Resource class " + sClass.getName() + " has no model info");
        }
        ClassResourceInfo cri = new ClassResourceInfo(sClass, sClass, isRoot, enableStatic, true, model.getConsumes(), model.getProduces(), bus);
        URITemplate t = URITemplate.createTemplate((String)model.getPath());
        cri.setURITemplate(t);
        MethodDispatcher md = new MethodDispatcher();
        Map ops = model.getOperationsAsMap();
        for (Method m : cri.getServiceClass().getMethods()) {
            UserOperation op = (UserOperation)ops.get(m.getName());
            if (op == null || op.getName() == null) continue;
            OperationResourceInfo ori = new OperationResourceInfo(m, cri, URITemplate.createTemplate((String)op.getPath()), op.getVerb(), op.getConsumes(), op.getProduces(), op.getParameters(), op.isOneway());
            String rClassName = m.getReturnType().getName();
            if (op.getVerb() == null) {
                ClassResourceInfo subCri;
                if (!resources.containsKey(rClassName)) continue;
                ClassResourceInfo classResourceInfo = subCri = rClassName.equals(model.getName()) ? cri : ResourceUtils.createServiceClassResourceInfo(resources, resources.get(rClassName), m.getReturnType(), false, enableStatic, bus);
                if (subCri == null) continue;
                cri.addSubClassResourceInfo(subCri);
                md.bind(ori, new Method[]{m});
                continue;
            }
            md.bind(ori, new Method[]{m});
        }
        cri.setMethodDispatcher(md);
        return ResourceUtils.checkMethodDispatcher(cri) ? cri : null;
    }

    public static ClassResourceInfo createClassResourceInfo(Class<?> rClass, Class<?> sClass, boolean root, boolean enableStatic) {
        return ResourceUtils.createClassResourceInfo(rClass, sClass, root, enableStatic, BusFactory.getThreadDefaultBus());
    }

    public static ClassResourceInfo createClassResourceInfo(Class<?> rClass, Class<?> sClass, boolean root, boolean enableStatic, Bus bus) {
        return ResourceUtils.createClassResourceInfo(rClass, sClass, null, root, enableStatic, bus);
    }

    public static ClassResourceInfo createClassResourceInfo(Class<?> rClass, Class<?> sClass, ClassResourceInfo parent, boolean root, boolean enableStatic, Bus bus) {
        ClassResourceInfo cri = new ClassResourceInfo(rClass, sClass, root, enableStatic, bus);
        cri.setParent(parent);
        if (root) {
            URITemplate t = URITemplate.createTemplate((Path)cri.getPath());
            cri.setURITemplate(t);
        }
        ResourceUtils.evaluateResourceClass(cri, enableStatic);
        return ResourceUtils.checkMethodDispatcher(cri) ? cri : null;
    }

    private static void evaluateResourceClass(ClassResourceInfo cri, boolean enableStatic) {
        MethodDispatcher md = new MethodDispatcher();
        for (Method m : cri.getServiceClass().getMethods()) {
            Method annotatedMethod = AnnotationUtils.getAnnotatedMethod((Class)cri.getServiceClass(), (Method)m);
            String httpMethod = AnnotationUtils.getHttpMethodValue((Method)annotatedMethod);
            Path path = (Path)AnnotationUtils.getMethodAnnotation((Method)annotatedMethod, Path.class);
            if (httpMethod == null && path == null) continue;
            md.bind(ResourceUtils.createOperationInfo(m, annotatedMethod, cri, path, httpMethod), new Method[]{m});
            if (httpMethod != null) continue;
            Class<?> subClass = m.getReturnType();
            if (!enableStatic) continue;
            ClassResourceInfo subCri = cri.findResource(subClass, subClass);
            if (subCri == null) {
                ClassResourceInfo ancestor = ResourceUtils.getAncestorWithSameServiceClass(cri, subClass);
                ClassResourceInfo classResourceInfo = subCri = ancestor != null ? ancestor : ResourceUtils.createClassResourceInfo(subClass, subClass, cri, false, enableStatic, cri.getBus());
            }
            if (subCri == null) continue;
            cri.addSubClassResourceInfo(subCri);
        }
        cri.setMethodDispatcher(md);
    }

    private static ClassResourceInfo getAncestorWithSameServiceClass(ClassResourceInfo parent, Class<?> subClass) {
        if (parent == null) {
            return null;
        }
        if (parent.getServiceClass() == subClass) {
            return parent;
        }
        return ResourceUtils.getAncestorWithSameServiceClass(parent.getParent(), subClass);
    }

    public static Constructor<?> findResourceConstructor(Class<?> resourceClass, boolean perRequest) {
        LinkedList cs = new LinkedList();
        for (Constructor<?> c : resourceClass.getConstructors()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("findResourceConstructor - checking ctor: " + c), (Object[])new Object[0]);
            }
            Class<?>[] params = c.getParameterTypes();
            Annotation[][] anns = c.getParameterAnnotations();
            boolean match = true;
            for (int i = 0; i < params.length; ++i) {
                if (!perRequest) {
                    if (AnnotationUtils.getAnnotation((Annotation[])anns[i], Context.class) != null) continue;
                    match = false;
                    break;
                }
                if (AnnotationUtils.isValidParamAnnotations((Annotation[])anns[i])) continue;
                match = false;
                break;
            }
            if (!match) continue;
            cs.add(c);
        }
        Collections.sort(cs, new Comparator<Constructor<?>>(){
            static final long serialVersionUID = -61101580751969378L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public int compare(Constructor<?> c1, Constructor<?> c2) {
                int p2;
                int p1 = c1.getParameterTypes().length;
                return p1 > (p2 = c2.getParameterTypes().length) ? -1 : (p1 < p2 ? 1 : 0);
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register(1.class);
            }
        });
        return cs.size() == 0 ? null : (Constructor)cs.get(0);
    }

    public static List<Parameter> getParameters(Method resourceMethod) {
        Annotation[][] paramAnns = resourceMethod.getParameterAnnotations();
        if (paramAnns.length == 0) {
            return CastUtils.cast(Collections.emptyList(), Parameter.class);
        }
        Class<?>[] types = resourceMethod.getParameterTypes();
        ArrayList<Parameter> params = new ArrayList<Parameter>(paramAnns.length);
        for (int i = 0; i < paramAnns.length; ++i) {
            Parameter p = ResourceUtils.getParameter(i, paramAnns[i], types[i]);
            params.add(p);
        }
        return params;
    }

    public static Parameter getParameter(int index, Annotation[] anns, Class<?> type) {
        Context ctx = (Context)AnnotationUtils.getAnnotation((Annotation[])anns, Context.class);
        if (ctx != null) {
            return new Parameter(ParameterType.CONTEXT, index, null);
        }
        boolean isEncoded = AnnotationUtils.getAnnotation((Annotation[])anns, Encoded.class) != null;
        BeanParam bp = (BeanParam)AnnotationUtils.getAnnotation((Annotation[])anns, BeanParam.class);
        if (bp != null) {
            return new Parameter(ParameterType.BEAN, index, null, isEncoded, null);
        }
        String dValue = AnnotationUtils.getDefaultParameterValue((Annotation[])anns);
        PathParam a = (PathParam)AnnotationUtils.getAnnotation((Annotation[])anns, PathParam.class);
        if (a != null) {
            return new Parameter(ParameterType.PATH, index, a.value(), isEncoded, dValue);
        }
        QueryParam q = (QueryParam)AnnotationUtils.getAnnotation((Annotation[])anns, QueryParam.class);
        if (q != null) {
            return new Parameter(ParameterType.QUERY, index, q.value(), isEncoded, dValue);
        }
        MatrixParam m = (MatrixParam)AnnotationUtils.getAnnotation((Annotation[])anns, MatrixParam.class);
        if (m != null) {
            return new Parameter(ParameterType.MATRIX, index, m.value(), isEncoded, dValue);
        }
        FormParam f = (FormParam)AnnotationUtils.getAnnotation((Annotation[])anns, FormParam.class);
        if (f != null) {
            return new Parameter(ParameterType.FORM, index, f.value(), isEncoded, dValue);
        }
        HeaderParam h = (HeaderParam)AnnotationUtils.getAnnotation((Annotation[])anns, HeaderParam.class);
        if (h != null) {
            return new Parameter(ParameterType.HEADER, index, h.value(), isEncoded, dValue);
        }
        CookieParam c = (CookieParam)AnnotationUtils.getAnnotation((Annotation[])anns, CookieParam.class);
        if (c != null) {
            return new Parameter(ParameterType.COOKIE, index, c.value(), isEncoded, dValue);
        }
        return new Parameter(ParameterType.REQUEST_BODY, index, null);
    }

    private static OperationResourceInfo createOperationInfo(Method m, Method annotatedMethod, ClassResourceInfo cri, Path path, String httpMethod) {
        OperationResourceInfo ori = new OperationResourceInfo(m, annotatedMethod, cri);
        URITemplate t = URITemplate.createTemplate((Path)path);
        ori.setURITemplate(t);
        ori.setHttpMethod(httpMethod);
        return ori;
    }

    private static boolean checkMethodDispatcher(ClassResourceInfo cr) {
        return !cr.getMethodDispatcher().getOperationResourceInfos().isEmpty();
    }

    /*
     * WARNING - void declaration
     */
    private static Class<?> loadClass(String cName) {
        try {
            return ClassLoaderUtils.loadClass((String)cName.trim(), ResourceUtils.class);
        }
        catch (ClassNotFoundException classNotFoundException) {
            void ex;
            FFDCFilter.processException((Throwable)classNotFoundException, (String)"com.ibm.ws.jaxrs20.server.ResourceUtils", (String)"421", null, (Object[])new Object[]{cName});
            throw new RuntimeException("No class " + cName.trim() + " can be found", (Throwable)ex);
        }
    }

    public static List<UserResource> getUserResources(String loc, Bus bus) {
        try {
            InputStream is = ResourceUtils.getResourceStream(loc, bus);
            if (is == null) {
                return null;
            }
            return ResourceUtils.getUserResources(is);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.jaxrs20.server.ResourceUtils", (String)"433", null, (Object[])new Object[]{loc, bus});
            return null;
        }
    }

    public static InputStream getResourceStream(String loc, Bus bus) throws Exception {
        URL url = ResourceUtils.getResourceURL(loc, bus);
        return url == null ? null : url.openStream();
    }

    public static URL getResourceURL(String loc, Bus bus) throws Exception {
        URL url;
        block4: {
            url = null;
            if (loc.startsWith(CLASSPATH_PREFIX)) {
                String path = loc.substring(CLASSPATH_PREFIX.length());
                url = ResourceUtils.getClasspathResourceURL(path, ResourceUtils.class, bus);
            } else {
                try {
                    url = new URL(loc);
                }
                catch (Exception path) {
                    File file;
                    FFDCFilter.processException((Throwable)path, (String)"com.ibm.ws.jaxrs20.server.ResourceUtils", (String)"452", null, (Object[])new Object[]{loc, bus});
                    url = ResourceUtils.getClasspathResourceURL(loc, ResourceUtils.class, bus);
                    if (url != null || !(file = new File(loc)).exists()) break block4;
                    url = file.toURI().toURL();
                }
            }
        }
        return url;
    }

    public static InputStream getClasspathResourceStream(String path, Class<?> callingClass, Bus bus) {
        InputStream is = ClassLoaderUtils.getResourceAsStream((String)path, callingClass);
        return is == null ? ResourceUtils.getResource(path, InputStream.class, bus) : is;
    }

    public static URL getClasspathResourceURL(String path, Class<?> callingClass, Bus bus) {
        URL url = ClassLoaderUtils.getResource((String)path, callingClass);
        return url == null ? ResourceUtils.getResource(path, URL.class, bus) : url;
    }

    public static <T> T getResource(String path, Class<T> resourceClass, Bus bus) {
        ResourceManager rm;
        if (bus != null && (rm = (ResourceManager)bus.getExtension(ResourceManager.class)) != null) {
            return (T)rm.resolveResource(path, resourceClass);
        }
        return null;
    }

    public static List<UserResource> getUserResources(String loc) {
        return ResourceUtils.getUserResources(loc, BusFactory.getThreadDefaultBus());
    }

    public static List<UserResource> getUserResources(InputStream is) throws Exception {
        Document doc = StaxUtils.read((Reader)new InputStreamReader(is, "UTF-8"));
        return ResourceUtils.getResourcesFromElement(doc.getDocumentElement());
    }

    public static List<UserResource> getResourcesFromElement(Element modelEl) {
        ArrayList<UserResource> resources = new ArrayList<UserResource>();
        List resourceEls = DOMUtils.findAllElementsByTagNameNS((Element)modelEl, (String)"http://cxf.apache.org/jaxrs", (String)"resource");
        for (Element e : resourceEls) {
            resources.add(ResourceUtils.getResourceFromElement(e));
        }
        return resources;
    }

    public static ResourceTypes getAllRequestResponseTypes(List<ClassResourceInfo> cris, boolean jaxbOnly) {
        return ResourceUtils.getAllRequestResponseTypes(cris, jaxbOnly, null);
    }

    public static ResourceTypes getAllRequestResponseTypes(List<ClassResourceInfo> cris, boolean jaxbOnly, MessageBodyWriter<?> jaxbWriter) {
        ResourceTypes types = new ResourceTypes();
        for (ClassResourceInfo resource : cris) {
            ResourceUtils.getAllTypesForResource(resource, types, jaxbOnly, jaxbWriter);
        }
        return types;
    }

    public static Class<?> getActualJaxbType(Class<?> type, Method resourceMethod, boolean inbound) {
        ElementClass element = resourceMethod.getAnnotation(ElementClass.class);
        if (element != null) {
            Class cls;
            Class clazz = cls = inbound ? element.request() : element.response();
            if (cls != Object.class) {
                return cls;
            }
        }
        return type;
    }

    private static void getAllTypesForResource(ClassResourceInfo resource, ResourceTypes types, boolean jaxbOnly, MessageBodyWriter<?> jaxbWriter) {
        for (OperationResourceInfo ori : resource.getMethodDispatcher().getOperationResourceInfos()) {
            Method method = ori.getMethodToInvoke();
            Class<?> realReturnType = method.getReturnType();
            Class<?> cls = realReturnType;
            if (cls == Response.class) {
                cls = ResourceUtils.getActualJaxbType(cls, method, false);
            }
            Type type = method.getGenericReturnType();
            if (jaxbOnly) {
                ResourceUtils.checkJaxbType(cls, realReturnType == Response.class ? cls : type, types, method.getAnnotations(), jaxbWriter);
            } else {
                types.getAllTypes().put(cls, type);
            }
            for (Parameter pm : ori.getParameters()) {
                if (pm.getType() != ParameterType.REQUEST_BODY) continue;
                Class<?> inType = method.getParameterTypes()[pm.getIndex()];
                Type paramType = method.getGenericParameterTypes()[pm.getIndex()];
                if (jaxbOnly) {
                    ResourceUtils.checkJaxbType(inType, paramType, types, method.getParameterAnnotations()[pm.getIndex()], jaxbWriter);
                    continue;
                }
                types.getAllTypes().put(inType, paramType);
            }
        }
        for (ClassResourceInfo sub : resource.getSubResources()) {
            if (ResourceUtils.isRecursiveSubResource(resource, sub)) continue;
            ResourceUtils.getAllTypesForResource(sub, types, jaxbOnly, jaxbWriter);
        }
    }

    private static boolean isRecursiveSubResource(ClassResourceInfo parent, ClassResourceInfo sub) {
        if (parent == null) {
            return false;
        }
        if (parent == sub) {
            return true;
        }
        return ResourceUtils.isRecursiveSubResource(parent.getParent(), sub);
    }

    private static void checkJaxbType(Class<?> type, Type genericType, ResourceTypes types, Annotation[] anns, MessageBodyWriter<?> jaxbWriter) {
        boolean isCollection = false;
        if (InjectionUtils.isSupportedCollectionOrArray(type)) {
            type = InjectionUtils.getActualType((Type)genericType);
            isCollection = true;
        }
        if (type == null || InjectionUtils.isPrimitive((Class)type) || JAXBElement.class.isAssignableFrom(type) || Response.class.isAssignableFrom(type) || type.isInterface()) {
            return;
        }
        JAXBElementProvider writer = jaxbWriter;
        if (writer == null) {
            writer = new JAXBElementProvider();
        }
        if (writer.isWriteable(type, (Type)type, anns, MediaType.APPLICATION_XML_TYPE)) {
            XMLName name;
            QName qname;
            types.getAllTypes().put(type, type);
            Class genCls = InjectionUtils.getActualType((Type)genericType);
            if (genCls != type && genCls != null && genCls != Object.class && !InjectionUtils.isSupportedCollectionOrArray((Class)genCls)) {
                types.getAllTypes().put(genCls, genCls);
            }
            QName qName = qname = (name = (XMLName)AnnotationUtils.getAnnotation((Annotation[])anns, XMLName.class)) != null ? JAXRSUtils.convertStringToQName((String)name.value()) : null;
            if (isCollection) {
                types.getCollectionMap().put(type, qname);
            } else {
                types.getXmlNameMap().put(type, qname);
            }
        }
    }

    private static UserResource getResourceFromElement(Element e) {
        UserResource resource = new UserResource();
        resource.setName(e.getAttribute("name"));
        resource.setPath(e.getAttribute("path"));
        resource.setConsumes(e.getAttribute("consumes"));
        resource.setProduces(e.getAttribute("produces"));
        List operEls = DOMUtils.findAllElementsByTagNameNS((Element)e, (String)"http://cxf.apache.org/jaxrs", (String)"operation");
        ArrayList<UserOperation> opers = new ArrayList<UserOperation>(operEls.size());
        for (Element operEl : operEls) {
            opers.add(ResourceUtils.getOperationFromElement(operEl));
        }
        resource.setOperations(opers);
        return resource;
    }

    private static UserOperation getOperationFromElement(Element e) {
        UserOperation op = new UserOperation();
        op.setName(e.getAttribute("name"));
        op.setVerb(e.getAttribute("verb"));
        op.setPath(e.getAttribute("path"));
        op.setOneway(Boolean.parseBoolean(e.getAttribute("oneway")));
        op.setConsumes(e.getAttribute("consumes"));
        op.setProduces(e.getAttribute("produces"));
        List paramEls = DOMUtils.findAllElementsByTagNameNS((Element)e, (String)"http://cxf.apache.org/jaxrs", (String)"param");
        ArrayList<Parameter> params = new ArrayList<Parameter>(paramEls.size());
        for (int i = 0; i < paramEls.size(); ++i) {
            Element paramEl = (Element)paramEls.get(i);
            Parameter p = new Parameter(paramEl.getAttribute("type"), i, paramEl.getAttribute("name"));
            p.setEncoded(Boolean.valueOf(paramEl.getAttribute("encoded")).booleanValue());
            p.setDefaultValue(paramEl.getAttribute("defaultValue"));
            params.add(p);
        }
        op.setParameters(params);
        return op;
    }

    public static Object[] createConstructorArguments(Constructor<?> c, Message m, boolean perRequest) {
        return ResourceUtils.createConstructorArguments(c, m, perRequest, null);
    }

    public static Object[] createConstructorArguments(Constructor<?> c, Message m, boolean perRequest, Map<Class<?>, Object> contextValues) {
        Class<?>[] params = c.getParameterTypes();
        Annotation[][] anns = c.getParameterAnnotations();
        Type[] genericTypes = c.getGenericParameterTypes();
        MultivaluedMap templateValues = m == null ? null : (MultivaluedMap)m.get((Object)"jaxrs.template.parameters");
        Object[] values = new Object[params.length];
        for (int i = 0; i < params.length; ++i) {
            if (AnnotationUtils.getAnnotation((Annotation[])anns[i], Context.class) != null) {
                Object contextValue;
                Object object = contextValue = contextValues != null ? contextValues.get(params[i]) : null;
                if (contextValue == null) {
                    if (perRequest) {
                        values[i] = JAXRSUtils.createContextValue((Message)m, (Type)genericTypes[i], params[i]);
                        continue;
                    }
                    values[i] = InjectionUtils.createThreadLocalProxy(params[i]);
                    continue;
                }
                values[i] = contextValue;
                continue;
            }
            Parameter p = ResourceUtils.getParameter(i, anns[i], params[i]);
            values[i] = JAXRSUtils.createHttpParameterValue((Parameter)p, params[i], (Type)genericTypes[i], (Annotation[])anns[i], (Message)m, (MultivaluedMap)templateValues, null);
        }
        return values;
    }

    protected static boolean isValidProvider(Class<?> c) {
        if (c == null || c == Object.class) {
            return false;
        }
        if (c.getAnnotation(Provider.class) != null) {
            return true;
        }
        for (Class<?> itf : c.getInterfaces()) {
            if (!SERVER_PROVIDER_CLASS_NAMES.contains(itf.getName())) continue;
            return true;
        }
        return ResourceUtils.isValidProvider(c.getSuperclass());
    }

    protected static boolean isValidResource(Class<?> c) {
        if (c == null || c == Object.class) {
            return false;
        }
        if (c.getAnnotation(Path.class) != null) {
            return true;
        }
        if (c.getInterfaces() != null) {
            for (Class<?> ci : c.getInterfaces()) {
                if (!ResourceUtils.isValidResource(ci)) continue;
                return true;
            }
        }
        return ResourceUtils.isValidResource(c.getSuperclass());
    }

    public static void verifySingletons(Set<Object> singletons) {
        if (singletons.isEmpty()) {
            return;
        }
        HashSet<String> map = new HashSet<String>();
        for (Object s : singletons) {
            if (map.contains(s.getClass().getName())) {
                throw new RuntimeException("More than one instance of the same singleton class " + s.getClass().getName() + " is available");
            }
            map.add(s.getClass().getName());
        }
    }

    public static boolean isNotAbstractClass(Class<?> c) {
        return !c.isInterface() && !Modifier.isAbstract(c.getModifiers());
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        SERVER_PROVIDER_CLASS_NAMES.add("javax.ws.rs.ext.MessageBodyWriter");
        SERVER_PROVIDER_CLASS_NAMES.add("javax.ws.rs.ext.MessageBodyReader");
        SERVER_PROVIDER_CLASS_NAMES.add("javax.ws.rs.ext.ExceptionMapper");
        SERVER_PROVIDER_CLASS_NAMES.add("javax.ws.rs.ext.ContextResolver");
        SERVER_PROVIDER_CLASS_NAMES.add("javax.ws.rs.ext.ReaderInterceptor");
        SERVER_PROVIDER_CLASS_NAMES.add("javax.ws.rs.ext.WriterInterceptor");
        SERVER_PROVIDER_CLASS_NAMES.add("javax.ws.rs.ext.ParamConverterProvider");
        SERVER_PROVIDER_CLASS_NAMES.add("javax.ws.rs.container.ContainerRequestFilter");
        SERVER_PROVIDER_CLASS_NAMES.add("javax.ws.rs.container.ContainerResponseFilter");
        SERVER_PROVIDER_CLASS_NAMES.add("javax.ws.rs.container.DynamicFeature");
        SERVER_PROVIDER_CLASS_NAMES.add("org.apache.cxf.jaxrs.ext.ContextResolver");
    }
}

