/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cdi.jndi.liberty;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.cdi.CDIService;
import com.ibm.ws.container.service.naming.JavaColonNamingHelper;
import com.ibm.ws.container.service.naming.NamingConstants;
import com.ibm.wsspi.kernel.service.utils.AtomicServiceReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.enterprise.inject.spi.BeanManager;
import javax.naming.InvalidNameException;
import javax.naming.NameClassPair;
import javax.naming.NamingException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Trivial
@Component(property={"service.vendor=IBM"})
public class BeanManagerJavaColonNamingHelper
implements JavaColonNamingHelper {
    private static final TraceComponent tc = Tr.register(BeanManagerJavaColonNamingHelper.class);
    private final AtomicServiceReference<CDIService> cdiServiceRef = new AtomicServiceReference("cdiService");
    private static final String BEAN_MANAGER = "BeanManager";

    public Object getObjectInstance(NamingConstants.JavaColonNamespace namespace, String name) throws NamingException {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (namespace != NamingConstants.JavaColonNamespace.COMP) {
            if (isTraceOn && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"getObjectInstance : null (not COMP)", (Object[])new Object[0]);
            }
            return null;
        }
        if (!BEAN_MANAGER.equals(name)) {
            if (isTraceOn && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"getObjectInstance : null (not BeanManager )", (Object[])new Object[0]);
            }
            return null;
        }
        BeanManager bm = null;
        CDIService cdiService = this.getCdiService();
        if (cdiService == null) {
            if (isTraceOn && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"getObjectInstance : The CDIService is not available. The server cannot locate the CDI BeanManager until the CDIService has started.", (Object[])new Object[0]);
            }
        } else {
            bm = cdiService.getCurrentModuleBeanManager();
        }
        return bm;
    }

    public boolean hasObjectWithPrefix(NamingConstants.JavaColonNamespace namespace, String name) throws NamingException {
        if (name == null) {
            throw new InvalidNameException();
        }
        boolean result = false;
        if (namespace == NamingConstants.JavaColonNamespace.COMP && name.isEmpty()) {
            result = true;
        }
        return result;
    }

    public Collection<? extends NameClassPair> listInstances(NamingConstants.JavaColonNamespace namespace, String nameInContext) throws NamingException {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        List retVal = null;
        if (namespace == NamingConstants.JavaColonNamespace.COMP && "".equals(nameInContext)) {
            retVal = new ArrayList();
            retVal.add(new NameClassPair(BEAN_MANAGER, BeanManager.class.getName()));
            return retVal;
        }
        if (isTraceOn && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"listInstances", (Object[])new Object[]{"empty (not COMP)"});
        }
        retVal = Collections.emptyList();
        return retVal;
    }

    public void activate(ComponentContext context) {
        this.cdiServiceRef.activate(context);
    }

    public void deactivate(ComponentContext context) {
        this.cdiServiceRef.deactivate(context);
    }

    @Reference(name="cdiService", service=CDIService.class)
    protected void setCdiService(ServiceReference<CDIService> ref) {
        this.cdiServiceRef.setReference(ref);
    }

    protected void unsetCdiService(ServiceReference<CDIService> ref) {
        this.cdiServiceRef.unsetReference(ref);
    }

    private CDIService getCdiService() {
        return (CDIService)this.cdiServiceRef.getService();
    }
}

