/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.kernel.boot.internal;

import com.ibm.ws.kernel.boot.Debug;
import com.ibm.ws.kernel.boot.cmdline.Utils;
import com.ibm.ws.kernel.boot.internal.ProcessStatus;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Locale;

public class PSProcessStatusImpl
implements ProcessStatus {
    private static final boolean WINDOWS = System.getProperty("os.name").toLowerCase(Locale.ENGLISH).contains("windows");
    private final String pid;

    public PSProcessStatusImpl(String pid) {
        this.pid = pid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * WARNING - bad return control flow
     */
    @Override
    public boolean isPossiblyRunning() {
        boolean bl;
        if (this.pid.isEmpty()) {
            return true;
        }
        ProcessBuilder pb = new ProcessBuilder(new String[0]);
        if (WINDOWS) {
            pb.command("ps", "-W", "-p", this.pid);
        } else {
            pb.command("ps", "-p", this.pid);
        }
        Debug.println(pb.command());
        pb.redirectErrorStream(true);
        InputStream in = null;
        BufferedReader reader = null;
        try {
            String line;
            Process p = pb.start();
            in = p.getInputStream();
            reader = new BufferedReader(new InputStreamReader(in));
            while ((line = reader.readLine()) != null) {
                Debug.println(line);
            }
            p.waitFor();
            bl = p.exitValue() == 0;
        }
        catch (IOException e) {
            Debug.printStackTrace(e);
            Utils.tryToClose(in);
            Utils.tryToClose(reader);
        }
        catch (InterruptedException e2) {
            Debug.printStackTrace(e2);
            {
                catch (Throwable throwable) {
                    Utils.tryToClose(in);
                    Utils.tryToClose(reader);
                    throw throwable;
                }
            }
            Utils.tryToClose(in);
            Utils.tryToClose(reader);
        }
        Utils.tryToClose(in);
        Utils.tryToClose(reader);
        return bl;
        return true;
    }
}

