/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.javaee.ddmodel.permissions;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.javaee.dd.permissions.PermissionsConfig;
import com.ibm.ws.javaee.ddmodel.DDParser;
import com.ibm.ws.javaee.ddmodel.permissions.PermissionsConfigDDParser;
import com.ibm.ws.javaee.version.JavaEEVersion;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.adaptable.module.Container;
import com.ibm.wsspi.adaptable.module.Entry;
import com.ibm.wsspi.adaptable.module.UnableToAdaptException;
import com.ibm.wsspi.adaptable.module.adapters.ContainerAdapter;
import com.ibm.wsspi.artifact.ArtifactContainer;
import com.ibm.wsspi.artifact.overlay.OverlayContainer;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.Version;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public final class PermissionsAdapter
implements ContainerAdapter<PermissionsConfig> {
    private ServiceReference<JavaEEVersion> versionRef;
    private volatile Version platformVersion = JavaEEVersion.DEFAULT_VERSION;
    static final long serialVersionUID = -1833476771394902571L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public synchronized void setVersion(ServiceReference<JavaEEVersion> reference) {
        this.versionRef = reference;
        this.platformVersion = Version.parseVersion((String)((String)reference.getProperty("version")));
    }

    public synchronized void unsetVersion(ServiceReference<JavaEEVersion> reference) {
        if (reference == this.versionRef) {
            this.versionRef = null;
            this.platformVersion = JavaEEVersion.DEFAULT_VERSION;
        }
    }

    @FFDCIgnore(value={DDParser.ParseException.class})
    public PermissionsConfig adapt(Container root, OverlayContainer rootOverlay, ArtifactContainer artifactContainer, Container containerToAdapt) throws UnableToAdaptException {
        Entry ddEntry = containerToAdapt.getEntry("META-INF/permissions.xml");
        if (ddEntry != null) {
            try {
                PermissionsConfigDDParser ddParser = new PermissionsConfigDDParser(containerToAdapt, ddEntry);
                PermissionsConfig permissionsConfig = ddParser.parse();
                return permissionsConfig;
            }
            catch (DDParser.ParseException e) {
                throw new UnableToAdaptException((Throwable)e);
            }
        }
        return null;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(PermissionsAdapter.class);
    }
}

