/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.logging.collector;

import com.ibm.ws.logging.collector.BurstDateFormat;
import java.text.DateFormat;
import java.text.SimpleDateFormat;

public class DateFormatHelper {
    private static ThreadLocal<BurstDateFormat> dateformats = new ThreadLocal();
    private static final ThreadLocal<String> localeDatePattern = new ThreadLocal();

    public static final String formatTime(long timestamp, boolean useIsoDateFormat) {
        BurstDateFormat df = dateformats.get();
        if (df == null) {
            SimpleDateFormat formatter = (SimpleDateFormat)DateFormatHelper.getDateFormat();
            df = new BurstDateFormat((SimpleDateFormat)DateFormatHelper.getDateFormat());
            dateformats.set(df);
            String ddp = formatter.toPattern();
            localeDatePattern.set(ddp);
        }
        try {
            if (useIsoDateFormat) {
                df.applyPattern("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
            } else {
                df.applyPattern(localeDatePattern.get());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return df.format(timestamp);
    }

    private static DateFormat getDateFormat() {
        DateFormat formatter = DateFormat.getDateTimeInstance(3, 2);
        if (formatter instanceof SimpleDateFormat) {
            SimpleDateFormat sdFormatter = (SimpleDateFormat)formatter;
            String pattern = sdFormatter.toPattern();
            int patternLength = pattern.length();
            int endOfSecsIndex = pattern.lastIndexOf(115) + 1;
            String newPattern = pattern.substring(0, endOfSecsIndex) + ":SSS z";
            if (endOfSecsIndex < patternLength) {
                newPattern = newPattern + pattern.substring(endOfSecsIndex, patternLength);
            }
            newPattern = newPattern.replace('h', 'H');
            newPattern = newPattern.replace('K', 'H');
            newPattern = newPattern.replace('k', 'H');
            newPattern = newPattern.replace('a', ' ');
            newPattern = newPattern.trim();
            sdFormatter.applyPattern(newPattern);
            formatter = sdFormatter;
        } else {
            formatter = new SimpleDateFormat("dd/MMM/yyyy HH:mm:ss:SSS z");
        }
        return formatter;
    }
}

