/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.logging.data;

import com.ibm.ws.logging.data.KeyValuePair;
import com.ibm.ws.logging.data.KeyValuePairList;
import com.ibm.ws.logging.data.Pair;
import java.util.ArrayList;
import java.util.logging.Level;

public class GenericData {
    private final ArrayList<Pair> pairs = new ArrayList();
    private String sourceType;
    private Level logRecordLevel = null;
    private String loggerName = null;

    public void addPair(String key, String value) {
        KeyValuePair kvp = new KeyValuePair(key, value, KeyValuePair.ValueTypes.STRING);
        this.pairs.add(kvp);
    }

    public void addPair(String key, Number value) {
        KeyValuePair kvp = new KeyValuePair(key, value.toString(), KeyValuePair.ValueTypes.NUMBER);
        this.pairs.add(kvp);
    }

    public void addPairs(KeyValuePairList kvps) {
        this.pairs.add(kvps);
    }

    public ArrayList<Pair> getPairs() {
        return this.pairs;
    }

    public String getSourceType() {
        return this.sourceType;
    }

    public void setSourceType(String sourceType) {
        this.sourceType = sourceType;
    }

    public void setLogRecordLevel(Level logRecordLevel) {
        this.logRecordLevel = logRecordLevel;
    }

    public Level getLogRecordLevel() {
        return this.logRecordLevel;
    }

    public void setLoggerName(String loggerName) {
        this.loggerName = loggerName;
    }

    public String getLoggerName() {
        return this.loggerName;
    }

    public String getMessageID() {
        for (Pair p : this.pairs) {
            KeyValuePair kvp;
            if (!(p instanceof KeyValuePair) || !(kvp = (KeyValuePair)p).getKey().equals("ibm_messageId")) continue;
            return kvp.getValue();
        }
        return "";
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        String comma = ",";
        sb.append("GenericData [");
        sb.append("type=" + this.sourceType);
        for (Pair p : this.pairs) {
            if (!(p instanceof KeyValuePair)) continue;
            KeyValuePair kvp = (KeyValuePair)p;
            String key = kvp.getKey();
            String val = kvp.getValue();
            sb.append(comma);
            if (this.sourceType.equals("com.ibm.ws.logging.ffdc.source.ffdcsource") && key.equals("ibm_threadId")) {
                key = "threadID";
            }
            sb.append(key + "=" + val);
        }
        sb.append("]");
        return sb.toString();
    }
}

