/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.logging.internal.impl;

import com.ibm.websphere.logging.WsLevel;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.collector.manager.buffer.BufferManagerImpl;
import com.ibm.ws.logging.RoutedMessage;
import com.ibm.ws.logging.WsMessageRouter;
import com.ibm.ws.logging.WsTraceRouter;
import com.ibm.ws.logging.internal.impl.BaseTraceService;
import com.ibm.ws.logging.internal.impl.ConsoleLogHandler;
import com.ibm.ws.logging.internal.impl.LogProviderConfigImpl;
import com.ibm.ws.logging.internal.impl.MessageLogHandler;
import com.ibm.ws.logging.internal.impl.RoutedMessageImpl;
import com.ibm.ws.logging.source.LogSource;
import com.ibm.ws.logging.source.TraceSource;
import com.ibm.ws.logging.utils.CollectorManagerPipelineUtils;
import com.ibm.wsspi.collector.manager.SynchronousHandler;
import com.ibm.wsspi.logging.MessageRouter;
import com.ibm.wsspi.logprovider.LogProviderConfig;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.LogRecord;

public class JsonTraceService
extends BaseTraceService {
    private final boolean isJSON = true;
    private volatile LogSource logSource = null;
    private volatile TraceSource traceSource = null;
    private volatile MessageLogHandler messageLogHandler = null;
    private volatile ConsoleLogHandler consoleLogHandler = null;
    private volatile BufferManagerImpl logConduit;
    private volatile BufferManagerImpl traceConduit;
    private volatile CollectorManagerPipelineUtils collectorMgrPipelineUtils = null;
    private static volatile boolean isMessageJsonConfigured = false;
    private static volatile boolean isConsoleJsonConfigured = false;
    private static volatile Object sync = new Object();
    private volatile String serverName = null;
    private volatile String wlpUserDir = null;

    @Override
    public synchronized void update(LogProviderConfig config) {
        super.update(config);
        LogProviderConfigImpl jsonTRConfig = (LogProviderConfigImpl)config;
        this.serverName = jsonTRConfig.getServerName();
        this.wlpUserDir = jsonTRConfig.getWlpUsrDir();
        if (this.collectorMgrPipelineUtils == null) {
            this.collectorMgrPipelineUtils = CollectorManagerPipelineUtils.getInstance();
        }
        this.logSource = this.collectorMgrPipelineUtils.getLogSource();
        this.traceSource = this.collectorMgrPipelineUtils.getTraceSource();
        this.logConduit = this.collectorMgrPipelineUtils.getLogConduit();
        this.traceConduit = this.collectorMgrPipelineUtils.getTraceConduit();
        String messageFormat = jsonTRConfig.getMessageFormat();
        String consoleFormat = jsonTRConfig.getConsoleFormat();
        ArrayList<String> messageSourceList = new ArrayList<String>(jsonTRConfig.getMessageSource());
        ArrayList<String> consoleSourceList = new ArrayList<String>(jsonTRConfig.getConsoleSource());
        List<String> filterdMessageSourceList = this.filterSourcelist(messageSourceList);
        List<String> filterdConsoleSourceList = this.filterSourcelist(consoleSourceList);
        if (this.messageLogHandler == null) {
            this.messageLogHandler = new MessageLogHandler(this.serverName, this.wlpUserDir, filterdMessageSourceList);
            this.collectorMgrPipelineUtils.setMessageHandler(this.messageLogHandler);
        }
        if (this.consoleLogHandler == null) {
            this.consoleLogHandler = new ConsoleLogHandler(this.serverName, this.wlpUserDir, filterdConsoleSourceList);
            this.collectorMgrPipelineUtils.setConsoleHandler(this.consoleLogHandler);
        }
        this.consoleLogHandler.setConsoleLogLevel(this.consoleLogLevel);
        this.consoleLogHandler.setCopySystemStreams(this.copySystemStreams);
        if (messageFormat.toLowerCase().equals("basic")) {
            isMessageJsonConfigured = false;
            if (this.messageLogHandler != null) {
                this.updateConduitSyncHandlerConnection(new ArrayList<String>(), this.messageLogHandler);
                this.messageLogHandler.setWriter(null);
            }
        }
        if (consoleFormat.toLowerCase().equals("basic")) {
            isConsoleJsonConfigured = false;
            if (this.consoleLogHandler != null) {
                this.updateConduitSyncHandlerConnection(new ArrayList<String>(), this.consoleLogHandler);
                this.consoleLogHandler.setWriter(null);
            }
        }
        if (messageFormat.toLowerCase().equals("json")) {
            this.setJsonConfigured();
            this.messageLogHandler.modified(filterdMessageSourceList);
            this.messageLogHandler.setWriter(this.messagesLog);
            isMessageJsonConfigured = true;
            this.updateConduitSyncHandlerConnection(messageSourceList, this.messageLogHandler);
        }
        if (consoleFormat.toLowerCase().equals("json")) {
            this.setJsonConfigured();
            this.consoleLogHandler.modified(filterdConsoleSourceList);
            this.updateConduitSyncHandlerConnection(consoleSourceList, this.consoleLogHandler);
            this.consoleLogHandler.setWriter(this.systemOut);
            isConsoleJsonConfigured = true;
        }
    }

    private void setJsonConfigured() {
        this.collectorMgrPipelineUtils.setJsonTrService(true);
    }

    private List<String> filterSourcelist(List<String> sourceList) {
        ArrayList<String> filteredList = new ArrayList<String>(sourceList);
        filteredList.remove("trace");
        filteredList.remove("message");
        return filteredList;
    }

    private void updateConduitSyncHandlerConnection(List<String> sourceList, SynchronousHandler handler) {
        if (sourceList.contains("message")) {
            this.logConduit.addSyncHandler(handler);
        } else {
            this.logConduit.removeSyncHandler(handler);
        }
        if (sourceList.contains("trace")) {
            this.traceConduit.addSyncHandler(handler);
        } else {
            this.traceConduit.removeSyncHandler(handler);
        }
    }

    @Override
    public void echo(BaseTraceService.SystemLogHolder holder, LogRecord logRecord) {
        BaseTraceService.TraceWriter detailLog = this.traceLog;
        String message = this.formatter.messageLogFormat(logRecord, logRecord.getMessage());
        if (!isMessageJsonConfigured) {
            this.messagesLog.writeRecord(message);
        }
        this.invokeMessageRouters(new RoutedMessageImpl(logRecord.getMessage(), logRecord.getMessage(), message, logRecord));
        if (detailLog == this.systemOut) {
            this.publishTraceLogRecord(holder, logRecord, NULL_ID, NULL_FORMATTED_MSG, NULL_FORMATTED_MSG);
        } else {
            if (this.copySystemStreams && !isConsoleJsonConfigured) {
                this.writeFilteredStreamOutput(holder, logRecord);
            }
            if (TraceComponent.isAnyTracingEnabled()) {
                this.publishTraceLogRecord(detailLog, logRecord, NULL_ID, NULL_FORMATTED_MSG, NULL_FORMATTED_MSG);
            }
        }
    }

    @Override
    protected boolean invokeMessageRouters(RoutedMessage routedMessage) {
        MessageRouter externalMsgRouter = (MessageRouter)this.externalMessageRouter.get();
        WsMessageRouter internalMsgRouter = (WsMessageRouter)this.internalMessageRouter.get();
        boolean retMe = true;
        if (externalMsgRouter != null) {
            retMe &= externalMsgRouter.route(routedMessage.getFormattedMsg(), routedMessage.getLogRecord());
        }
        if (internalMsgRouter != null) {
            retMe &= internalMsgRouter.route(routedMessage);
        } else {
            this.earlierMessages.add(routedMessage);
            if (this.logSource != null && (isMessageJsonConfigured || isConsoleJsonConfigured)) {
                this.logSource.publish(routedMessage);
            }
        }
        return retMe;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean invokeTraceRouters(RoutedMessage routedTrace) {
        boolean retMe = true;
        LogRecord logRecord = routedTrace.getLogRecord();
        try {
            String levelName;
            Level level;
            int levelValue;
            if (counter.incrementCount() <= 2 && logRecord != null && (levelValue = (level = logRecord.getLevel()).intValue()) < Level.INFO.intValue() && !(levelName = level.getName()).equals("SystemOut") && !levelName.equals("SystemErr")) {
                WsTraceRouter internalTrRouter = (WsTraceRouter)this.internalTraceRouter.get();
                if (internalTrRouter != null) {
                    retMe &= internalTrRouter.route(routedTrace);
                } else {
                    this.earlierTraces.add(routedTrace);
                    if (this.traceSource != null && (isMessageJsonConfigured || isConsoleJsonConfigured)) {
                        this.traceSource.publish(routedTrace);
                    }
                }
            }
        }
        finally {
            counter.decrementCount();
        }
        return retMe;
    }

    @Override
    public void publishLogRecord(LogRecord logRecord) {
        String formattedMsg = null;
        String formattedVerboseMsg = null;
        Level level = logRecord.getLevel();
        int levelValue = level.intValue();
        BaseTraceService.TraceWriter detailLog = this.traceLog;
        if (levelValue >= Level.INFO.intValue()) {
            String messageLogFormat;
            formattedMsg = this.formatter.formatMessage(logRecord);
            boolean logNormally = this.invokeMessageRouters(new RoutedMessageImpl(formattedMsg, formattedVerboseMsg = this.formatter.formatVerboseMessage(logRecord, formattedMsg), messageLogFormat = this.formatter.messageLogFormat(logRecord, formattedVerboseMsg), logRecord));
            if (!logNormally) {
                return;
            }
            if (this.isMessageHidden(formattedMsg)) {
                this.publishTraceLogRecord(detailLog, logRecord, NULL_ID, formattedMsg, formattedVerboseMsg);
                return;
            }
            if (!isMessageJsonConfigured) {
                this.messagesLog.writeRecord(messageLogFormat);
            }
            if (detailLog == this.systemOut) {
                if (levelValue == WsLevel.ERROR.intValue() || levelValue == WsLevel.FATAL.intValue()) {
                    this.publishTraceLogRecord(this.systemErr, logRecord, NULL_ID, formattedMsg, formattedVerboseMsg);
                } else {
                    this.publishTraceLogRecord(this.systemOut, logRecord, NULL_ID, formattedMsg, formattedVerboseMsg);
                }
                return;
            }
            if (levelValue >= this.consoleLogLevel.intValue() && !isConsoleJsonConfigured) {
                String consoleMsg = this.formatter.consoleLogFormat(logRecord, formattedMsg);
                if (levelValue == WsLevel.ERROR.intValue() || levelValue == WsLevel.FATAL.intValue()) {
                    this.writeStreamOutput(this.systemErr, consoleMsg, false);
                } else {
                    this.writeStreamOutput(this.systemOut, consoleMsg, false);
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled()) {
            this.publishTraceLogRecord(detailLog, logRecord, NULL_ID, formattedMsg, formattedVerboseMsg);
        }
    }

    @Override
    protected void publishTraceLogRecord(BaseTraceService.TraceWriter detailLog, LogRecord logRecord, Object id, String formattedMsg, String formattedVerboseMsg) {
        if (formattedVerboseMsg == null) {
            formattedVerboseMsg = this.formatter.formatVerboseMessage(logRecord, formattedMsg, false);
        }
        String traceDetail = this.formatter.traceLogFormat(logRecord, id, formattedMsg, formattedVerboseMsg);
        this.invokeTraceRouters(new RoutedMessageImpl(formattedMsg, formattedVerboseMsg, traceDetail, logRecord));
        if (detailLog == this.systemOut || detailLog == this.systemErr) {
            if (!isConsoleJsonConfigured) {
                this.writeStreamOutput((BaseTraceService.SystemLogHolder)detailLog, traceDetail, false);
            }
        } else {
            detailLog.writeRecord(traceDetail);
        }
    }
}

