/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.logging.source;

import com.ibm.websphere.ras.DataFormatHelper;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.collector.manager.buffer.BufferManagerImpl;
import com.ibm.ws.logging.RoutedMessage;
import com.ibm.ws.logging.WsLogHandler;
import com.ibm.ws.logging.data.GenericData;
import com.ibm.ws.logging.data.KeyValuePairList;
import com.ibm.ws.logging.internal.WsLogRecord;
import com.ibm.ws.logging.synch.ThreadLocalHandler;
import com.ibm.ws.logging.utils.LogFormatUtils;
import com.ibm.ws.logging.utils.SequenceNumber;
import com.ibm.wsspi.collector.manager.BufferManager;
import com.ibm.wsspi.collector.manager.Source;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Map;
import java.util.logging.LogRecord;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class LogSource
implements Source,
WsLogHandler {
    private static final TraceComponent tc = Tr.register(LogSource.class);
    private final String sourceName = "com.ibm.ws.logging.source.message";
    private final String location = "memory";
    private BufferManager bufferMgr = null;
    static Pattern messagePattern = Pattern.compile("^([A-Z][\\dA-Z]{3,4})(\\d{4})([A-Z])(:)");
    private final SequenceNumber sequenceNumber = new SequenceNumber();
    public static final String LINE_SEPARATOR = AccessController.doPrivileged(new PrivilegedAction<String>(){

        @Override
        public String run() {
            return System.getProperty("line.separator");
        }
    });

    protected void activate(Map<String, Object> configuration) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event(tc, "Activating " + this, new Object[0]);
        }
    }

    protected void deactivate(int reason) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event(tc, " Deactivating " + this, " reason = " + reason);
        }
    }

    @Override
    public void setBufferManager(BufferManager bufferMgr) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event(tc, "Setting buffer manager " + this, new Object[0]);
        }
        this.bufferMgr = bufferMgr;
    }

    @Override
    public void unsetBufferManager(BufferManager bufferMgr) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event(tc, "Un-setting buffer manager " + this, new Object[0]);
        }
        this.bufferMgr = null;
    }

    public BufferManager getBufferManager() {
        return this.bufferMgr;
    }

    @Override
    public String getSourceName() {
        return "com.ibm.ws.logging.source.message";
    }

    @Override
    public String getLocation() {
        return "memory";
    }

    @Override
    @Trivial
    public void publish(RoutedMessage routedMessage) {
        LogRecord logRecord;
        if (!ThreadLocalHandler.get().booleanValue() && (logRecord = routedMessage.getLogRecord()) != null && this.bufferMgr != null) {
            GenericData parsedMessage = this.parse(routedMessage);
            if (!BufferManagerImpl.getEMQRemovedFlag() && this.extractMessage(routedMessage, logRecord).startsWith("CWWKF0011I")) {
                BufferManagerImpl.removeEMQTrigger();
            }
            this.bufferMgr.add(parsedMessage);
        }
    }

    private String extractMessage(RoutedMessage routedMessage, LogRecord logRecord) {
        String messageVal = routedMessage.getFormattedVerboseMsg();
        if (messageVal == null) {
            messageVal = logRecord.getMessage();
        }
        return messageVal;
    }

    public GenericData parse(RoutedMessage routedMessage) {
        String stackTrace;
        GenericData genData = new GenericData();
        LogRecord logRecord = routedMessage.getLogRecord();
        String messageVal = this.extractMessage(routedMessage, logRecord);
        long dateVal = logRecord.getMillis();
        genData.addPair("ibm_datetime", dateVal);
        String messageIdVal = null;
        if (messageVal != null) {
            messageIdVal = this.parseMessageId(messageVal);
        }
        genData.addPair("ibm_messageId", messageIdVal);
        int threadIdVal = (int)Thread.currentThread().getId();
        genData.addPair("ibm_threadId", threadIdVal);
        genData.addPair("module", logRecord.getLoggerName());
        genData.addPair("severity", LogFormatUtils.mapLevelToType(logRecord));
        genData.addPair("loglevel", LogFormatUtils.mapLevelToRawType(logRecord));
        genData.addPair("ibm_methodName", logRecord.getSourceMethodName());
        genData.addPair("ibm_className", logRecord.getSourceClassName());
        KeyValuePairList extensions = new KeyValuePairList();
        Map<String, String> extMap = null;
        if (logRecord instanceof WsLogRecord && ((WsLogRecord)logRecord).getExtensions() != null) {
            extMap = ((WsLogRecord)logRecord).getExtensions();
            for (Map.Entry<String, String> entry : extMap.entrySet()) {
                extensions.addPair(entry.getKey(), entry.getValue());
            }
        }
        genData.addPairs(extensions);
        genData.addPair("ibm_sequence", this.sequenceNumber.next(dateVal));
        Throwable thrown = logRecord.getThrown();
        StringBuilder msgBldr = new StringBuilder();
        msgBldr.append(messageVal);
        if (thrown != null && (stackTrace = DataFormatHelper.throwableToString(thrown)) != null) {
            msgBldr.append(LINE_SEPARATOR).append(stackTrace);
        }
        genData.addPair("message", msgBldr.toString());
        genData.setSourceType("com.ibm.ws.logging.source.message");
        genData.setLogRecordLevel(logRecord.getLevel());
        genData.setLoggerName(logRecord.getLoggerName());
        return genData;
    }

    public GenericData parse(RoutedMessage routedMessage, LogRecord logRecord) {
        String stackTrace;
        GenericData genData = new GenericData();
        String messageVal = this.extractMessage(routedMessage, logRecord);
        long dateVal = logRecord.getMillis();
        genData.addPair("ibm_datetime", dateVal);
        String messageIdVal = null;
        if (messageVal != null) {
            messageIdVal = this.parseMessageId(messageVal);
        }
        genData.addPair("ibm_messageId", messageIdVal);
        int threadIdVal = (int)Thread.currentThread().getId();
        genData.addPair("ibm_threadId", threadIdVal);
        genData.addPair("module", logRecord.getLoggerName());
        genData.addPair("severity", LogFormatUtils.mapLevelToType(logRecord));
        genData.addPair("loglevel", LogFormatUtils.mapLevelToRawType(logRecord));
        genData.addPair("ibm_methodName", logRecord.getSourceMethodName());
        genData.addPair("ibm_className", logRecord.getSourceClassName());
        KeyValuePairList extensions = new KeyValuePairList();
        Map<String, String> extMap = null;
        if (logRecord instanceof WsLogRecord) {
            extMap = ((WsLogRecord)logRecord).getExtensions();
            for (Map.Entry<String, String> entry : extMap.entrySet()) {
                extensions.addPair(entry.getKey(), entry.getValue());
            }
        }
        genData.addPairs(extensions);
        genData.addPair("ibm_sequence", this.sequenceNumber.next(dateVal));
        Throwable thrown = logRecord.getThrown();
        StringBuilder msgBldr = new StringBuilder();
        msgBldr.append(messageVal);
        if (thrown != null && (stackTrace = DataFormatHelper.throwableToString(thrown)) != null) {
            msgBldr.append(LINE_SEPARATOR).append(stackTrace);
        }
        genData.addPair("message", msgBldr.toString());
        genData.setSourceType("com.ibm.ws.logging.source.message");
        return genData;
    }

    protected String parseMessageId(String msg) {
        String messageId = null;
        Matcher matcher = messagePattern.matcher(msg);
        if (matcher.find()) {
            messageId = msg.substring(matcher.start(), matcher.end() - 1);
        }
        return messageId;
    }
}

