/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.logging.source;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.logging.RoutedMessage;
import com.ibm.ws.logging.WsTraceHandler;
import com.ibm.ws.logging.data.GenericData;
import com.ibm.ws.logging.data.KeyValuePairList;
import com.ibm.ws.logging.internal.WsLogRecord;
import com.ibm.ws.logging.synch.ThreadLocalHandler;
import com.ibm.ws.logging.utils.LogFormatUtils;
import com.ibm.ws.logging.utils.SequenceNumber;
import com.ibm.wsspi.collector.manager.BufferManager;
import com.ibm.wsspi.collector.manager.Source;
import java.util.Map;
import java.util.logging.LogRecord;

public class TraceSource
implements Source,
WsTraceHandler {
    private static final TraceComponent tc = Tr.register(TraceSource.class);
    private final String sourceName = "com.ibm.ws.logging.source.trace";
    private final String location = "memory";
    private BufferManager bufferMgr = null;
    private final SequenceNumber sequenceNumber = new SequenceNumber();

    protected void activate(Map<String, Object> configuration) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event(tc, "Activating " + this, new Object[0]);
        }
    }

    protected void deactivate(int reason) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event(tc, " Deactivating " + this, " reason = " + reason);
        }
    }

    @Override
    public void setBufferManager(BufferManager bufferMgr) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event(tc, "Setting buffer manager " + this, new Object[0]);
        }
        this.bufferMgr = bufferMgr;
    }

    @Override
    public void unsetBufferManager(BufferManager bufferMgr) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event(tc, "Un-setting buffer manager " + this, new Object[0]);
        }
        this.bufferMgr = null;
    }

    public BufferManager getBufferManager() {
        return this.bufferMgr;
    }

    @Override
    public String getSourceName() {
        return "com.ibm.ws.logging.source.trace";
    }

    @Override
    public String getLocation() {
        return "memory";
    }

    @Override
    public void publish(RoutedMessage routedMessage) {
        if (!ThreadLocalHandler.get().booleanValue() && routedMessage.getLogRecord() != null && this.bufferMgr != null) {
            this.bufferMgr.add(this.parse(routedMessage));
        }
    }

    public GenericData parse(RoutedMessage routedMessage) {
        GenericData genData = new GenericData();
        LogRecord logRecord = routedMessage.getLogRecord();
        String verboseMessage = routedMessage.getFormattedVerboseMsg();
        if (verboseMessage == null) {
            genData.addPair("message", logRecord.getMessage());
        } else {
            genData.addPair("message", verboseMessage);
        }
        long datetimeValue = logRecord.getMillis();
        genData.addPair("ibm_datetime", datetimeValue);
        genData.addPair("ibm_threadId", logRecord.getThreadID());
        genData.addPair("module", logRecord.getLoggerName());
        genData.addPair("severity", LogFormatUtils.mapLevelToType(logRecord));
        genData.addPair("loglevel", LogFormatUtils.mapLevelToRawType(logRecord));
        genData.addPair("ibm_methodName", logRecord.getSourceMethodName());
        genData.addPair("ibm_className", logRecord.getSourceClassName());
        String sequenceNum = this.sequenceNumber.next(datetimeValue);
        genData.addPair("ibm_sequence", sequenceNum);
        KeyValuePairList extensions = new KeyValuePairList();
        Map<String, String> extMap = null;
        if (logRecord instanceof WsLogRecord && ((WsLogRecord)logRecord).getExtensions() != null) {
            extMap = ((WsLogRecord)logRecord).getExtensions();
            for (Map.Entry<String, String> entry : extMap.entrySet()) {
                extensions.addPair(entry.getKey(), entry.getValue());
            }
        }
        genData.addPairs(extensions);
        genData.setSourceType("com.ibm.ws.logging.source.trace");
        return genData;
    }
}

