/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.common.jwk.impl;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.common.jwk.interfaces.JSONWebKey;
import com.ibm.ws.security.common.jwk.interfaces.JWK;
import java.security.PublicKey;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class JWKSet {
    protected List<JWK> jwks = Collections.synchronizedList(new ArrayList());
    private final long Stale = 600000L;
    static final long serialVersionUID = 3417149094552797151L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public List<JWK> getJWKs() {
        return this.jwks;
    }

    public synchronized void addJWK(JWK jwk) {
        long current = new Date().getTime();
        ArrayList<JWK> jwksToBeRemoved = new ArrayList<JWK>();
        for (JWK oldJwk : this.jwks) {
            if (current - oldJwk.getCreated() <= 600000L) continue;
            jwksToBeRemoved.add(oldJwk);
        }
        for (JSONWebKey jSONWebKey : jwksToBeRemoved) {
            this.jwks.remove(jSONWebKey);
        }
        this.jwks.add(0, jwk);
    }

    public JSONWebKey getJWKByKid(String id) {
        if (id == null) {
            if (this.jwks.size() == 1) {
                return this.jwks.get(0);
            }
            return null;
        }
        Iterator<JWK> it = this.jwks.iterator();
        JSONWebKey jwk = null;
        while (it.hasNext()) {
            jwk = it.next();
            if (!id.equals(jwk.getKeyID())) continue;
            return jwk;
        }
        return null;
    }

    public PublicKey getPublicKeyByKid(String id) {
        JSONWebKey jwk = this.getJWKByKid(id);
        if (jwk != null) {
            return jwk.getPublicKey();
        }
        return null;
    }

    public JSONWebKey getJWKByx5t(String id) {
        for (JSONWebKey jSONWebKey : this.jwks) {
            if (!id.equals(jSONWebKey.getKeyX5t())) continue;
            return jSONWebKey;
        }
        return null;
    }

    public PublicKey getPublicKeyByx5t(String id) {
        JSONWebKey jwk = this.getJWKByx5t(id);
        if (jwk != null) {
            return jwk.getPublicKey();
        }
        return null;
    }

    public void remove(JSONWebKey jwk) {
        this.jwks.remove(jwk);
    }

    public void remove(int i) {
        this.jwks.remove(i);
    }

    public void add(JWK jwk) {
        this.jwks.add(jwk);
    }

    public void add(int i, JWK jwk) {
        this.jwks.add(i, jwk);
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(JWKSet.class);
    }
}

