/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.common.web;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.webcontainer.internalRuntimeExport.srt.IPrivateRequestAttributes;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class WebUtils {
    private static final TraceComponent tc = Tr.register(WebUtils.class, (String)"SecurityCommon", (String)"com.ibm.ws.security.common.internal.resources.SSOCommonMessages");
    static final long serialVersionUID = -4243040487895430404L;

    public static String urlEncode(String value) {
        if (value == null) {
            return value;
        }
        try {
            value = URLEncoder.encode(value, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            FFDCFilter.processException((Throwable)unsupportedEncodingException, (String)"com.ibm.ws.security.common.web.WebUtils", (String)"45", null, (Object[])new Object[]{value});
        }
        return value;
    }

    public static String encodeQueryString(String query) {
        String[] queryParams;
        if (query == null) {
            return null;
        }
        StringBuilder rebuiltQuery = new StringBuilder();
        for (String param : queryParams = query.split("&")) {
            String rebuiltParam = WebUtils.urlEncode(param);
            int equalIndex = param.indexOf("=");
            if (equalIndex > -1) {
                String name = param.substring(0, equalIndex);
                String value = equalIndex < param.length() - 1 ? param.substring(equalIndex + 1) : "";
                rebuiltParam = WebUtils.urlEncode(name) + "=" + WebUtils.urlEncode(value);
            }
            if (rebuiltParam.isEmpty()) continue;
            rebuiltQuery.append(rebuiltParam + "&");
        }
        if (rebuiltQuery.length() > 0 && rebuiltQuery.charAt(rebuiltQuery.length() - 1) == '&') {
            rebuiltQuery.deleteCharAt(rebuiltQuery.length() - 1);
        }
        return rebuiltQuery.toString();
    }

    public static String encodeCookie(String string) {
        if (string == null) {
            return null;
        }
        string = string.replaceAll("%", "%25");
        string = string.replaceAll(";", "%3B");
        string = string.replaceAll(",", "%2C");
        return string;
    }

    public static String decodeCookie(String string) {
        if (string == null) {
            return null;
        }
        string = string.replaceAll("%2C", ",");
        string = string.replaceAll("%3B", ";");
        string = string.replaceAll("%25", "%");
        return string;
    }

    public static String htmlEncode(String string) {
        return WebUtils.htmlEncode(string, true, true, true);
    }

    public static String htmlEncode(String string, boolean encodeNewline, boolean encodeSubsequentBlanksToNbsp, boolean encodeNonLatin) {
        if (string == null) {
            return "";
        }
        StringBuilder sb = null;
        for (int i = 0; i < string.length(); ++i) {
            char c;
            String app;
            block30: {
                block29: {
                    app = null;
                    c = string.charAt(i);
                    if (c >= 'A') break block29;
                    switch (c) {
                        case '\"': {
                            app = "&quot;";
                            break;
                        }
                        case '&': {
                            app = "&amp;";
                            break;
                        }
                        case '<': {
                            app = "&lt;";
                            break;
                        }
                        case '>': {
                            app = "&gt;";
                            break;
                        }
                        case ' ': {
                            if (encodeSubsequentBlanksToNbsp && (i == 0 || i - 1 >= 0 && string.charAt(i - 1) == ' ')) {
                                app = "&#160;";
                                break;
                            }
                            break block30;
                        }
                        case '\n': {
                            if (encodeNewline) {
                                app = "<br/>";
                                break;
                            }
                            break block30;
                        }
                    }
                    break block30;
                }
                if (encodeNonLatin && c > '\u0080') {
                    switch (c) {
                        case '\u00e4': {
                            app = "&auml;";
                            break;
                        }
                        case '\u00c4': {
                            app = "&Auml;";
                            break;
                        }
                        case '\u00f6': {
                            app = "&ouml;";
                            break;
                        }
                        case '\u00d6': {
                            app = "&Ouml;";
                            break;
                        }
                        case '\u00fc': {
                            app = "&uuml;";
                            break;
                        }
                        case '\u00dc': {
                            app = "&Uuml;";
                            break;
                        }
                        case '\u00df': {
                            app = "&szlig;";
                            break;
                        }
                        case '\u20ac': {
                            app = "&euro;";
                            break;
                        }
                        case '\u00ab': {
                            app = "&laquo;";
                            break;
                        }
                        case '\u00bb': {
                            app = "&raquo;";
                            break;
                        }
                        case '\u00a0': {
                            app = "&#160;";
                            break;
                        }
                        default: {
                            app = "&#" + c + ";";
                        }
                    }
                }
            }
            if (app != null) {
                if (sb == null) {
                    sb = new StringBuilder(string.substring(0, i));
                }
                sb.append(app);
                continue;
            }
            if (sb == null) continue;
            sb.append(c);
        }
        if (sb == null) {
            return string;
        }
        return sb.toString();
    }

    public static boolean validateUriFormat(String uri) {
        return WebUtils.validateUriFormat(uri, "https?://[a-zA-Z0-9._~%!$&'()*+,;=:@/-]+");
    }

    /*
     * WARNING - void declaration
     */
    public static boolean validateUriFormat(final String uri, String regexToMatch) {
        if (uri == null || uri.isEmpty()) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Provided URI [" + uri + "] was null or empty"), (Object[])new Object[0]);
            }
            return false;
        }
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction<URI>(){
                static final long serialVersionUID = -3160082492214724487L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public URI run() throws URISyntaxException {
                    return new URI(uri);
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register(1.class);
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            FFDCFilter.processException((Throwable)privilegedActionException, (String)"com.ibm.ws.security.common.web.WebUtils", (String)"269", null, (Object[])new Object[]{uri, regexToMatch});
            if (tc.isDebugEnabled()) {
                void e;
                Tr.debug((TraceComponent)tc, (String)("URI was not formatted correctly: " + e.getException().getLocalizedMessage()), (Object[])new Object[0]);
            }
            return false;
        }
        if (!Pattern.matches(regexToMatch, uri)) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"URI did not match expected URI pattern", (Object[])new Object[0]);
            }
            return false;
        }
        return true;
    }

    public Integer getRedirectPortFromRequest(HttpServletRequest req) {
        HttpServletRequest sr = this.getWrappedServletRequestObject(req);
        if (sr instanceof IPrivateRequestAttributes) {
            return (Integer)((IPrivateRequestAttributes)sr).getPrivateAttribute("SecurityRedirectPort");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"getRedirectUrl called for non-IPrivateRequestAttributes object", (Object[])new Object[]{req});
        }
        return null;
    }

    private HttpServletRequest getWrappedServletRequestObject(HttpServletRequest sr) {
        if (sr instanceof HttpServletRequestWrapper) {
            HttpServletRequestWrapper w = (HttpServletRequestWrapper)sr;
            sr = (HttpServletRequest)w.getRequest();
            while (sr instanceof HttpServletRequestWrapper) {
                sr = (HttpServletRequest)((HttpServletRequestWrapper)sr).getRequest();
            }
        }
        return sr;
    }
}

