/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.config.xml.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.config.admin.ConfigID;
import com.ibm.ws.config.xml.internal.SimpleElement;
import com.ibm.ws.config.xml.internal.XMLConfigParser;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

@Trivial
abstract class ConfigElement {
    private final String nodeName;
    protected final GroupHashMap attributes;
    private int sequenceId;
    private String location;
    private String overrideLocation;
    private final Map<String, MERGE_OP> operations;
    private boolean isTextOnly = true;
    private String elementValue = "";
    private ConfigElement parent;
    private List<ConfigElement> children = new ArrayList<ConfigElement>();
    protected String childAttributeName;
    protected XMLConfigParser.MergeBehavior mergeBehavior;
    private LinkedList<String> docLocationStack;
    private LinkedList<XMLConfigParser.MergeBehavior> behaviorStack;
    static Comparator<String> CASE_INSENSITIVE = new Comparator<String>(){
        static final long serialVersionUID = 2579770070088481384L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        @Override
        @Trivial
        public int compare(String s1, String s2) {
            if (s1 == s2) {
                return 0;
            }
            if (s1 == null) {
                return 1;
            }
            if (s2 == null) {
                return -1;
            }
            return s1.compareToIgnoreCase(s2);
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(1.class);
        }
    };

    public String getElementValue() {
        return this.elementValue;
    }

    public void setElementValue(String elementValue) {
        this.elementValue = elementValue;
    }

    public boolean isTextOnly() {
        return this.isTextOnly;
    }

    public void setTextOnly(boolean isTextOnly) {
        this.isTextOnly = isTextOnly;
    }

    protected ConfigElement(String nodeName) {
        if (nodeName == null) {
            throw new NullPointerException("Configuration id must be specified");
        }
        this.nodeName = nodeName;
        this.operations = new HashMap<String, MERGE_OP>();
        this.attributes = new GroupHashMap();
    }

    public ConfigElement(ConfigElement element) {
        this.nodeName = element.nodeName;
        this.location = element.location;
        this.operations = new HashMap<String, MERGE_OP>(element.operations);
        this.attributes = new GroupHashMap(element.attributes);
        this.parent = element.parent;
        this.children = element.children;
        for (ConfigElement child : this.children) {
            child.setParent(this);
        }
        this.childAttributeName = element.childAttributeName;
        this.mergeBehavior = element.mergeBehavior;
        this.docLocationStack = element.docLocationStack;
        this.behaviorStack = element.behaviorStack;
    }

    public String getNodeName() {
        return this.nodeName;
    }

    public abstract boolean isSimple();

    public abstract String getId();

    public void setSequenceId(int sequenceId) {
        this.sequenceId = sequenceId;
    }

    public int getSequenceId() {
        return this.sequenceId;
    }

    public void setDocumentLocation(String location) {
        this.location = location;
    }

    public String getDocumentLocation() {
        return this.location;
    }

    public String getMergedLocation() {
        if (this.overrideLocation == null || this.overrideLocation.equals("")) {
            return this.location;
        }
        return this.overrideLocation;
    }

    public boolean hasNestedElements() {
        return !this.children.isEmpty();
    }

    public String getRefAttr() {
        Object attribute = this.attributes.get("ref");
        if (attribute != null && attribute instanceof String) {
            return (String)attribute;
        }
        return null;
    }

    public String getFullId() {
        return this.getConfigID().toString();
    }

    public ConfigID getConfigID() {
        if (this.getParent() == null) {
            return new ConfigID(this.nodeName, this.getId());
        }
        return new ConfigID(this.getParent().getConfigID(), this.nodeName, this.getId(), this.childAttributeName);
    }

    public void setMergeOperation(String name, MERGE_OP mergeOperation) {
        MERGE_OP operation = this.operations.put(name, mergeOperation);
        if (operation != mergeOperation) {
            // empty if block
        }
    }

    private MERGE_OP getMergeOperation(String name) {
        return this.operations.get(name);
    }

    public boolean containsAttribute(String name) {
        return this.attributes.containsKey(name);
    }

    public Object getAttribute(String name) {
        return this.attributes.get(name);
    }

    public void setAttribute(String name, Object value) {
        this.attributes.put(name, value);
    }

    public void addAttribute(String name, String value) {
        this.checkType(name, String.class);
        this.attributes.put(name, value);
    }

    public void addCollectionAttribute(String name, Object value) {
        List<Object> attributeValues = this.getCollectionAttribute(name);
        attributeValues.add(value);
    }

    private List<Object> getCollectionAttribute(String name) {
        this.checkType(name, List.class);
        ArrayList attributeValues = (ArrayList)this.attributes.get(name);
        if (attributeValues == null) {
            attributeValues = new ArrayList(1);
            this.attributes.put(name, attributeValues);
        }
        return attributeValues;
    }

    public void addReference(String name, String id) {
        List<Object> attributeValues = this.getCollectionAttribute(name);
        attributeValues.add(new Reference(name, id));
    }

    public void addChildConfigElement(String name, SimpleElement configElement) {
        List<Object> attributeValues = this.getCollectionAttribute(name);
        attributeValues.add(configElement);
        this.children.add(configElement);
        configElement.setParent(this);
        configElement.setChildAttributeName(name);
    }

    protected void setChildAttributeName(String name) {
        this.childAttributeName = name;
    }

    private void checkType(String name, Class<?> type) {
        Object attributeValue = this.attributes.get(name);
        if (attributeValue != null && !type.isInstance(attributeValue)) {
            throw new IllegalArgumentException("Configuration property '" + name + "' seems to be specified as an attribute and an element");
        }
    }

    public Map<String, Object> getAttributes() {
        return this.attributes;
    }

    protected void override(ConfigElement in) {
        MERGE_OP defaultOperation = MERGE_OP.APPEND;
        boolean sameLocation = in.getDocumentLocation().equals(this.getDocumentLocation());
        if (!sameLocation) {
            if (in.mergeBehavior == XMLConfigParser.MergeBehavior.IGNORE) {
                return;
            }
            if (in.mergeBehavior == XMLConfigParser.MergeBehavior.REPLACE) {
                defaultOperation = MERGE_OP.SET;
            }
        }
        for (Map.Entry entry : in.attributes.entrySet()) {
            MERGE_OP operation = in.getMergeOperation((String)entry.getKey());
            if (operation == null) {
                operation = defaultOperation;
            }
            Object value = entry.getValue();
            if (operation == MERGE_OP.APPEND && value instanceof List) {
                List<Object> attributeValues = this.getCollectionAttribute((String)entry.getKey());
                List values = (List)value;
                attributeValues.addAll(values);
                continue;
            }
            this.setAttribute((String)entry.getKey(), value);
        }
        this.children.addAll(in.getChildren());
        this.parent = in.getParent();
        this.childAttributeName = in.childAttributeName;
        this.overrideLocation = in.location;
    }

    public void setIdAttribute() {
        if (this.getId() != null) {
            if (this.getId().startsWith("default-")) {
                this.attributes.put("id", this.getFullId());
            } else {
                this.attributes.put("id", this.getId());
            }
        }
    }

    public boolean isEnabled() {
        Object enabled = this.getAttribute("configurationEnabled");
        return !(enabled instanceof String) || !"false".equalsIgnoreCase((String)enabled);
    }

    boolean equalsIgnoreIdAttr(ConfigElement other) {
        if (this == other) {
            return true;
        }
        if (this.elementValue == null && other.elementValue != null || this.elementValue != null && !this.elementValue.equals(other.elementValue)) {
            return false;
        }
        for (Map.Entry entry : this.attributes.entrySet()) {
            String key = (String)entry.getKey();
            if ("id".equals(key)) continue;
            Object value = entry.getValue();
            Object otherValue = other.attributes.get(key);
            if ((value != null || otherValue == null) && (value == null || value.equals(otherValue))) continue;
            return false;
        }
        for (Map.Entry entry : other.attributes.entrySet()) {
            String otherKey = (String)entry.getKey();
            if ("id".equals(otherKey)) continue;
            Object otherValue = entry.getValue();
            Object thisValue = this.attributes.get(otherKey);
            if ((otherValue != null || thisValue == null) && (otherValue == null || otherValue.equals(thisValue))) continue;
            return false;
        }
        return (this.children == null && other.children == null || this.children != null && this.children.equals(other.children)) && (this.getId() == null && other.getId() == null || this.getId() != null && this.getId().equals(other.getId())) && this.isTextOnly == other.isTextOnly && (this.location == null && other.location == null || this.location != null && this.location.equals(other.location)) && (this.nodeName == null && other.nodeName == null || this.nodeName != null && this.nodeName.equals(other.nodeName)) && this.operations.equals(other.operations) && this.sequenceId == other.sequenceId;
    }

    void setParent(ConfigElement configElement) {
        this.parent = configElement;
    }

    public ConfigElement getParent() {
        return this.parent;
    }

    public List<ConfigElement> getChildren() {
        return this.children;
    }

    public String getDisplayId() {
        StringBuffer displayId = new StringBuffer();
        if (this.getParent() != null) {
            displayId.append(this.getParent().getDisplayId());
            displayId.append('/');
        }
        displayId.append(this.getNodeDisplayName());
        if (this.getId() != null) {
            displayId.append('[');
            displayId.append(this.getId());
            displayId.append(']');
        }
        return displayId.toString();
    }

    protected String getNodeDisplayName() {
        return this.nodeName;
    }

    protected void merge(List<? extends ConfigElement> elements) {
        int i;
        if (elements.size() > 1) {
            Collections.sort(elements, ConfigElementComparator.INSTANCE);
        }
        ConfigElement[] elementArray = elements.toArray(new ConfigElement[elements.size()]);
        LinkedList<ConfigElement> flattened = new LinkedList<ConfigElement>();
        flattened.add(elementArray[elements.size() - 1]);
        for (i = elements.size() - 1; i > 0; --i) {
            SimpleElement element = new SimpleElement(elementArray[i - 1]);
            ConfigElement previous = (ConfigElement)flattened.getLast();
            if (((ConfigElement)element).getDocumentLocation().equals(previous.getDocumentLocation())) {
                element.override(previous);
                flattened.removeLast();
                flattened.add(element);
                continue;
            }
            if (previous.getParentDocumentLocation() != null && previous.getParentDocumentLocation().equals(((ConfigElement)element).getDocumentLocation())) {
                element.override(previous);
                flattened.removeLast();
                flattened.add(element);
                continue;
            }
            if (previous.docLocationStack.contains(((ConfigElement)element).getDocumentLocation())) {
                int idx = previous.docLocationStack.indexOf(((ConfigElement)element).getDocumentLocation());
                previous.mergeBehavior = previous.behaviorStack.get(idx + 1);
                element.override(previous);
                flattened.removeLast();
                flattened.add(element);
                continue;
            }
            flattened.add(element);
        }
        for (i = flattened.size(); i > 0; --i) {
            this.override((ConfigElement)flattened.get(i - 1));
        }
    }

    protected void setMergeBehavior(XMLConfigParser.MergeBehavior mb) {
        this.mergeBehavior = mb;
    }

    private Object getParentDocumentLocation() {
        if (this.docLocationStack.size() == 1) {
            return null;
        }
        return this.docLocationStack.get(this.docLocationStack.size() - 2);
    }

    public void setBehaviorStack(LinkedList<XMLConfigParser.MergeBehavior> clone) {
        this.behaviorStack = clone;
    }

    public void setDocLocationStack(LinkedList<String> clone) {
        this.docLocationStack = clone;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(this.getClass().getName());
        builder.append("[").append(this.getFullId()).append("]");
        return builder.toString();
    }

    @Trivial
    public static class ConfigElementComparator
    implements Comparator<ConfigElement> {
        public static final ConfigElementComparator INSTANCE = new ConfigElementComparator();

        @Override
        public int compare(ConfigElement object1, ConfigElement object2) {
            return object1.getSequenceId() - object2.getSequenceId();
        }
    }

    @Trivial
    public static class Reference
    extends ConfigID {
        private static final long serialVersionUID = 6931519568553134827L;

        public Reference(String pid, String id) {
            super(pid, id);
        }
    }

    @Trivial
    static class GroupHashMap
    extends TreeMap<String, Object> {
        private static final long serialVersionUID = 3632130989008067578L;

        public GroupHashMap() {
            super(CASE_INSENSITIVE);
        }

        public GroupHashMap(GroupHashMap map) {
            super(CASE_INSENSITIVE);
            for (Map.Entry entry : map.entrySet()) {
                Object value = entry.getValue();
                if (value instanceof List) {
                    List values = (List)value;
                    value = new ArrayList(values);
                }
                this.put(entry.getKey(), value);
            }
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    public static final class MERGE_OP
    extends Enum<MERGE_OP> {
        public static final /* enum */ MERGE_OP APPEND;
        public static final /* enum */ MERGE_OP SET;
        private static final /* synthetic */ MERGE_OP[] $VALUES;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public static MERGE_OP[] values() {
            return (MERGE_OP[])$VALUES.clone();
        }

        public static MERGE_OP valueOf(String name) {
            return Enum.valueOf(MERGE_OP.class, name);
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(MERGE_OP.class);
            APPEND = new MERGE_OP();
            SET = new MERGE_OP();
            $VALUES = new MERGE_OP[]{APPEND, SET};
        }
    }
}

