/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.config.xml.internal.schema;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.config.xml.internal.schema.DesignateSpecification;
import com.ibm.ws.config.xml.internal.schema.ObjectClassDefinitionSpecification;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Vector;
import org.osgi.framework.Bundle;
import org.osgi.service.metatype.MetaTypeInformation;
import org.osgi.service.metatype.ObjectClassDefinition;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class MetaTypeInformationSpecification
implements MetaTypeInformation {
    public static final ResourceBundle messages;
    private final Map<String, ObjectClassDefinitionSpecification> objectClassMap = new HashMap<String, ObjectClassDefinitionSpecification>();
    private final Map<String, DesignateSpecification> designateMap = new HashMap<String, DesignateSpecification>();
    private final Bundle bundle;
    static final long serialVersionUID = 4082593139463428266L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public MetaTypeInformationSpecification(Bundle bundle) {
        this.bundle = bundle;
    }

    public void addObjectClassSpecification(ObjectClassDefinitionSpecification ocd) {
        if (this.objectClassMap.containsKey(ocd.getID())) {
            throw new IllegalArgumentException(MessageFormat.format(messages.getString("error.ocdExists"), ocd.getID()));
        }
        this.objectClassMap.put(ocd.getID(), ocd);
    }

    public ObjectClassDefinitionSpecification getObjectClassSpecification(String id) {
        return this.objectClassMap.get(id);
    }

    public Collection<ObjectClassDefinitionSpecification> getObjectClassSpecifications() {
        return this.objectClassMap.values();
    }

    public void addDesignateSpecification(DesignateSpecification designate) {
        if (this.designateMap.containsKey(designate.getPid())) {
            throw new IllegalArgumentException(MessageFormat.format(messages.getString("error.dsExists"), designate.getPid()));
        }
        this.designateMap.put(designate.getPid(), designate);
    }

    public Collection<DesignateSpecification> getDesignateSpecifications() {
        return this.designateMap.values();
    }

    public boolean hasFactoryReference(String ocsId) {
        for (DesignateSpecification designate : this.designateMap.values()) {
            if (!designate.isFactory() || !ocsId.equals(designate.getOcdId())) continue;
            return true;
        }
        return false;
    }

    public ObjectClassDefinition getObjectClassDefinition(String pid, String locale) {
        ObjectClassDefinitionSpecification ocd = null;
        DesignateSpecification designate = this.designateMap.get(pid);
        if (designate != null) {
            ocd = this.objectClassMap.get(designate.getOcdId());
        }
        return ocd;
    }

    public String[] getLocales() {
        return null;
    }

    public String[] getPids() {
        if (this.designateMap.size() == 0) {
            return new String[0];
        }
        Vector<String> pids = new Vector<String>();
        for (Map.Entry<String, DesignateSpecification> entry : this.designateMap.entrySet()) {
            DesignateSpecification ds = entry.getValue();
            if (ds.isFactory()) continue;
            pids.add(ds.getPid());
        }
        String[] retVal = new String[pids.size()];
        pids.toArray(retVal);
        return retVal;
    }

    public String[] getFactoryPids() {
        if (this.designateMap.size() == 0) {
            return new String[0];
        }
        Vector<String> pids = new Vector<String>();
        for (Map.Entry<String, DesignateSpecification> entry : this.designateMap.entrySet()) {
            DesignateSpecification ds = entry.getValue();
            if (!ds.isFactory()) continue;
            pids.add(ds.getPid());
        }
        String[] retVal = new String[pids.size()];
        pids.toArray(retVal);
        return retVal;
    }

    public Bundle getBundle() {
        return this.bundle;
    }

    public void validate() {
        Iterator<DesignateSpecification> iterator = this.designateMap.values().iterator();
        while (iterator.hasNext()) {
            DesignateSpecification designate = iterator.next();
            ObjectClassDefinitionSpecification ocd = this.objectClassMap.get(designate.getOcdId());
            if (ocd != null) continue;
            System.out.println(MessageFormat.format(messages.getString("error.invalidOCDRef"), designate.getPid(), designate.getOcdId()));
            iterator.remove();
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(MetaTypeInformationSpecification.class);
        messages = ResourceBundle.getBundle("com.ibm.ws.config.internal.resources.ConfigMessages");
    }
}

