/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.jaas.common.callback;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.security.auth.callback.WSAuthMechOidCallbackImpl;
import com.ibm.websphere.security.auth.callback.WSCredTokenCallbackImpl;
import com.ibm.websphere.security.auth.callback.WSRealmNameCallbackImpl;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.authentication.AuthenticationData;
import com.ibm.ws.security.authentication.WSAuthenticationData;
import com.ibm.wsspi.security.auth.callback.WSAppContextCallback;
import com.ibm.wsspi.security.auth.callback.WSServletRequestCallback;
import com.ibm.wsspi.security.auth.callback.WSServletResponseCallback;
import com.ibm.wsspi.security.auth.callback.WSX509CertificateChainCallback;
import java.io.IOException;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class CallbackHandlerAuthenticationData {
    private static final TraceComponent tc = Tr.register(CallbackHandlerAuthenticationData.class);
    private final CallbackHandler callbackHandler;
    static final long serialVersionUID = -9189345991074011587L;

    public CallbackHandlerAuthenticationData(CallbackHandler callbackHandler) {
        this.callbackHandler = callbackHandler;
    }

    public AuthenticationData createAuthenticationData() throws IOException, UnsupportedCallbackException {
        WSAuthenticationData authenticationData = new WSAuthenticationData();
        Callback[] callbacks = this.getAllSupportedCallbacks(this.callbackHandler);
        for (int i = 0; i < callbacks.length; ++i) {
            if (callbacks[i] instanceof NameCallback) {
                NameCallback nameCallback = (NameCallback)callbacks[i];
                authenticationData.set("USERNAME", (Object)nameCallback.getName());
                continue;
            }
            if (callbacks[i] instanceof PasswordCallback) {
                PasswordCallback passwordCallback = (PasswordCallback)callbacks[i];
                authenticationData.set("PASSWORD", (Object)passwordCallback.getPassword());
                continue;
            }
            if (callbacks[i] instanceof WSServletRequestCallback) {
                WSServletRequestCallback wsServletRequestCallback = (WSServletRequestCallback)callbacks[i];
                authenticationData.set("HTTP_SERVLET_REQUEST", (Object)wsServletRequestCallback.getHttpServletRequest());
                continue;
            }
            if (callbacks[i] instanceof WSServletResponseCallback) {
                WSServletResponseCallback wsServletResponseCallback = (WSServletResponseCallback)callbacks[i];
                authenticationData.set("HTTP_SERVLET_RESPONSE", (Object)wsServletResponseCallback.getHttpServletResponse());
                continue;
            }
            if (callbacks[i] instanceof WSAppContextCallback) {
                WSAppContextCallback wsAppContextCallback = (WSAppContextCallback)callbacks[i];
                authenticationData.set("APPLICATION_CONTEXT", (Object)wsAppContextCallback.getContext());
                continue;
            }
            if (callbacks[i] instanceof WSRealmNameCallbackImpl) {
                WSRealmNameCallbackImpl wsRealmNameCallback = (WSRealmNameCallbackImpl)callbacks[i];
                authenticationData.set("REALM", (Object)wsRealmNameCallback.getRealmName());
                continue;
            }
            if (callbacks[i] instanceof WSX509CertificateChainCallback) {
                WSX509CertificateChainCallback wsX509CertificateCallback = (WSX509CertificateChainCallback)callbacks[i];
                authenticationData.set("CERTCHAIN", (Object)wsX509CertificateCallback.getX509CertificateChain());
                continue;
            }
            if (callbacks[i] instanceof WSCredTokenCallbackImpl) {
                WSCredTokenCallbackImpl wsCredTokenCallbackImpl = (WSCredTokenCallbackImpl)callbacks[i];
                authenticationData.set("TOKEN", (Object)wsCredTokenCallbackImpl.getCredToken());
                continue;
            }
            if (callbacks[i] instanceof WSAuthMechOidCallbackImpl) {
                WSAuthMechOidCallbackImpl wsAuthMechOidCallback = (WSAuthMechOidCallbackImpl)callbacks[i];
                authenticationData.set(AuthenticationData.AUTHENTICATION_MECH_OID, (Object)wsAuthMechOidCallback.getAuthMechOid());
                continue;
            }
            if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
            Tr.debug((TraceComponent)tc, (String)("The following callback was ignored: " + callbacks[i].getClass().getName()), (Object[])new Object[0]);
        }
        return authenticationData;
    }

    Callback[] getAllSupportedCallbacks(CallbackHandler callbackHandler) throws IOException, UnsupportedCallbackException {
        Callback[] callbacks = new Callback[]{new NameCallback("Username: "), new PasswordCallback("Password: ", false), new WSServletRequestCallback("HttpServletRequest: "), new WSServletResponseCallback("HttpServletResponse: "), new WSAppContextCallback("ApplicationContextCallback: "), new WSRealmNameCallbackImpl("Realm Name:"), new WSX509CertificateChainCallback("X509Certificate[]: "), new WSCredTokenCallbackImpl("Credential Token: "), new WSAuthMechOidCallbackImpl("AuthMechOid: ")};
        callbackHandler.handle(callbacks);
        return callbacks;
    }
}

