/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.jaas.common.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class JAASSecurityConfiguration
extends Configuration {
    private static final TraceComponent tc = Tr.register(JAASSecurityConfiguration.class);
    private final Map<String, List<AppConfigurationEntry>> instancesAppConfigurationEntries = new HashMap<String, List<AppConfigurationEntry>>();
    private final ReentrantReadWriteLock reentrantReadWriteLock = new ReentrantReadWriteLock();
    private final ReentrantReadWriteLock.WriteLock writeLock = this.reentrantReadWriteLock.writeLock();
    private final ReentrantReadWriteLock.ReadLock readLock = this.reentrantReadWriteLock.readLock();
    static final long serialVersionUID = 1355883277079210748L;

    public void setAppConfigurationEntries(Map<String, List<AppConfigurationEntry>> configurationEntries) {
        this.writeLock.lock();
        try {
            this.instancesAppConfigurationEntries.putAll(configurationEntries);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("appConfigurationEntries: " + this.instancesAppConfigurationEntries.toString()), (Object[])new Object[0]);
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public AppConfigurationEntry[] getAppConfigurationEntry(String jaasEntryName) {
        List<AppConfigurationEntry> appConfigurationEntry = this.getAppConfigurationEntryListFor(jaasEntryName);
        return this.createAppConfigurationEntryArrayFrom(appConfigurationEntry);
    }

    private List<AppConfigurationEntry> getAppConfigurationEntryListFor(String jaasEntryName) {
        List<AppConfigurationEntry> appConfigurationEntry = null;
        this.readLock.lock();
        try {
            appConfigurationEntry = this.instancesAppConfigurationEntries.get(jaasEntryName);
        }
        finally {
            this.readLock.unlock();
        }
        return appConfigurationEntry;
    }

    private AppConfigurationEntry[] createAppConfigurationEntryArrayFrom(List<AppConfigurationEntry> appConfigurationEntry) {
        AppConfigurationEntry[] appConfigurationEntryAsArray = null;
        if (appConfigurationEntry != null) {
            appConfigurationEntryAsArray = new AppConfigurationEntry[appConfigurationEntry.size()];
            appConfigurationEntryAsArray = appConfigurationEntry.toArray(appConfigurationEntryAsArray);
        }
        return appConfigurationEntryAsArray;
    }
}

