/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.threading.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.threading.internal.QueueItem;
import com.ibm.ws.threading.internal.ReduceableSemaphore;
import java.util.AbstractQueue;
import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class DoubleQueue<T>
extends AbstractQueue<T>
implements BlockingQueue<T> {
    private final ConcurrentLinkedQueue<T> q1 = new ConcurrentLinkedQueue();
    private final ConcurrentLinkedQueue<T> q2 = new ConcurrentLinkedQueue();
    private final ReduceableSemaphore size = new ReduceableSemaphore(0, false);
    static final long serialVersionUID = -4173241544728000026L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    @Override
    public boolean contains(Object item) {
        return this.q2.contains(item) || this.q1.contains(item);
    }

    @Override
    public int drainTo(Collection<? super T> col) {
        T item;
        int count = 0;
        while ((item = this.poll()) != null) {
            col.add(item);
            ++count;
        }
        return count;
    }

    @Override
    public int drainTo(Collection<? super T> col, int maxElements) {
        T item;
        int count;
        for (count = 0; count < maxElements && (item = this.poll()) != null; ++count) {
            col.add(item);
        }
        return count;
    }

    @Override
    public boolean isEmpty() {
        return this.size.availablePermits() <= 0;
    }

    @Override
    public Iterator<T> iterator() {
        return new QueueIterator();
    }

    @Override
    public boolean offer(T item) {
        if (item instanceof QueueItem && ((QueueItem)item).isExpedited()) {
            this.q1.offer(item);
        } else {
            this.q2.offer(item);
        }
        this.size.release();
        return true;
    }

    @Override
    public boolean offer(T item, long time, TimeUnit timeout) throws InterruptedException {
        return this.offer(item);
    }

    @Override
    public T peek() {
        T t = this.q1.peek();
        return t == null ? this.q2.peek() : t;
    }

    @Override
    public T poll() {
        while (this.size.tryAcquire()) {
            T t = this.q1.poll();
            T t2 = t = t == null ? this.q2.poll() : t;
            if (t == null) {
                this.size.release();
                Thread.yield();
                continue;
            }
            return t;
        }
        return null;
    }

    @Override
    public T poll(long timeout, TimeUnit unit) throws InterruptedException {
        long start = System.nanoTime();
        long remain = timeout = unit.toNanos(timeout);
        while (remain >= 0L && this.size.tryAcquire(remain, TimeUnit.NANOSECONDS)) {
            T t = this.q1.poll();
            T t2 = t = t == null ? this.q2.poll() : t;
            if (t != null) {
                return t;
            }
            this.size.release();
            Thread.yield();
            remain = timeout - (System.nanoTime() - start);
        }
        return null;
    }

    @Override
    public void put(T item) throws InterruptedException {
        this.offer(item);
    }

    @Override
    public int remainingCapacity() {
        return Integer.MAX_VALUE;
    }

    @Override
    public boolean remove(Object item) {
        if (this.q1.remove(item) || this.q2.remove(item)) {
            this.size.reducePermits(1);
            return true;
        }
        return false;
    }

    @Override
    public boolean removeAll(Collection<?> items) {
        boolean modified = false;
        for (Object item : items) {
            while (this.q1.remove(item)) {
                this.size.reducePermits(1);
                modified = true;
            }
            while (this.q2.remove(item)) {
                this.size.reducePermits(1);
                modified = true;
            }
        }
        return modified;
    }

    @Override
    public boolean retainAll(Collection<?> items) {
        boolean modified = false;
        for (T t : this.q1) {
            if (items.contains(t)) continue;
            while (this.q1.remove(t)) {
                this.size.reducePermits(1);
                modified = true;
            }
        }
        for (T t : this.q2) {
            if (items.contains(t)) continue;
            while (this.q2.remove(t)) {
                this.size.reducePermits(1);
                modified = true;
            }
        }
        return modified;
    }

    @Override
    public final int size() {
        int s = this.size.availablePermits();
        return s < 0 ? 0 : s;
    }

    @Override
    public T take() throws InterruptedException {
        T t;
        while (true) {
            this.size.acquire();
            t = this.q1.poll();
            T t2 = t = t == null ? this.q2.poll() : t;
            if (t != null) break;
            this.size.release();
            Thread.yield();
        }
        return t;
    }

    @Override
    public String toString() {
        int s = this.size.availablePermits();
        StringBuilder b = new StringBuilder().append(this.size.availablePermits());
        if (s < 100) {
            b.append(' ').append(this.q1).append(' ').append(this.q2);
        } else {
            b.append(' ').append(this.q1.size()).append(' ').append(this.q2.size());
        }
        return b.toString();
    }

    static /* synthetic */ ConcurrentLinkedQueue access$100(DoubleQueue x0) {
        return x0.q1;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(DoubleQueue.class);
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    private class QueueIterator
    implements Iterator<T> {
        private boolean is1 = true;
        private Iterator<T> it = DoubleQueue.access$100(DoubleQueue.this).iterator();
        private boolean skipCheck;
        static final long serialVersionUID = -3553292398671296684L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        private QueueIterator() {
        }

        @Override
        public boolean hasNext() {
            if (this.is1) {
                if (this.it.hasNext()) {
                    this.skipCheck = true;
                    return true;
                }
                this.it = DoubleQueue.this.q2.iterator();
                this.is1 = false;
            }
            return this.it.hasNext();
        }

        @Override
        public T next() {
            if (this.is1 && !this.skipCheck && !this.it.hasNext()) {
                this.it = DoubleQueue.this.q2.iterator();
                this.is1 = false;
            }
            this.skipCheck = false;
            return this.it.next();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(QueueIterator.class);
        }
    }
}

