/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.threading.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.kernel.service.util.CpuInfo;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.threading.internal.BoundedBuffer;
import com.ibm.ws.threading.internal.QueueItem;
import com.ibm.ws.threading.internal.ThreadFactoryImpl;
import com.ibm.ws.threading.internal.ThreadPoolController;
import com.ibm.wsspi.threading.ExecutorServiceTaskInterceptor;
import com.ibm.wsspi.threading.WSExecutorService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@Component(name="com.ibm.ws.threading", configurationPolicy=ConfigurationPolicy.REQUIRE, property={"service.vendor=IBM"}, service={ExecutorService.class, WSExecutorService.class})
public final class ExecutorServiceImpl
implements WSExecutorService {
    ThreadPoolExecutor threadPool = null;
    ThreadPoolController threadPoolController = null;
    String poolName = null;
    Map<String, Object> componentConfig = null;
    boolean interceptorsActive = false;
    Set<ExecutorServiceTaskInterceptor> interceptors = new CopyOnWriteArraySet<ExecutorServiceTaskInterceptor>();
    ThreadFactory threadFactory = null;
    static final long serialVersionUID = -5569391535960693817L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    protected synchronized void setInterceptor(ExecutorServiceTaskInterceptor interceptor) {
        this.interceptors.add(interceptor);
        this.interceptorsActive = true;
    }

    protected synchronized void unsetInterceptor(ExecutorServiceTaskInterceptor interceptor) {
        this.interceptors.remove(interceptor);
        if (this.interceptors.size() == 0) {
            this.interceptorsActive = false;
        }
    }

    @Reference(cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC, target="(com.ibm.ws.threading.defaultExecutorThreadFactory=true)")
    protected void setThreadFactory(ThreadFactory threadFactory) {
        this.threadFactory = threadFactory;
        this.createExecutor();
    }

    protected void unsetThreadFactory(ThreadFactory threadFactory) {
        if (this.threadFactory == threadFactory) {
            threadFactory = null;
            this.createExecutor();
        }
    }

    @Activate
    protected void activate(Map<String, Object> componentConfig) {
        this.componentConfig = componentConfig;
        this.createExecutor();
    }

    @Modified
    protected void modified(Map<String, Object> componentConfig) {
        this.componentConfig = componentConfig;
        this.createExecutor();
    }

    @Deactivate
    protected void deactivate(int reason) {
        this.threadPoolController.deactivate();
        this.softShutdown(this.threadPool);
        this.componentConfig = null;
    }

    @Trivial
    ThreadPoolExecutor getThreadPool() {
        return this.threadPool;
    }

    private synchronized void createExecutor() {
        if (this.componentConfig == null) {
            return;
        }
        if (this.threadPoolController != null) {
            this.threadPoolController.deactivate();
        }
        ThreadPoolExecutor oldPool = this.threadPool;
        this.poolName = (String)this.componentConfig.get("name");
        String threadGroupName = this.poolName + " Thread Group";
        int coreThreads = Integer.parseInt(String.valueOf(this.componentConfig.get("coreThreads")));
        int maxThreads = Integer.parseInt(String.valueOf(this.componentConfig.get("maxThreads")));
        long keepAliveMillis = Long.parseLong(String.valueOf(this.componentConfig.get("keepAlive")));
        if (maxThreads <= 0) {
            maxThreads = Integer.MAX_VALUE;
        }
        if (coreThreads < 0) {
            coreThreads = 2 * CpuInfo.getAvailableProcessors();
        }
        coreThreads = Math.min(coreThreads, maxThreads);
        BoundedBuffer<Runnable> workQueue = new BoundedBuffer<Runnable>(Runnable.class, 1000, 1000);
        ExpandPolicy rejectedExecutionHandler = new ExpandPolicy(workQueue, this);
        this.threadPool = new ThreadPoolExecutor(coreThreads, maxThreads, keepAliveMillis, TimeUnit.MILLISECONDS, workQueue, this.threadFactory != null ? this.threadFactory : new ThreadFactoryImpl(this.poolName, threadGroupName), rejectedExecutionHandler);
        this.threadPoolController = new ThreadPoolController(this, this.threadPool);
        if (oldPool != null) {
            this.softShutdown(oldPool);
        }
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        this.threadPoolController.resumeIfPaused();
        return this.threadPool.awaitTermination(timeout, unit);
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) throws InterruptedException {
        this.threadPoolController.resumeIfPaused();
        return this.threadPool.invokeAll(this.interceptorsActive ? this.wrap(tasks) : tasks);
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException {
        this.threadPoolController.resumeIfPaused();
        return this.threadPool.invokeAll(this.interceptorsActive ? this.wrap(tasks) : tasks, timeout, unit);
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks) throws InterruptedException, ExecutionException {
        this.threadPoolController.resumeIfPaused();
        return this.threadPool.invokeAny(this.interceptorsActive ? this.wrap(tasks) : tasks);
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        this.threadPoolController.resumeIfPaused();
        return this.threadPool.invokeAny(this.interceptorsActive ? this.wrap(tasks) : tasks, timeout, unit);
    }

    @Override
    public boolean isShutdown() {
        return this.threadPool.isShutdown();
    }

    @Override
    public boolean isTerminated() {
        return this.threadPool.isTerminated();
    }

    @Override
    public void shutdown() {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<Runnable> shutdownNow() {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> Future<T> submit(Callable<T> task) {
        this.threadPoolController.resumeIfPaused();
        return this.threadPool.submit(this.interceptorsActive ? this.wrap(task) : task);
    }

    @Override
    public Future<?> submit(Runnable task) {
        this.threadPoolController.resumeIfPaused();
        return this.threadPool.submit(this.interceptorsActive ? this.wrap(task) : task);
    }

    @Override
    public <T> Future<T> submit(Runnable task, T result) {
        this.threadPoolController.resumeIfPaused();
        return this.threadPool.submit(this.interceptorsActive ? this.wrap(task) : task, result);
    }

    @Override
    public void execute(Runnable command) {
        this.threadPoolController.resumeIfPaused();
        this.threadPool.execute(this.interceptorsActive ? this.wrap(command) : command);
    }

    @Override
    public void executeGlobal(Runnable command) {
        this.threadPoolController.resumeIfPaused();
        this.threadPool.execute(this.interceptorsActive ? this.wrap(command) : command);
    }

    void executeWithoutInterceptors(Runnable proxy) {
        this.threadPoolController.resumeIfPaused();
        this.threadPool.execute(proxy);
    }

    @Trivial
    public int getPoolSize() {
        return this.threadPool.getPoolSize();
    }

    @Trivial
    public int getActiveCount() {
        return this.threadPool.getActiveCount();
    }

    @Trivial
    public String getPoolName() {
        return this.poolName;
    }

    private void softShutdown(ThreadPoolExecutor oldThreadPool) {
        oldThreadPool.setKeepAliveTime(0L, TimeUnit.SECONDS);
        oldThreadPool.setCorePoolSize(0);
    }

    Runnable wrap(Runnable r) {
        Iterator<ExecutorServiceTaskInterceptor> i = this.interceptors.iterator();
        while (i.hasNext()) {
            r = i.next().wrap(r);
        }
        return r;
    }

    <T> Callable<T> wrap(Callable<T> c) {
        Iterator<ExecutorServiceTaskInterceptor> i = this.interceptors.iterator();
        while (i.hasNext()) {
            c = i.next().wrap(c);
        }
        return c;
    }

    private <T> Collection<? extends Callable<T>> wrap(Collection<? extends Callable<T>> tasks) {
        ArrayList<Callable<T>> wrappedTasks = new ArrayList<Callable<T>>();
        Iterator<Callable<T>> i = tasks.iterator();
        while (i.hasNext()) {
            wrappedTasks.add(this.wrap(i.next()));
        }
        return wrappedTasks;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(ExecutorServiceImpl.class);
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    public static class ExpandPolicy
    implements RejectedExecutionHandler {
        public BoundedBuffer<Runnable> workQueue;
        public WSExecutorService exService;
        static final long serialVersionUID = 7311458178434520568L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public ExpandPolicy(BlockingQueue<Runnable> workQueue2, WSExecutorService exService) {
            this.workQueue = (BoundedBuffer)workQueue2;
            this.exService = exService;
        }

        @Override
        public void rejectedExecution(Runnable r, ThreadPoolExecutor e) {
            if (e.isShutdown()) {
                throw new RejectedExecutionException("Task " + r.toString() + " rejected from " + e.toString());
            }
            if (r instanceof QueueItem && ((QueueItem)((Object)r)).isExpedited()) {
                this.workQueue.expandExpedited(1000);
            } else {
                this.workQueue.expand(1000);
            }
            this.exService.execute(r);
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(ExpandPolicy.class);
        }
    }
}

