/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.message;

import java.util.logging.Logger;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.FaultMode;
import org.apache.cxf.message.Message;
import org.w3c.dom.Node;

public final class MessageUtils {
    private static final Logger LOG = LogUtils.getL7dLogger(MessageUtils.class);

    private MessageUtils() {
    }

    public static int getContextualInteger(Message m, String key, int defaultValue) {
        Object o;
        if (m != null && (o = m.getContextualProperty(key)) instanceof String) {
            try {
                int i = Integer.parseInt((String)o);
                if (i > 0) {
                    return i;
                }
            }
            catch (NumberFormatException ex) {
                LOG.warning("Incorrect integer value of " + o + " specified for: " + key);
            }
        }
        return defaultValue;
    }

    public static boolean isOutbound(Message message) {
        Exchange exchange = message.getExchange();
        return exchange != null && (message == exchange.getOutMessage() || message == exchange.getOutFaultMessage());
    }

    public static boolean isFault(Message message) {
        return message != null && message.getExchange() != null && (message == message.getExchange().getInFaultMessage() || message == message.getExchange().getOutFaultMessage());
    }

    public static FaultMode getFaultMode(Message message) {
        if (message != null && message.getExchange() != null && message == message.getExchange().getOutFaultMessage()) {
            FaultMode mode = message.get(FaultMode.class);
            if (null != mode) {
                return mode;
            }
            return FaultMode.RUNTIME_FAULT;
        }
        return null;
    }

    public static boolean isRequestor(Message message) {
        Boolean requestor = (Boolean)message.get("org.apache.cxf.client");
        return requestor != null && requestor != false;
    }

    public static boolean isPartialResponse(Message message) {
        return Boolean.TRUE.equals(message.get("org.apache.cxf.partial.response"));
    }

    public static boolean isEmptyPartialResponse(Message message) {
        return Boolean.TRUE.equals(message.get("org.apache.cxf.partial.response.empty"));
    }

    public static boolean isTrue(Object value) {
        if (value == null) {
            return false;
        }
        return Boolean.TRUE.equals(value) || "true".equalsIgnoreCase(value.toString());
    }

    public static boolean getContextualBoolean(Message m, String key, boolean defaultValue) {
        Object o = m.getContextualProperty(key);
        if (o != null) {
            return MessageUtils.isTrue(o);
        }
        return defaultValue;
    }

    public static boolean isDOMPresent(Message m) {
        return m.getContent(Node.class) != null;
    }
}

