/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ras.instrument.internal.bci;

import com.ibm.websphere.ras.annotation.Sensitive;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.ras.instrument.internal.bci.CheckInstrumentableClassAdapter;
import com.ibm.ws.ras.instrument.internal.bci.RasClassAdapter;
import com.ibm.ws.ras.instrument.internal.bci.RasMethodAdapter;
import com.ibm.ws.ras.instrument.internal.introspect.TraceObjectFieldAnnotationVisitor;
import com.ibm.ws.ras.instrument.internal.introspect.TraceOptionsAnnotationVisitor;
import com.ibm.ws.ras.instrument.internal.model.ClassInfo;
import com.ibm.ws.ras.instrument.internal.model.TraceOptionsData;
import java.util.HashSet;
import java.util.Set;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.Method;

public abstract class AbstractRasClassAdapter
extends CheckInstrumentableClassAdapter
implements RasClassAdapter {
    public static final Type SENSITIVE_TYPE = Type.getType(Sensitive.class);
    public static final Type TRACE_OBJECT_FIELD_TYPE = Type.getType(TraceObjectField.class);
    public static final Type TRACE_OPTIONS_TYPE = Type.getType(TraceOptions.class);
    public static final Type TRIVIAL_TYPE = Type.getType(Trivial.class);
    protected Type classType;
    protected boolean isInterface;
    protected boolean isSynthetic;
    protected boolean isInnerClass;
    protected int classVersion;
    protected final ClassInfo classInfo;
    private final Set<Method> visitedMethods = new HashSet<Method>();
    private final Set<Type> observedAnnotations = new HashSet<Type>();
    private TraceOptionsAnnotationVisitor optionsAnnotationVisitor;
    private TraceObjectFieldAnnotationVisitor traceObjectFieldAnnotationVisitor;
    private boolean staticInitializerGenerated = false;

    public AbstractRasClassAdapter(ClassVisitor visitor) {
        this(visitor, null);
    }

    public AbstractRasClassAdapter(ClassVisitor visitor, ClassInfo classInfo) {
        super(visitor);
        this.classInfo = classInfo;
    }

    @Override
    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        this.classVersion = version;
        this.classType = Type.getObjectType((String)name);
        this.isInterface = (access & 0x200) != 0;
        this.isSynthetic = (access & 0x1000) != 0;
        super.visit(version, access, name, signature, superName, interfaces);
    }

    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        AnnotationVisitor av = super.visitAnnotation(desc, visible);
        this.observedAnnotations.add(Type.getType((String)desc));
        if (this.classInfo == null && TRACE_OPTIONS_TYPE.getDescriptor().equals(desc)) {
            this.optionsAnnotationVisitor = new TraceOptionsAnnotationVisitor(av);
            av = this.optionsAnnotationVisitor;
        }
        if (TRACE_OBJECT_FIELD_TYPE.getDescriptor().equals(desc)) {
            this.traceObjectFieldAnnotationVisitor = new TraceObjectFieldAnnotationVisitor(av);
            av = this.traceObjectFieldAnnotationVisitor;
        }
        return av;
    }

    public void visitInnerClass(String name, String outerName, String innerName, int access) {
        this.ensureAnnotated();
        if (name.equals(this.getClassInternalName())) {
            StringBuilder sb = new StringBuilder();
            sb.append(outerName);
            sb.append("$");
            sb.append(innerName);
            this.isInnerClass = name.equals(sb.toString());
        }
        super.visitInnerClass(name, outerName, innerName, access);
    }

    public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
        this.ensureAnnotated();
        return super.visitField(access, name, desc, signature, value);
    }

    protected void ensureAnnotated() {
        this.ensureTraceObjectFieldAnnotated();
    }

    protected void ensureTraceObjectFieldAnnotated() {
        if (this.traceObjectFieldAnnotationVisitor == null && this.getTraceObjectFieldType() != null) {
            this.visitAnnotation(TRACE_OBJECT_FIELD_TYPE.getDescriptor(), true);
            TraceObjectFieldAnnotationVisitor av = this.traceObjectFieldAnnotationVisitor;
            this.traceObjectFieldAnnotationVisitor = null;
            av.visit("fieldName", this.getTraceObjectFieldName());
            av.visit("fieldDesc", this.getTraceObjectFieldType().getDescriptor());
            av.visitEnd();
            this.traceObjectFieldAnnotationVisitor = av;
        }
    }

    public MethodVisitor visitMethod(int access, String name, String descriptor, String signature, String[] exceptions) {
        this.visitedMethods.add(new Method(name, descriptor));
        this.ensureAnnotated();
        MethodVisitor mv = super.visitMethod(access, name, descriptor, signature, exceptions);
        if (this.isInstrumentableClass() && this.isInstrumentableMethod(access, name, descriptor)) {
            RasMethodAdapter rasMethodAdapter = this.createRasMethodAdapter(mv, access, name, descriptor, signature, exceptions);
            mv = rasMethodAdapter != null ? rasMethodAdapter : mv;
        }
        return mv;
    }

    public void visitEnd() {
        if (this.isInstrumentableClass()) {
            if (this.isTraceObjectFieldDefinitionRequired()) {
                int access = 4122;
                String name = this.getTraceObjectFieldName();
                String desc = this.getTraceObjectFieldType().getDescriptor();
                this.visitField(access, name, desc, null, null);
            }
            if (this.isStaticInitializerRequired() && !this.isStaticInitDefined()) {
                this.staticInitializerGenerated = true;
                MethodVisitor mv = this.visitMethod(8, "<clinit>", "()V", null, null);
                Label lineNumberLabel = new Label();
                mv.visitCode();
                mv.visitLabel(lineNumberLabel);
                mv.visitLineNumber(65535, lineNumberLabel);
                mv.visitInsn(177);
                mv.visitMaxs(1, 0);
                mv.visitEnd();
            }
        }
        super.visitEnd();
    }

    public ClassInfo getClassInfo() {
        return this.classInfo;
    }

    @Override
    public boolean isInstrumentableClass() {
        if (this.isTrivial()) {
            return false;
        }
        return super.isInstrumentableClass();
    }

    protected boolean isStaticInitializerRequired() {
        return true;
    }

    protected boolean isInjectedTraceAnnotationRequired() {
        return true;
    }

    public Type getClassType() {
        return this.classType;
    }

    public String getClassInternalName() {
        return this.classType.getInternalName();
    }

    public String getClassName() {
        return this.classType.getClassName();
    }

    public int getClassVersion() {
        return this.classVersion;
    }

    public boolean isInterface() {
        return this.isInterface;
    }

    public boolean isSynthetic() {
        return this.isSynthetic;
    }

    public boolean isInnerClass() {
        return this.isInnerClass;
    }

    public boolean isStaticInitDefined() {
        if (this.classInfo != null) {
            return this.classInfo.getDeclaredMethod("<clinit>", "()V") != null;
        }
        return this.visitedMethods.contains(new Method("<clinit>", "()V"));
    }

    public boolean isSensitveType() {
        if (this.classInfo != null) {
            return this.classInfo.isSensitive();
        }
        return this.observedAnnotations.contains(SENSITIVE_TYPE);
    }

    public boolean isTrivial() {
        if (this.classInfo != null) {
            return this.classInfo.isTrivial();
        }
        return this.observedAnnotations.contains(TRIVIAL_TYPE);
    }

    public TraceOptionsData getTraceOptionsData() {
        if (this.classInfo != null) {
            return this.classInfo.getTraceOptionsData();
        }
        if (this.optionsAnnotationVisitor != null) {
            return this.optionsAnnotationVisitor.getTraceOptionsData();
        }
        return null;
    }

    protected boolean isStaticInitializerGenerated() {
        return this.staticInitializerGenerated;
    }

    protected String getTraceObjectAnnotationFieldName() {
        if (this.traceObjectFieldAnnotationVisitor != null) {
            return this.traceObjectFieldAnnotationVisitor.getFieldName();
        }
        return null;
    }

    protected Type getTraceObjectAnnotationFieldType() {
        if (this.traceObjectFieldAnnotationVisitor != null) {
            return Type.getType((String)this.traceObjectFieldAnnotationVisitor.getFieldDescriptor());
        }
        return null;
    }
}

