/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.j2ee.mbeans;

import com.ibm.websphere.management.j2ee.J2EEManagementObjectNameFactory;
import com.ibm.websphere.management.j2ee.JVMMBean;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import javax.management.ObjectName;
import javax.management.StandardMBean;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class JVMMBeanImpl
extends StandardMBean
implements JVMMBean {
    private static final TraceComponent tc = Tr.register(JVMMBeanImpl.class, (String)"management.j2ee.mbeans", (String)"com.ibm.ws.management.j2ee.mbeans.internal.resources.SMMessages");
    private final ObjectName objectName;
    private final String javaVersion;
    private final String javaVendor;
    private final String node;
    static final long serialVersionUID = 9113435086998412337L;

    public JVMMBeanImpl(String serverName) {
        super(JVMMBean.class, false);
        this.objectName = J2EEManagementObjectNameFactory.createJVMObjectName((String)serverName);
        this.javaVersion = this.findJavaVersion();
        this.javaVendor = this.findJavaVendor();
        this.node = this.findNode();
    }

    public String getobjectName() {
        return this.objectName.toString();
    }

    public boolean isstateManageable() {
        return false;
    }

    public boolean isstatisticsProvider() {
        return false;
    }

    public boolean iseventProvider() {
        return false;
    }

    public String getjavaVersion() {
        return this.javaVersion;
    }

    public String getjavaVendor() {
        return this.javaVendor;
    }

    public String getnode() {
        return this.node;
    }

    private static String getProperty(final String prop) {
        if (System.getSecurityManager() == null) {
            return System.getProperty(prop);
        }
        return AccessController.doPrivileged(new PrivilegedAction<String>(){
            static final long serialVersionUID = -5096484998506029363L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public String run() {
                return System.getProperty(prop);
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register(1.class);
            }
        });
    }

    private String findJavaVersion() {
        return JVMMBeanImpl.getProperty("java.version");
    }

    private String findJavaVendor() {
        return JVMMBeanImpl.getProperty("java.vendor");
    }

    private String findNode() {
        return AccessController.doPrivileged(new PrivilegedAction<String>(){
            static final long serialVersionUID = -7071861305780427633L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            @FFDCIgnore(value={UnknownHostException.class})
            public String run() {
                try {
                    return InetAddress.getLocalHost().getCanonicalHostName();
                }
                catch (UnknownHostException e) {
                    Tr.error((TraceComponent)tc, (String)"DETERMINE_HOST_ERROR", (Object[])new Object[]{"localhost", e.getMessage()});
                    return "localhost";
                }
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register(2.class);
            }
        });
    }

    public String toString() {
        return "JVMMBeanImpl : objectName=" + this.objectName + " : javaVersion=" + this.javaVersion + " : javaVendor=" + this.javaVersion + " : node=" + this.node;
    }
}

