/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.j2c;

import com.ibm.ejs.j2c.ConnectionManager;
import com.ibm.ejs.j2c.J2CUtilityClass;
import com.ibm.ejs.j2c.MCWrapper;
import com.ibm.ejs.j2c.PoolManager;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.Transaction.UOWCoordinator;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.j2c.TranWrapper;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionEvent;
import javax.resource.spi.ManagedConnection;

public final class ConnectionEventListener
implements javax.resource.spi.ConnectionEventListener {
    private MCWrapper mcWrapper = null;
    private static final TraceComponent tc = Tr.register(ConnectionEventListener.class, (String)"WAS.j2c", (String)"com.ibm.ws.j2c.resources.J2CAMessages");

    ConnectionEventListener() {
    }

    protected ConnectionEventListener(MCWrapper mcWrapper) {
        this.mcWrapper = mcWrapper;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void connectionClosed(ConnectionEvent event) {
        boolean isTracingEnabled;
        block15: {
            block16: {
                isTracingEnabled = TraceComponent.isAnyTracingEnabled();
                if (isTracingEnabled && tc.isEntryEnabled()) {
                    Tr.entry((Object)this, (TraceComponent)tc, (String)"connectionClosed", (Object[])new Object[0]);
                }
                if (event.getId() != 1) break block16;
                if (!this.mcWrapper.isParkedWrapper()) {
                    ConnectionManager cm;
                    if (isTracingEnabled && tc.isDebugEnabled()) {
                        Tr.debug((Object)this, (TraceComponent)tc, (String)("***Connection Close Request*** Handle Name: " + event.getConnectionHandle() + "  Connection Pool: " + this.mcWrapper.getPoolManager().getGConfigProps().getXpathId() + "  Details: : " + this.mcWrapper), (Object[])new Object[0]);
                    }
                    if ((cm = this.mcWrapper.getConnectionManagerWithoutStateCheck()) != null && cm.handleToThreadMap != null) {
                        cm.handleToThreadMap.clear();
                    }
                    if (cm != null && cm.handleToCMDMap != null) {
                        cm.handleToCMDMap.clear();
                    }
                    if (!this.mcWrapper.gConfigProps.isSmartHandleSupport() || cm == null || !cm.shareable()) {
                        Object conHandle = event.getConnectionHandle();
                        if (null == conHandle) {
                            Tr.warning((TraceComponent)tc, (String)"CONNECTION_CLOSED_NULL_HANDLE_J2CA0148", (Object[])new Object[]{event});
                        } else {
                            this.mcWrapper.removeFromHandleList(conHandle);
                        }
                    }
                    this.mcWrapper.decrementHandleCount();
                    if (this.mcWrapper.getHandleCount() == 0) {
                        if (this.mcWrapper.getTranWrapperId() == 3) {
                            this.mcWrapper.transactionComplete();
                        }
                        if (!this.mcWrapper.involvedInTransaction()) {
                            try {
                                this.mcWrapper.releaseToPoolManager();
                            }
                            catch (Exception ex) {
                                FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ejs.j2c.ConnectionEventListener.connectionClosed", (String)"197", (Object)this);
                                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                    Tr.debug((Object)this, (TraceComponent)tc, (String)("connectionClosed: Closing connection in pool " + this.mcWrapper.gConfigProps.getXpathId() + " caught exception, but will continue processing: "), (Object[])new Object[]{ex});
                                }
                                break block15;
                            }
                        }
                    }
                }
                break block15;
            }
            this.processBadEvent("connectionClosed", 1, event);
        }
        if (isTracingEnabled && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"connectionClosed");
        }
    }

    public void connectionErrorOccurred(ConnectionEvent event) {
        int eventID = event.getId();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            StringBuilder entry = new StringBuilder(event.getClass().getSimpleName()).append('{');
            entry.append("id=").append(event.getId()).append(", ");
            entry.append("source=").append(event.getSource());
            entry.append('}');
            if (event.getException() == null) {
                Tr.entry((Object)this, (TraceComponent)tc, (String)"connectionErrorOccurred", (Object[])new Object[]{entry.toString()});
            } else {
                Tr.entry((Object)this, (TraceComponent)tc, (String)"connectionErrorOccurred", (Object[])new Object[]{entry.toString(), event.getException()});
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            StringBuffer tsb = new StringBuffer();
            Object connHandle = event.getConnectionHandle();
            tsb.append("***Connection Error Request*** Handle Name: " + connHandle);
            if (this.mcWrapper != null) {
                PoolManager poolMgr = this.mcWrapper.getPoolManager();
                tsb.append(", Connection Pool: " + poolMgr + ", Details: " + this.mcWrapper);
            } else {
                tsb.append(", Details: null");
            }
            Tr.debug((Object)this, (TraceComponent)tc, (String)tsb.toString(), (Object[])new Object[0]);
        }
        switch (eventID) {
            case 5: {
                Exception tempEx = event.getException();
                String tempString = "";
                if (tempEx != null) {
                    tempString = J2CUtilityClass.generateExceptionString(tempEx);
                    Tr.audit((TraceComponent)tc, (String)"RA_CONNECTION_ERROR_J2CA0056", (Object[])new Object[]{tempString, this.mcWrapper.gConfigProps.cfName});
                } else {
                    Tr.audit((TraceComponent)tc, (String)"NO_RA_EXCEPTION_J2CA0216", (Object[])new Object[]{this.mcWrapper.gConfigProps.cfName});
                }
                this.mcWrapper.connectionErrorOccurred(event);
                break;
            }
            case 51: {
                Exception tempEx = event.getException();
                String tempString = "";
                if (tempEx != null) {
                    tempString = J2CUtilityClass.generateExceptionString(tempEx);
                    Tr.audit((TraceComponent)tc, (String)"RA_CONNECTION_ERROR_J2CA0056", (Object[])new Object[]{tempString, this.mcWrapper.gConfigProps.cfName});
                } else {
                    Tr.audit((TraceComponent)tc, (String)"NO_RA_EXCEPTION_J2CA0216", (Object[])new Object[]{this.mcWrapper.gConfigProps.cfName});
                }
                this.mcWrapper.connectionErrorOccurred(event);
                break;
            }
            case 52: {
                this.mcWrapper.connectionErrorOccurred(event);
                break;
            }
            default: {
                this.processBadEvent("connectionErrorOccurred", 5, event);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"connectionErrorOccurred");
        }
    }

    public void localTransactionCommitted(ConnectionEvent event) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"localTransactionCommitted", (Object[])new Object[0]);
        }
        if (event.getId() == 3) {
            if (this.mcWrapper.involvedInTransaction()) {
                TranWrapper wrapper = null;
                try {
                    wrapper = this.mcWrapper.getCurrentTranWrapper();
                    wrapper.delist();
                }
                catch (ResourceException e) {
                    FFDCFilter.processException((Throwable)e, (String)"com.ibm.ejs.j2c.ConnectionEventListener.localTransactionCommitted", (String)"316", (Object)"this");
                    Tr.error((TraceComponent)tc, (String)"DELIST_FAILED_J2CA0073", (Object[])new Object[]{"localTransactionCommitted", e, this.mcWrapper.gConfigProps.cfName});
                    ManagedConnection mc = null;
                    try {
                        mc = (ManagedConnection)event.getSource();
                    }
                    catch (ClassCastException cce) {
                        Tr.error((TraceComponent)tc, (String)"GET_SOURCE_CLASS_CAST_EXCP_J2CA0098", (Object[])new Object[]{cce});
                        throw new IllegalStateException("ClassCastException occurred attempting to cast event.getSource to ManagedConnection");
                    }
                    ConnectionEvent errorEvent = new ConnectionEvent(mc, 5);
                    this.connectionErrorOccurred(errorEvent);
                    IllegalStateException rte = new IllegalStateException(e.getMessage());
                    throw rte;
                }
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit((Object)this, (TraceComponent)tc, (String)"localTransactionCommitted", (Object)"no transaction context, return without delisting");
            }
            return;
        }
        this.processBadEvent("localTransactionCommitted", 3, event);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"localTransactionCommitted");
        }
    }

    public void localTransactionRolledback(ConnectionEvent event) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"localTransactionRolledback", (Object[])new Object[0]);
        }
        if (event.getId() == 4) {
            if (this.mcWrapper.involvedInTransaction()) {
                try {
                    this.mcWrapper.getCurrentTranWrapper().delist();
                }
                catch (ResourceException e) {
                    FFDCFilter.processException((Throwable)e, (String)"com.ibm.ejs.j2c.ConnectionEventListener.localTransactionRolledback", (String)"393", (Object)this);
                    Tr.error((TraceComponent)tc, (String)"DELIST_FAILED_J2CA0073", (Object[])new Object[]{"localTransactionRolledback", e, this.mcWrapper.gConfigProps.cfName});
                    ManagedConnection mc = null;
                    try {
                        mc = (ManagedConnection)event.getSource();
                    }
                    catch (ClassCastException cce) {
                        Tr.error((TraceComponent)tc, (String)"GET_SOURCE_CLASS_CAST_EXCP_J2CA0098", (Object[])new Object[]{cce});
                        throw new IllegalStateException("ClassCastException occurred attempting to cast event.getSource to ManagedConnection");
                    }
                    ConnectionEvent errorEvent = new ConnectionEvent(mc, 5);
                    this.connectionErrorOccurred(errorEvent);
                    IllegalStateException rte = new IllegalStateException(e.getMessage());
                    throw rte;
                }
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit((Object)this, (TraceComponent)tc, (String)"localTransactionRolledback", (Object)"no transaction context, return without delisting");
            }
            return;
        }
        this.processBadEvent("localTransactionRolledback", 4, event);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"localTransactionRolledback");
        }
    }

    public void localTransactionStarted(ConnectionEvent event) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"localTransactionStarted", (Object[])new Object[0]);
        }
        if (event.getId() == 2) {
            UOWCoordinator uowCoordinator = this.mcWrapper.getUOWCoordinator();
            if (uowCoordinator == null) {
                uowCoordinator = this.mcWrapper.updateUOWCoordinator();
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((Object)this, (TraceComponent)tc, (String)"uowCoord was null, updating it to current coordinator", (Object[])new Object[0]);
                }
            }
            if (uowCoordinator == null) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit((Object)this, (TraceComponent)tc, (String)"localTransactionStarted", (Object)"no transaction context, return without enlisting");
                }
                return;
            }
            if (tc.isDebugEnabled() && uowCoordinator.isGlobal()) {
                IllegalStateException ise = new IllegalStateException("Illegal attempt to start a local transaction within a global (user) transaction");
                Tr.debug((Object)this, (TraceComponent)tc, (String)"ILLEGAL_USE_OF_LOCAL_TRANSACTION_J2CA0295", (Object[])new Object[]{ise});
            }
            try {
                this.mcWrapper.getCurrentTranWrapper().enlist();
            }
            catch (ResourceException e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ejs.j2c.ConnectionEventListener.localTransactionStarted", (String)"481", (Object)this);
                Tr.error((TraceComponent)tc, (String)"ENLIST_FAILED_J2CA0074", (Object[])new Object[]{"localTransactionStarted", e, this.mcWrapper.gConfigProps.cfName});
                ManagedConnection mc = null;
                try {
                    mc = (ManagedConnection)event.getSource();
                }
                catch (ClassCastException cce) {
                    Tr.error((TraceComponent)tc, (String)"GET_SOURCE_CLASS_CAST_EXCP_J2CA0098", (Object[])new Object[]{cce});
                    throw new IllegalStateException("ClassCastException occurred attempting to cast event.getSource to ManagedConnection");
                }
                ConnectionEvent errorEvent = new ConnectionEvent(mc, 5);
                this.connectionErrorOccurred(errorEvent);
                IllegalStateException rte = new IllegalStateException(e.getMessage());
                throw rte;
            }
        }
        this.processBadEvent("localTransactionStarted", 2, event);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"localTransactionStarted");
        }
    }

    private void processBadEvent(String methodName, int methodEventId, ConnectionEvent eventIn) {
        String eventIdIn = Integer.toString(eventIn.getId());
        String xpathId = this.mcWrapper.gConfigProps.getXpathId();
        String cfName = this.mcWrapper.gConfigProps.cfName;
        Tr.error((TraceComponent)tc, (String)"UNEXPECTED_CONNECTION_EVENT_J2CA0034", (Object[])new Object[]{methodEventId, eventIdIn, cfName});
        ManagedConnection mc = null;
        try {
            mc = (ManagedConnection)eventIn.getSource();
        }
        catch (ClassCastException cce) {
            Tr.error((TraceComponent)tc, (String)"GET_SOURCE_CLASS_CAST_EXCP_J2CA0098", (Object[])new Object[]{cce});
            IllegalStateException rte = new IllegalStateException("processBadEvent: ClassCastException occurred attempting to cast event.getSource to ManagedConnection");
            FFDCFilter.processException((Throwable)cce, (String)"com.ibm.ejs.j2c.ConnectionEventListener.processBadEvent", (String)"809", (Object)this);
            throw rte;
        }
        ConnectionEvent errorEvent = new ConnectionEvent(mc, 5);
        this.connectionErrorOccurred(errorEvent);
        IllegalStateException rte = new IllegalStateException("Method " + methodName + " detected an unexpected ConnectionEvent of " + eventIdIn + " for DataSource/ConnectionFactory " + xpathId);
        FFDCFilter.processException((Throwable)rte, (String)"com.ibm.ejs.j2c.ConnectionEventListener.processBadEvent", (String)"709", (Object)this);
        throw rte;
    }

    public MCWrapper getMcWrapper() {
        return this.mcWrapper;
    }
}

