/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.j2c;

import com.ibm.ejs.j2c.CMConfigData;
import com.ibm.ejs.j2c.CMConfigDataImpl;
import com.ibm.ejs.j2c.CommonFunction;
import com.ibm.ejs.j2c.CommonXAResourceInfo;
import com.ibm.ejs.j2c.DefaultSecurityHelper;
import com.ibm.ejs.j2c.HandleList;
import com.ibm.ejs.j2c.J2CGlobalConfigProperties;
import com.ibm.ejs.j2c.J2CUtilityClass;
import com.ibm.ejs.j2c.MCWrapper;
import com.ibm.ejs.j2c.PoolManager;
import com.ibm.ejs.j2c.ThreadIdentitySecurityHelper;
import com.ibm.ejs.ras.RasHelper;
import com.ibm.tx.jta.OnePhaseXAResource;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.LocalTransaction.LocalTransactionCoordinator;
import com.ibm.ws.Transaction.UOWCoordinator;
import com.ibm.ws.Transaction.UOWCurrent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.j2c.SecurityHelper;
import com.ibm.ws.j2c.TranWrapper;
import com.ibm.ws.jca.adapter.PurgePolicy;
import com.ibm.ws.jca.adapter.WSConnectionManager;
import com.ibm.ws.jca.adapter.WSManagedConnectionFactory;
import com.ibm.ws.jca.cm.AbstractConnectionFactoryService;
import com.ibm.ws.kernel.security.thread.ThreadIdentityManager;
import com.ibm.ws.resource.ResourceRefInfo;
import com.ibm.ws.runtime.metadata.ComponentMetaData;
import com.ibm.ws.security.jca.AuthDataService;
import com.ibm.ws.tx.embeddable.EmbeddableWebSphereTransactionManager;
import com.ibm.ws.tx.rrs.RRSXAResourceFactory;
import com.ibm.wsspi.kernel.service.utils.FilterUtils;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import javax.resource.ResourceException;
import javax.resource.cci.ConnectionFactory;
import javax.resource.cci.ResourceAdapterMetaData;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.ManagedConnection;
import javax.resource.spi.ManagedConnectionFactory;
import javax.resource.spi.TransactionSupport;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginException;
import javax.transaction.xa.Xid;

public final class ConnectionManager
implements com.ibm.ws.j2c.ConnectionManager,
WSConnectionManager,
Serializable {
    private static final long serialVersionUID = -3078170792213348926L;
    private static final TraceComponent tc = Tr.register(ConnectionManager.class, (String)"WAS.j2c", (String)"com.ibm.ws.j2c.resources.J2CAMessages");
    private static final TraceComponent ConnLeakLogic = Tr.register(ConnectionManager.class, (String)"ConnLeakLogic", (String)"com.ibm.ws.j2c.resources.J2CAMessages");
    private final AbstractConnectionFactoryService connectionFactorySvc;
    private static final AtomicLong numberOfCMinstancesEverCreated = new AtomicLong(0L);
    private String cfDetailsKey = "NameNotSet";
    protected CMConfigData cmConfig = null;
    protected HashMap<String, Integer> qmidcmConfigMap = null;
    private boolean shareable = false;
    private int recoveryToken;
    private final transient SecurityHelper securityHelper;
    private final boolean isJDBC;
    private transient int commitPriority = 0;
    private boolean localTranSupportSet = false;
    protected transient PrivilegedExceptionAction<Boolean> _getADP = null;
    protected boolean containerManagedAuth = false;
    protected HashMap<Object, String> handleToThreadMap = null;
    protected HashMap<Object, ComponentMetaData> handleToCMDMap = null;
    protected transient PoolManager _pm = null;
    protected J2CGlobalConfigProperties gConfigProps = null;
    private final boolean rrsTransactional;

    ConnectionManager(AbstractConnectionFactoryService cfSvc, PoolManager pm, J2CGlobalConfigProperties gconfigProps, CommonXAResourceInfo jxri) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"<init>", (Object[])new Object[0]);
        }
        this.connectionFactorySvc = cfSvc;
        this._pm = pm;
        this.gConfigProps = gconfigProps;
        this.cmConfig = jxri.getCmConfig();
        this.cfDetailsKey = this.cmConfig.getCFDetailsKey();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)("cfDetailsKey = " + this.cfDetailsKey + "   for PmiName = " + this.gConfigProps.cfName), (Object[])new Object[0]);
        }
        this.shareable = this.cmConfig.getSharingScope() == 0;
        this.isJDBC = cfSvc.getClass().getName().startsWith("com.ibm.ws.jdbc.");
        int[] zosInfo = cfSvc.getThreadIdentitySecurityAndRRSSupport(null);
        this.rrsTransactional = zosInfo[2] > 0;
        boolean threadSecurity = zosInfo[1] > 0;
        int threadIdentitySupport = zosInfo[0];
        this.securityHelper = ThreadIdentityManager.isThreadIdentityEnabled() && threadIdentitySupport != 0 ? new ThreadIdentitySecurityHelper(threadIdentitySupport, threadSecurity) : new DefaultSecurityHelper();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)(" globalConfigProps " + this.gConfigProps), (Object[])new Object[0]);
            Tr.debug((Object)this, (TraceComponent)tc, (String)(" jxri      " + jxri), (Object[])new Object[0]);
            Tr.debug((Object)this, (TraceComponent)tc, (String)(" securityHelper " + this.securityHelper), (Object[])new Object[0]);
        }
        this.containerManagedAuth = this.cmConfig.getAuth() == 0;
        this.commitPriority = this.cmConfig.getCommitPriority();
        EmbeddableWebSphereTransactionManager tm = pm.connectorSvc.transactionManager;
        if (tm != null) {
            if (!this.rrsTransactional) {
                this.recoveryToken = this.registerXAResourceInfo(tm, jxri, this.commitPriority, null);
            } else if (!TransactionSupport.TransactionSupportLevel.NoTransaction.equals((Object)gconfigProps.transactionSupport)) {
                RRSXAResourceFactory xaFactory = (RRSXAResourceFactory)this._pm.connectorSvc.rrsXAResFactorySvcRef.getService();
                if (xaFactory == null) {
                    throw new IllegalStateException("Native service for RRS transactional support is not active or available. Resource registration is rejected.");
                }
                UOWCurrent currentUOW = (UOWCurrent)tm;
                UOWCoordinator uowCoord = currentUOW.getUOWCoord();
                Xid xid = uowCoord != null ? uowCoord.getXid() : null;
                String filter = FilterUtils.createPropertyFilter((String)"native.xa.factory", (String)xaFactory.getClass().getCanonicalName());
                Serializable xaResInfo = xaFactory.getXAResourceInfo(xid);
                this.recoveryToken = tm.registerResourceInfo(filter, xaResInfo, this.commitPriority);
            }
        } else if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((Object)this, (TraceComponent)tc, (String)"<constructor>, TransactionManager is null", (Object[])new Object[0]);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            numberOfCMinstancesEverCreated.incrementAndGet();
            Tr.debug((Object)this, (TraceComponent)tc, (String)("This brings the total no. of CM instances to " + numberOfCMinstancesEverCreated.get()), (Object[])new Object[0]);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"<init>", (Object)this.toString());
        }
    }

    @Override
    @Deprecated
    public CMConfigData getCMConfigData() {
        return this.cmConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object allocateConnection(ManagedConnectionFactory factory, ConnectionRequestInfo requestInfo) throws ResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"allocateConnection", (Object[])new Object[0]);
        }
        if (this._pm == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)("This should not happen!  pm was null for cf name " + this.cmConfig.getCfKey()), (Object[])new Object[0]);
            }
            String formattedMessage = CommonFunction.getNLSMessage("POOL_MANAGER_NOT_FOUND_J2CA0695", this.cmConfig.getJNDIName() == null ? this.cmConfig.getCfKey() : this.cmConfig.getJNDIName());
            IllegalStateException re = new IllegalStateException(formattedMessage);
            Tr.error((TraceComponent)tc, (String)"FAILED_MANAGED_CONNECTION_J2CA0020", (Object[])new Object[]{re});
            throw re;
        }
        UOWCurrent uowCurrent = (UOWCurrent)this._pm.connectorSvc.transactionManager;
        UOWCoordinator uowCoord = uowCurrent == null ? null : uowCurrent.getUOWCoord();
        Subject subj = this.getFinalSubject(requestInfo, factory, this);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)("This CM is " + this.toString()), (Object[])new Object[0]);
            Tr.debug((Object)this, (TraceComponent)tc, (String)("Input MCF is     " + factory), (Object[])new Object[0]);
        }
        Object rVal = null;
        Object credTokenObj = null;
        MCWrapper mcWrapper = null;
        try {
            credTokenObj = this.securityHelper.beforeGettingConnection(subj, requestInfo);
            mcWrapper = this.allocateMCWrapper(factory, requestInfo, subj, uowCoord);
            this.involveMCInTran(mcWrapper, uowCoord, this);
            int poolState = mcWrapper.getPoolState();
            try {
                mcWrapper.setPoolState(50);
                rVal = mcWrapper.getConnection(subj, requestInfo);
                mcWrapper.setPoolState(poolState);
                if (mcWrapper.do_not_reuse_mcw) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((Object)this, (TraceComponent)tc, (String)("Connection error occurred for this mcw " + mcWrapper + ", mcw will not be reuse"), (Object[])new Object[0]);
                    }
                    mcWrapper.markStale();
                    ResourceException e = new ResourceException("Resource adatepr called connection error event during getConnection processing and did not throw a resource exception.  The reason for this falue may have been logged during the connection error event logging.");
                    throw e;
                }
            }
            catch (ResourceException e) {
                mcWrapper.setPoolState(poolState);
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ejs.j2c.ConnectionManager.allocateConnection", (String)"344", (Object)this);
                Tr.error((TraceComponent)tc, (String)"FAILED_CONNECTION_J2CA0021", (Object[])new Object[]{e, this._pm.gConfigProps.cfName});
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    if (uowCoord != null) {
                        Tr.debug((Object)this, (TraceComponent)tc, (String)("getConnection failed for using uow is " + uowCoord + " tran wrapper id is " + mcWrapper.getTranWrapperId() + " handle count is " + mcWrapper.getHandleCount()), (Object[])new Object[0]);
                    } else {
                        Tr.debug((Object)this, (TraceComponent)tc, (String)("getConnection failed for using uow is null tran wrapper id is " + mcWrapper.getTranWrapperId() + " handle count is " + mcWrapper.getHandleCount()), (Object[])new Object[0]);
                    }
                }
                if (mcWrapper.do_not_reuse_mcw && mcWrapper.getTranWrapperId() == 2 && !mcWrapper.getLocalTransactionWrapper().isEnlisted() && !mcWrapper.getLocalTransactionWrapper().isRegisteredForSync()) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((Object)this, (TraceComponent)tc, (String)"This connection is not registered for sync or enlisted in a transaction", (Object[])new Object[0]);
                    }
                    uowCoord = null;
                    if (mcWrapper.getHandleCount() == 1) {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug((Object)this, (TraceComponent)tc, (String)"Decrementing the handle count for clean up and destroying the managed connection.", (Object[])new Object[0]);
                        }
                        mcWrapper.decrementHandleCount();
                    }
                }
                if ((uowCoord == null || mcWrapper.getTranWrapperId() == 3) && mcWrapper.getHandleCount() == 0) {
                    try {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug((Object)this, (TraceComponent)tc, (String)"Connection error occurred during getConnection to resource adapter.  The managed connection should be good, moving it to free pool.", (Object[])new Object[0]);
                        }
                        mcWrapper.releaseToPoolManager();
                    }
                    catch (Exception exp) {
                        FFDCFilter.processException((Throwable)exp, (String)"com.ibm.ejs.j2c.ConnectionManager.allocateConnection", (String)"364", (Object)this);
                        Tr.error((TraceComponent)tc, (String)"FAILED_CONNECTION_RELEASE_J2CA0022", (Object[])new Object[]{exp, this._pm.gConfigProps.cfName});
                    }
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit((Object)this, (TraceComponent)tc, (String)"allocateConnection");
                }
                throw e;
            }
            catch (Exception e) {
                mcWrapper.setPoolState(poolState);
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ejs.j2c.ConnectionManager.allocateConnection", (String)"372", (Object)this);
                Tr.error((TraceComponent)tc, (String)"FAILED_CONNECTION_J2CA0021", (Object[])new Object[]{e, this._pm.gConfigProps.cfName});
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    if (uowCoord != null) {
                        Tr.debug((Object)this, (TraceComponent)tc, (String)("getConnection failed for using uow is " + uowCoord + " tran wrapper id is " + mcWrapper.getTranWrapperId() + " handle count is " + mcWrapper.getHandleCount()), (Object[])new Object[0]);
                    } else {
                        Tr.debug((Object)this, (TraceComponent)tc, (String)("getConnection failed for using uow is null tran wrapper id is " + mcWrapper.getTranWrapperId() + " handle count is " + mcWrapper.getHandleCount()), (Object[])new Object[0]);
                    }
                }
                if ((uowCoord == null || mcWrapper.getTranWrapperId() == 3) && mcWrapper.getHandleCount() == 0) {
                    try {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug((Object)this, (TraceComponent)tc, (String)"Connection error occurred during getConnection to resource adapter.  The managed connection should be good, moving it to free pool.", (Object[])new Object[0]);
                        }
                        mcWrapper.releaseToPoolManager();
                    }
                    catch (Exception exp) {
                        FFDCFilter.processException((Throwable)exp, (String)"com.ibm.ejs.j2c.ConnectionManager.allocateConnection", (String)"392", (Object)this);
                        Tr.error((TraceComponent)tc, (String)"FAILED_CONNECTION_RELEASE_J2CA0022", (Object[])new Object[]{exp, this._pm.gConfigProps.cfName});
                    }
                }
                ResourceException re = new ResourceException("allocateConnection: caught Exception");
                re.initCause((Throwable)e);
                throw re;
            }
            if (!(this._pm == null || this._pm.gConfigProps.isSmartHandleSupport() && this.shareable)) {
                HandleList hl = null;
                mcWrapper.addToHandleList(rVal, hl);
            }
            if (ConnLeakLogic.isDebugEnabled() || this._pm != null && this._pm.maxNumberOfMCsAllowableInThread > 0) {
                Thread myThread = Thread.currentThread();
                String ivThreadId = RasHelper.getThreadId();
                mcWrapper.setThreadID(ivThreadId);
                mcWrapper.setThreadName(myThread.getName());
                mcWrapper.setLastAllocationTime(System.currentTimeMillis());
                if (mcWrapper.getInitialRequestStackTrace() == null) {
                    Throwable t = new Throwable();
                    mcWrapper.setInitialRequestStackTrace(t);
                }
            }
        }
        finally {
            if (credTokenObj != null) {
                this.securityHelper.afterGettingConnection(subj, requestInfo, credTokenObj);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"allocateConnection", (Object)Integer.toHexString(rVal.hashCode()));
        }
        return rVal;
    }

    private MCWrapper allocateMCWrapper(ManagedConnectionFactory managedConnectionFactory, ConnectionRequestInfo requestInfo, Subject subj, UOWCoordinator uowCoord) throws ResourceException {
        boolean container_at_boundary;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"allocateMCWrapper", (Object[])new Object[0]);
        }
        MCWrapper mcWrapper = null;
        boolean enforceSerialReuse = false;
        if (this.shareable && uowCoord != null && !uowCoord.isGlobal() && !(container_at_boundary = ((LocalTransactionCoordinator)uowCoord).isContainerResolved())) {
            enforceSerialReuse = true;
        }
        try {
            mcWrapper = (MCWrapper)this._pm.reserve(managedConnectionFactory, subj, requestInfo, uowCoord, this.shareable, enforceSerialReuse, this.cmConfig.getCommitPriority(), this.cmConfig.getBranchCoupling());
        }
        catch (ResourceException r) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit((Object)this, (TraceComponent)tc, (String)"allocateMCWrapper");
            }
            throw r;
        }
        if (mcWrapper == null) {
            Tr.error((TraceComponent)tc, (String)"NULL_MANAGED_CONNECTION_J2CA0015", (Object[])new Object[]{this._pm.gConfigProps.cfName});
            throw new ResourceException("PoolManager returned null ManagedConnection");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)("Using MCWrapper@" + Integer.toHexString(mcWrapper.hashCode())), (Object[])new Object[0]);
        }
        if (uowCoord == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"Transaction context does NOT exist", (Object[])new Object[0]);
            }
            if (!this._pm.gConfigProps.isDynamicEnlistmentSupported()) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((Object)this, (TraceComponent)tc, (String)"Not marked for dynamic transaction enlistment", (Object[])new Object[0]);
                }
                if (this._pm.gConfigProps.transactionSupport != TransactionSupport.TransactionSupportLevel.NoTransaction && this._pm.gConfigProps.logMissingTranContext) {
                    Tr.warning((TraceComponent)tc, (String)"MISSING_TRANSACTION_CONTEXT_J2CA0075", (Object[])new Object[]{"allocateMCWrapper"});
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"allocateMCWrapper");
        }
        return mcWrapper;
    }

    private void involveMCInTran(MCWrapper mcWrapper, UOWCoordinator uowCoord, ConnectionManager inUseCM) throws ResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"involveMCInTran", (Object[])new Object[]{inUseCM.toString()});
        }
        if (!mcWrapper.involvedInTransaction()) {
            mcWrapper.setConnectionManager(inUseCM);
            if (mcWrapper.isEnlistmentDisabled()) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((Object)this, (TraceComponent)tc, (String)"Managed connection isEnlistmentDisabled is true.", (Object[])new Object[0]);
                    Tr.debug((Object)this, (TraceComponent)tc, (String)"Returning without calling method initializeForUOW.", (Object[])new Object[0]);
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit((Object)this, (TraceComponent)tc, (String)"involveMCInTran");
                }
                return;
            }
            mcWrapper.setUOWCoordinator(uowCoord);
            this.initializeForUOW(mcWrapper, false);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"involveMCInTran");
        }
    }

    public void initializeForUOW(MCWrapper mcWrapper, boolean originIsDeferred) throws ResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"initializeForUOW", (Object[])new Object[0]);
        }
        boolean registeredForSync = false;
        boolean enlisted = false;
        UOWCoordinator uowCoord = mcWrapper.getUOWCoordinator();
        if (uowCoord == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"Transaction context does NOT exist", (Object[])new Object[0]);
            }
            if (!mcWrapper.gConfigProps.isDynamicEnlistmentSupported()) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((Object)this, (TraceComponent)tc, (String)"Not marked for dynamic transaction enlistment", (Object[])new Object[0]);
                }
                if ((mcWrapper.gConfigProps.transactionSupport == TransactionSupport.TransactionSupportLevel.LocalTransaction || mcWrapper.gConfigProps.transactionSupport == TransactionSupport.TransactionSupportLevel.XATransaction) && mcWrapper.gConfigProps.logMissingTranContext) {
                    Tr.warning((TraceComponent)tc, (String)"MISSING_TRANSACTION_CONTEXT_J2CA0075", (Object[])new Object[]{"initializeForUOW"});
                }
            }
        } else {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"Transaction context exists", (Object[])new Object[0]);
            }
            TranWrapper wrapper = null;
            if (mcWrapper.isEnlistmentDisabled()) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((Object)this, (TraceComponent)tc, (String)"Creating NoTransactionWrapper, since this a a non-transactional datasource", (Object[])new Object[0]);
                }
                wrapper = mcWrapper.getNoTransactionWrapper();
            } else {
                switch (mcWrapper.gConfigProps.transactionSupport) {
                    case NoTransaction: {
                        if (!this.rrsTransactional) {
                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                if (uowCoord.isGlobal()) {
                                    Tr.debug((Object)this, (TraceComponent)tc, (String)"Creating NoTransactionWrapper for use in Global Transaction. RA supports No Transaction.", (Object[])new Object[0]);
                                } else {
                                    Tr.debug((Object)this, (TraceComponent)tc, (String)"Creating NoTransactionWrapper for use in Local Transaction. RA supports No Transaction.", (Object[])new Object[0]);
                                }
                            }
                            wrapper = mcWrapper.getNoTransactionWrapper();
                            break;
                        }
                        if (uowCoord.isGlobal()) {
                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                Tr.debug((Object)this, (TraceComponent)tc, (String)"Creating RRSGlobalTransactionWrapper for use in Global Transaction. RA supports RRS Coordinated Transactions.", (Object[])new Object[0]);
                            }
                            wrapper = mcWrapper.getRRSGlobalTransactionWrapper();
                            break;
                        }
                        if (!this.localTranSupportSet) {
                            mcWrapper.gConfigProps.setLocalTranSupport(false);
                            this.localTranSupportSet = true;
                        }
                        if (mcWrapper.gConfigProps.cciLocalTranSupported) {
                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                Tr.debug((Object)this, (TraceComponent)tc, (String)"Creating LocalTransactionWrapper for use in Local Transaction under RRSTransactional adapter.", (Object[])new Object[0]);
                            }
                            wrapper = mcWrapper.getLocalTransactionWrapper(this.rrsTransactional);
                            break;
                        }
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug((Object)this, (TraceComponent)tc, (String)"Creating RRSLocalTransactionWrapper for use in Local Transaction under RRSTransactional adapter.", (Object[])new Object[0]);
                        }
                        wrapper = mcWrapper.getRRSLocalTransactionWrapper();
                        break;
                    }
                    case LocalTransaction: {
                        String mcfClass;
                        if (!this.rrsTransactional) {
                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                if (uowCoord.isGlobal()) {
                                    Tr.debug((Object)this, (TraceComponent)tc, (String)"Creating LocalTransactionWrapper for use in Global Transaction. RA supports Local Transaction.", (Object[])new Object[0]);
                                } else {
                                    Tr.debug((Object)this, (TraceComponent)tc, (String)"Creating LocalTransactionWrapper for use in Local Transaction. RA supports Local Transaction.", (Object[])new Object[0]);
                                }
                            }
                            wrapper = mcWrapper.getLocalTransactionWrapper();
                            break;
                        }
                        if (uowCoord.isGlobal()) {
                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                Tr.debug((Object)this, (TraceComponent)tc, (String)"Creating RRSGlobalTransactionWrapper for use in Global Transaction. RA supports RRS Coordinated Transactions.", (Object[])new Object[0]);
                            }
                            wrapper = mcWrapper.getRRSGlobalTransactionWrapper();
                            break;
                        }
                        if (!this.localTranSupportSet && (mcfClass = mcWrapper.get_managedConnectionFactory().getClass().getName()).equals("com.ibm.connector2.cics.ECIManagedConnectionFactory")) {
                            mcWrapper.gConfigProps.setLocalTranSupport(this.raSupportsCCILocalTran(mcWrapper.get_managedConnectionFactory()));
                            this.localTranSupportSet = true;
                        }
                        if (mcWrapper.gConfigProps.cciLocalTranSupported) {
                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                Tr.debug((Object)this, (TraceComponent)tc, (String)"Creating LocalTransactionWrapper for use in Local Transaction under RRSTransactional adapter.", (Object[])new Object[0]);
                            }
                            wrapper = mcWrapper.getLocalTransactionWrapper(this.rrsTransactional);
                            break;
                        }
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug((Object)this, (TraceComponent)tc, (String)"Creating RRSLocalTransactionWrapper for use in Local Transaction under RRSTransactional adapter.", (Object[])new Object[0]);
                        }
                        wrapper = mcWrapper.getRRSLocalTransactionWrapper();
                        break;
                    }
                    case XATransaction: {
                        String mcfClass;
                        if (!this.rrsTransactional) {
                            if (uowCoord.isGlobal()) {
                                if (this.isJDBC && mcWrapper.getManagedConnection().getXAResource() instanceof OnePhaseXAResource) {
                                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                        Tr.debug((Object)this, (TraceComponent)tc, (String)"Creating LocalTransactionWrapper for use in Global Transaction.  The resource adapter supports XA Transaction", (Object[])new Object[0]);
                                    }
                                    wrapper = mcWrapper.getLocalTransactionWrapper();
                                    break;
                                }
                                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                    Tr.debug((Object)this, (TraceComponent)tc, (String)"Creating XATransactionWrapper for use in Global Transaction.  The resource adapter supports XA Transaction", (Object[])new Object[0]);
                                }
                                wrapper = mcWrapper.getXATransactionWrapper();
                                break;
                            }
                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                Tr.debug((Object)this, (TraceComponent)tc, (String)"Creating LocalTransactionWrapper for use in Local Transaction. The resource adapter supports XA Transaction.", (Object[])new Object[0]);
                            }
                            wrapper = mcWrapper.getLocalTransactionWrapper();
                            break;
                        }
                        if (uowCoord.isGlobal()) {
                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                Tr.debug((Object)this, (TraceComponent)tc, (String)"Creating RRSGlobalTransactionWrapper for use in Global Transaction. RA supports RRS Coordinated Transactions.", (Object[])new Object[0]);
                            }
                            wrapper = mcWrapper.getRRSGlobalTransactionWrapper();
                            break;
                        }
                        if (!this.localTranSupportSet && (mcfClass = mcWrapper.get_managedConnectionFactory().getClass().getName()).equals("com.ibm.connector2.cics.ECIManagedConnectionFactory")) {
                            mcWrapper.gConfigProps.setLocalTranSupport(this.raSupportsCCILocalTran(mcWrapper.get_managedConnectionFactory()));
                            this.localTranSupportSet = true;
                        }
                        if (mcWrapper.gConfigProps.cciLocalTranSupported) {
                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                Tr.debug((Object)this, (TraceComponent)tc, (String)"Creating LocalTransactionWrapper for use in Local Transaction under RRSTransactional adapter.", (Object[])new Object[0]);
                            }
                            wrapper = mcWrapper.getLocalTransactionWrapper(this.rrsTransactional);
                            break;
                        }
                        wrapper = mcWrapper.getRRSLocalTransactionWrapper();
                        if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break;
                        Tr.debug((Object)this, (TraceComponent)tc, (String)"Created RRSLocalTransactionWrapper for use in Local Transaction under RRSTransactional adapter.", (Object[])new Object[0]);
                        break;
                    }
                }
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)("Created transaction wrapper@" + Integer.toHexString(wrapper.hashCode())), (Object[])new Object[0]);
            }
            try {
                registeredForSync = wrapper.addSync();
                if (mcWrapper.isConnectionSynchronizationProvider()) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((Object)this, (TraceComponent)tc, (String)"This managed connection is a synchronization provider.", (Object[])new Object[0]);
                    }
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        Tr.exit((Object)this, (TraceComponent)tc, (String)"initializeForUOW");
                    }
                    return;
                }
            }
            catch (ResourceException e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ejs.j2c.ConnectionManager.initializeForUOW", (String)"730", (Object)this);
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((Object)this, (TraceComponent)tc, (String)("Exception:" + (Object)((Object)e)), (Object[])new Object[0]);
                }
                try {
                    mcWrapper.releaseToPoolManager();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw e;
            }
            try {
                if (uowCoord != null) {
                    if (uowCoord.isGlobal()) {
                        if (!mcWrapper.gConfigProps.isDynamicEnlistmentSupported() || this.rrsTransactional) {
                            wrapper.enlist();
                            enlisted = true;
                        }
                    } else if (J2CUtilityClass.isContainerAtBoundary(mcWrapper.pm.connectorSvc.transactionManager)) {
                        wrapper.enlist();
                        enlisted = true;
                    }
                }
            }
            catch (ResourceException e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ejs.j2c.ConnectionManager.initializeForUOW", (String)"762", (Object)this);
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit((Object)this, (TraceComponent)tc, (String)"initializeForUOW", (Object)"completed cleanup due to exception.");
                }
                throw e;
            }
        }
        if (!(registeredForSync || enlisted || originIsDeferred)) {
            mcWrapper.setUOWCoordinator(null);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"initializeForUOW");
        }
    }

    public void lazyEnlist(ManagedConnection mc) throws ResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"lazyEnlist", (Object[])new Object[0]);
        }
        MCWrapper mcWrapper = null;
        if (mc != null) {
            mcWrapper = (MCWrapper)this._pm.getMCWFromMctoMCWMap(mc);
            if (mcWrapper == null) {
                String errorString;
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    errorString = "The " + mc + " could not be matched with a mcWrapper for pool manager " + this._pm.hashCode() + " Dumping the mc to mcWrapper table " + this._pm.getMCtoMCWMapToString();
                    Tr.debug((Object)this, (TraceComponent)tc, (String)errorString, (Object[])new Object[0]);
                }
                errorString = "The ManagedConnection from resource " + this._pm.gConfigProps.cfName + " could not be enlisted with the current transaction.";
                Tr.error((TraceComponent)tc, (String)"FAILED_TO_ASSOCIATE_CONNECTION_J2CA0292", (Object[])new Object[]{this._pm.gConfigProps.cfName});
                ResourceException e = new ResourceException(errorString);
                throw e;
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)("Used mc " + mc + " to find mcWrapper " + mcWrapper), (Object[])new Object[0]);
            }
        } else {
            String errorString;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                errorString = "The managed connection is null, we can not find the matching managed connection wrapper in connection pool " + this._pm.hashCode();
                Tr.debug((Object)this, (TraceComponent)tc, (String)errorString, (Object[])new Object[0]);
            }
            errorString = "The Connection Manager lazyEnlist method requires a non-null ManagedConnection parameter.";
            Tr.error((TraceComponent)tc, (String)"FAILED_TO_ENLIST_CONNECTION_J2CA0293", (Object[])new Object[]{this._pm.gConfigProps.cfName});
            ResourceException e = new ResourceException(errorString);
            throw e;
        }
        if (!this._pm.gConfigProps.isDynamicEnlistmentSupported()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit((Object)this, (TraceComponent)tc, (String)"lazyEnlist", (Object)"lazyEnlist Not Supported.  Nothing to do. Returning.");
            }
            return;
        }
        UOWCoordinator uowCoord = mcWrapper.getUOWCoordinator();
        boolean uowCoordNotSet = false;
        if (uowCoord == null) {
            uowCoordNotSet = true;
            uowCoord = mcWrapper.updateUOWCoordinator();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"uowCoord was null, updating it to current coordinator", (Object[])new Object[0]);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)("Coordinator in effect: " + uowCoord), (Object[])new Object[0]);
        }
        if (uowCoord != null) {
            if (uowCoord.isGlobal()) {
                TranWrapper wrapper = null;
                try {
                    wrapper = mcWrapper.getCurrentTranWrapper();
                    if (wrapper == null) {
                        Tr.error((TraceComponent)tc, (String)"NULL_TRAN_WRAPPER_J2CA0057", (Object[])new Object[0]);
                        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                            Tr.exit((Object)this, (TraceComponent)tc, (String)"lazyEnlist", (Object)"No TranWrapper found.");
                        }
                        IllegalStateException rte = new IllegalStateException("lazyEnlist: No TranWrapper found.");
                        throw rte;
                    }
                }
                catch (Exception e) {
                    FFDCFilter.processException((Throwable)e, (String)"com.ibm.ejs.j2c.ConnectionManager.lazyEnlist", (String)"1307", (Object)this);
                    Tr.error((TraceComponent)tc, (String)"ENLIST_FAILED_J2CA0074", (Object[])new Object[]{"lazyEnlist", e, this._pm.gConfigProps.cfName});
                    try {
                        mcWrapper.markStale();
                        mcWrapper.releaseToPoolManager();
                    }
                    catch (Exception e2) {
                        FFDCFilter.processException((Throwable)e2, (String)"com.ibm.ejs.j2c.ConnectionManager.lazyEnlist", (String)"1316", (Object)this);
                    }
                    ResourceException re = new ResourceException(e.getMessage());
                    re.initCause((Throwable)e);
                    throw re;
                }
                wrapper.enlist();
            } else if (uowCoordNotSet) {
                mcWrapper.resetCoordinator();
            }
        } else {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"Transaction context does NOT exist", (Object[])new Object[0]);
            }
            if (this._pm.gConfigProps.logMissingTranContext) {
                Tr.warning((TraceComponent)tc, (String)"MISSING_TRANSACTION_CONTEXT_J2CA0075", (Object[])new Object[]{"lazyEnlist"});
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"lazyEnlist");
        }
    }

    public void associateConnection(Object connection, ManagedConnectionFactory mcf, ConnectionRequestInfo cri) throws ResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"associateConnection", (Object[])new Object[0]);
        }
        Subject subject = this.containerManagedAuth ? this.getFinalSubject(cri, mcf, this) : null;
        this.associateConnection(mcf, subject, cri, connection);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"associateConnection");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void associateConnection(ManagedConnectionFactory mcf, Subject subject, ConnectionRequestInfo cri, Object connection) throws ResourceException {
        UOWCurrent uowCurrent;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"associateConnection", (Object[])new Object[0]);
        }
        UOWCoordinator uowCoord = (uowCurrent = (UOWCurrent)this._pm.connectorSvc.transactionManager) == null ? null : uowCurrent.getUOWCoord();
        MCWrapper mcWrapper = null;
        Object credTokenObj = null;
        try {
            credTokenObj = this.securityHelper.beforeGettingConnection(subject, cri);
            mcWrapper = this.allocateMCWrapper(mcf, cri, subject, uowCoord);
        }
        finally {
            if (credTokenObj != null) {
                this.securityHelper.afterGettingConnection(subject, cri, credTokenObj);
            }
        }
        this.involveMCInTran(mcWrapper, uowCoord, this);
        this.reassociateConnectionHandle(connection, null, mcWrapper, uowCoord);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"associateConnection");
        }
    }

    private void reassociateConnectionHandle(Object connection, MCWrapper fromMCWrapper, MCWrapper toMCWrapper, UOWCoordinator uowCoord) throws ResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"reassociateConnectionHandle", (Object[])new Object[0]);
        }
        try {
            toMCWrapper.associateConnection(connection, fromMCWrapper);
        }
        catch (ResourceException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ejs.j2c.ConnectionManager.reassociateConnectionHandle", (String)"479", (Object)this);
            if (uowCoord == null && toMCWrapper.getHandleCount() == 0) {
                try {
                    toMCWrapper.releaseToPoolManager();
                }
                catch (Exception exp) {
                    FFDCFilter.processException((Throwable)exp, (String)"com.ibm.ejs.j2c.ConnectionManager.reassociateConnectionHandle", (String)"487", (Object)this);
                    Tr.error((TraceComponent)tc, (String)"FAILED_CONNECTION_RELEASE_J2CA0022", (Object[])new Object[]{exp, toMCWrapper.gConfigProps.cfName});
                }
            }
            throw e;
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ejs.j2c.ConnectionManager.reassociateConnectionHandle", (String)"495", (Object)this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"reassociateConnectionHandle: Caught a Non resource exception from mc.associateConnection()", (Object[])new Object[0]);
            }
            Tr.error((TraceComponent)tc, (String)"FAILED_CONNECTION_J2CA0021", (Object[])new Object[]{e, toMCWrapper.gConfigProps.cfName});
            if (uowCoord == null && toMCWrapper.getHandleCount() == 0) {
                try {
                    toMCWrapper.releaseToPoolManager();
                }
                catch (Exception exp) {
                    FFDCFilter.processException((Throwable)exp, (String)"com.ibm.ejs.j2c.ConnectionManager.reassociateConnectionHandle", (String)"518", (Object)this);
                    Tr.error((TraceComponent)tc, (String)"FAILED_CONNECTION_RELEASE_J2CA0022", (Object[])new Object[]{exp, toMCWrapper.gConfigProps.cfName});
                }
            }
            ResourceException re = new ResourceException("reassociateConnectionHandle: caught Exception");
            re.initCause((Throwable)e);
            throw re;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"reassociateConnectionHandle");
        }
    }

    public void inactiveConnectionClosed(Object connection, ManagedConnectionFactory managedConnectionFactory) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"inactiveConnectionClosed", (Object[])new Object[0]);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"inactiveConnectionClosed");
        }
    }

    boolean shareable() {
        return this.shareable;
    }

    public String toString() {
        String nl = CommonFunction.nl;
        StringBuffer buf = new StringBuffer(256);
        buf.append("[ConnectionManager]@");
        buf.append(Integer.toHexString(this.hashCode()));
        buf.append(nl);
        buf.append("JNDI Name <");
        buf.append(this.gConfigProps.cfName);
        buf.append(">");
        buf.append(nl);
        buf.append("shareable <");
        buf.append(this.shareable);
        buf.append(">");
        buf.append(nl);
        return buf.toString();
    }

    public int getRecoveryToken() {
        return this.recoveryToken;
    }

    private boolean raSupportsCCILocalTran(ManagedConnectionFactory mcf) throws ResourceException {
        ConnectionFactory cf;
        ResourceAdapterMetaData raMetaData;
        boolean cciLocalTranSupported = false;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"raSupportsCCILocalTran", (Object[])new Object[0]);
        }
        if ((this.gConfigProps.transactionSupport == TransactionSupport.TransactionSupportLevel.XATransaction || this.gConfigProps.transactionSupport == TransactionSupport.TransactionSupportLevel.LocalTransaction) && (raMetaData = (cf = (ConnectionFactory)mcf.createConnectionFactory((javax.resource.spi.ConnectionManager)this)).getMetaData()) != null) {
            cciLocalTranSupported = raMetaData.supportsLocalTransactionDemarcation();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)("raSupportsCCILocalTran " + cciLocalTranSupported));
        }
        return cciLocalTranSupported;
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void purgePool() throws ResourceException {
        if (tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"purgePool", (Object[])new Object[0]);
        }
        this._pm.purgePoolContents();
        if (tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"purgePool");
        }
    }

    protected int supportsBranchCoupling(int couplingType, ManagedConnectionFactory managedConnectionFactory) {
        int startFlag;
        if (this.isJDBC) {
            startFlag = ((WSManagedConnectionFactory)managedConnectionFactory).getXAStartFlagForBranchCoupling(couplingType);
        } else {
            String bcInfo = "branch-coupling=LOOSE";
            if (couplingType == 1) {
                bcInfo = "branch-coupling=TIGHT";
            }
            Tr.warning((TraceComponent)tc, (String)"IGNORE_FEATURE_J2CA0240", (Object[])new Object[]{bcInfo, this.gConfigProps.cfName});
            startFlag = 0;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)("Branch coupling request for " + this.cmConfig.getCFDetailsKey() + " is " + couplingType + " startFlag is " + startFlag), (Object[])new Object[0]);
        }
        return startFlag;
    }

    protected boolean matchBranchCoupling(int couplingType1, int couplingType2, ManagedConnectionFactory managedConnectionFactory) {
        boolean matched = true;
        if (this.isJDBC && couplingType1 != couplingType2) {
            if (couplingType1 == -1) {
                couplingType1 = ((WSManagedConnectionFactory)managedConnectionFactory).getDefaultBranchCoupling();
            } else if (couplingType2 == -1) {
                couplingType2 = ((WSManagedConnectionFactory)managedConnectionFactory).getDefaultBranchCoupling();
            }
            boolean bl = matched = couplingType1 == couplingType2;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)("Match coupling request for " + couplingType1 + " and " + couplingType2 + " match is " + matched), (Object[])new Object[0]);
        }
        return matched;
    }

    private final Subject getFinalSubject(ConnectionRequestInfo requestInfo, ManagedConnectionFactory mangedConnectionFactory, Object CM) throws ResourceException {
        Subject subj = null;
        if (this.containerManagedAuth) {
            Map loginConfigProps = (Map)this.cmConfig.getLoginConfigProperties().clone();
            String loginConfigurationName = this.cmConfig.getLoginConfigurationName();
            String authDataID = (String)loginConfigProps.get("DefaultPrincipalMapping");
            if (authDataID == null) {
                authDataID = this.connectionFactorySvc.getContainerAuthDataID();
            }
            if (loginConfigurationName == null) {
                loginConfigurationName = this.connectionFactorySvc.getJaasLoginContextEntryName();
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"login configuration name", (Object[])new Object[]{loginConfigurationName});
                Tr.debug((Object)this, (TraceComponent)tc, (String)"container managed auth", (Object[])new Object[]{authDataID});
            }
            if (authDataID != null || loginConfigurationName != null) {
                loginConfigProps.put("com.ibm.mapping.authDataAlias", authDataID);
                try {
                    subj = ((AuthDataService)this._pm.connectorSvc.authDataServiceRef.getServiceWithException()).getSubject(mangedConnectionFactory, loginConfigurationName, loginConfigProps);
                }
                catch (LoginException e) {
                    FFDCFilter.processException((Throwable)e, (String)this.getClass().getName(), (String)"3070", (Object)this, (Object[])new Object[]{this});
                    ResourceException r = new ResourceException((Throwable)e);
                    throw r;
                }
            }
            subj = this.securityHelper.finalizeSubject(subj, requestInfo, this.cmConfig);
        } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)"Subject is", (Object[])new Object[]{subj});
        }
        return subj;
    }

    @Override
    public PurgePolicy getPurgePolicy() {
        return this._pm.gConfigProps.getPurgePolicy();
    }

    @Override
    public ResourceRefInfo getResourceRefInfo() {
        return this.cmConfig;
    }

    final int registerXAResourceInfo(EmbeddableWebSphereTransactionManager tm, CommonXAResourceInfo xaResourceInfo, int commitPriority, String qmid) {
        ArrayList<Byte> resInfo;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"registerXAResourceInfo", (Object[])new Object[0]);
        }
        CMConfigDataImpl cmConfigData = (CMConfigDataImpl)(xaResourceInfo != null ? xaResourceInfo.getCmConfig() : this.cmConfig);
        String id = cmConfigData.getCfKey();
        String jndiName = cmConfigData.getJNDIName();
        String filter = jndiName == null || id.startsWith("application[") ? FilterUtils.createPropertyFilter((String)"config.displayId", (String)id) : FilterUtils.createPropertyFilter((String)"jndiName", (String)jndiName);
        try {
            if (qmid != null) {
                cmConfigData.setQmid(qmid);
            }
            byte[] bytes = CommonFunction.serObjByte(cmConfigData);
            resInfo = new ArrayList<Byte>(bytes.length);
            for (byte b : bytes) {
                resInfo.add(b);
            }
        }
        catch (IOException x) {
            FFDCFilter.processException((Throwable)x, (String)this.getClass().getName(), (String)"581", (Object[])new Object[]{xaResourceInfo.getCmConfig()});
            throw new IllegalArgumentException(x);
        }
        int recoveryToken = tm.registerResourceInfo(filter, resInfo, commitPriority);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"registerXAResourceInfo");
        }
        return recoveryToken;
    }

    public synchronized Integer getQMIDRecoveryToken(String qmid, PoolManager pm) {
        EmbeddableWebSphereTransactionManager tm;
        Integer i = null;
        if (this.qmidcmConfigMap == null) {
            this.qmidcmConfigMap = new HashMap();
        } else {
            i = this.qmidcmConfigMap.get(qmid);
        }
        if (i == null && (tm = pm.connectorSvc.transactionManager) != null && !this.rrsTransactional) {
            i = new Integer(this.registerXAResourceInfo(tm, null, this.commitPriority, qmid));
            this.qmidcmConfigMap.put(qmid, i);
        }
        return i;
    }
}

