/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jca.cm;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.jca.cm.ConnectorService;
import com.ibm.ws.resource.ResourceFactoryBuilder;
import com.ibm.ws.resource.ResourceRefInfo;
import com.ibm.wsspi.kernel.service.utils.FilterUtils;
import com.ibm.wsspi.resource.ResourceFactory;
import com.ibm.wsspi.resource.ResourceInfo;
import java.util.Map;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.util.tracker.ServiceTracker;

public class AppDefinedResourceFactory
implements com.ibm.ws.resource.ResourceFactory {
    private static final TraceComponent tc = Tr.register(AppDefinedResourceFactory.class);
    private final String appName;
    private final ResourceFactoryBuilder builder;
    private final String id;
    private final ServiceTracker<ResourceFactory, ResourceFactory> tracker;

    public AppDefinedResourceFactory(ResourceFactoryBuilder builder, BundleContext bundleContext, String id, String filter, String appName) throws InvalidSyntaxException {
        this.appName = appName;
        this.builder = builder;
        this.id = id;
        this.tracker = new ServiceTracker(bundleContext, bundleContext.createFilter(filter), null);
        this.tracker.open();
    }

    public Object createResource(ResourceInfo info) throws Exception {
        Object resource;
        boolean trace = TraceComponent.isAnyTracingEnabled();
        if (trace && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"createResource", (Object[])new Object[]{info});
        }
        try {
            ResourceFactory factory = (ResourceFactory)this.tracker.waitForService(5000L);
            if (factory == null) {
                throw new Exception(ConnectorService.getMessage("MISSING_RESOURCE_J2CA8030", info.getType(), this.id, "application", this.appName));
            }
            resource = factory.createResource(info);
        }
        catch (Exception x) {
            FFDCFilter.processException((Throwable)x, (String)this.getClass().getName(), (String)"129", (Object)this);
            if (trace && tc.isEntryEnabled()) {
                Tr.exit((Object)this, (TraceComponent)tc, (String)"createResource", (Object)x);
            }
            throw x;
        }
        catch (Error x) {
            FFDCFilter.processException((Throwable)x, (String)this.getClass().getName(), (String)"134", (Object)this);
            if (trace && tc.isEntryEnabled()) {
                Tr.exit((Object)this, (TraceComponent)tc, (String)"createResource", (Object)x);
            }
            throw x;
        }
        if (trace && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"createResource", (Object)resource);
        }
        return resource;
    }

    public Object createResource(ResourceRefInfo ref) throws Exception {
        return this.createResource((ResourceInfo)ref);
    }

    public void destroy() throws Exception {
        boolean trace = TraceComponent.isAnyTracingEnabled();
        if (trace && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"destroy", (Object[])new Object[]{this.id});
        }
        this.tracker.close();
        StringBuilder filter = new StringBuilder(FilterUtils.createPropertyFilter((String)"id", (String)this.id));
        filter.insert(filter.length() - 1, '*');
        this.builder.removeExistingConfigurations(filter.toString());
        if (trace && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"destroy");
        }
    }

    public void modify(Map<String, Object> props) throws Exception {
        throw new UnsupportedOperationException();
    }
}

