/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.injectionengine.osgi.internal;

import com.ibm.websphere.csi.J2EEName;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.ManualTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.container.service.naming.JavaColonNamespaceBindings;
import com.ibm.ws.container.service.naming.NamingConstants;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.injectionengine.InjectionScopeData;
import com.ibm.ws.injectionengine.osgi.internal.DeferredReferenceData;
import com.ibm.ws.injectionengine.osgi.internal.InjectionBindingClassNameProvider;
import com.ibm.ws.injectionengine.osgi.internal.NonCompBinding;
import com.ibm.ws.injectionengine.osgi.internal.NonCompBindingClassNameProvider;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.injectionengine.InjectionBinding;
import com.ibm.wsspi.injectionengine.InjectionException;
import java.io.PrintWriter;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.naming.NameClassPair;
import javax.naming.NamingException;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class OSGiInjectionScopeData
extends InjectionScopeData
implements DeferredReferenceData {
    private static final TraceComponent tc = Tr.register(OSGiInjectionScopeData.class);
    private final NamingConstants.JavaColonNamespace namespace;
    private final OSGiInjectionScopeData parent;
    private ReentrantReadWriteLock compLock;
    JavaColonNamespaceBindings<InjectionBinding<?>> compEnvBindings;
    private JavaColonNamespaceBindings<InjectionBinding<?>> compBindings;
    private Map<NamingConstants.JavaColonNamespace, List<NonCompBinding>> contributedBindings;
    private final ReentrantReadWriteLock nonCompEnvLock;
    private JavaColonNamespaceBindings<NonCompBinding> nonCompBindings;
    private Map<Class<?>, Map<String, InjectionBinding<?>>> savedNonCompEnvBindings;
    private boolean deferredReferenceDataEnabled;
    private Map<DeferredReferenceData, Boolean> deferredReferenceDatas;
    static final long serialVersionUID = 8824531358335413825L;

    public OSGiInjectionScopeData(J2EEName j2eeName, NamingConstants.JavaColonNamespace namespace, OSGiInjectionScopeData parent, ReentrantReadWriteLock nonCompEnvLock) {
        super(j2eeName);
        this.namespace = namespace;
        this.parent = parent;
        this.nonCompEnvLock = nonCompEnvLock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void introspect(PrintWriter writer) {
        writer.println(this.namespace.name() + this.ivJ2EEName);
        writer.println();
        writer.println("NonCompBinding :");
        this.nonCompEnvLock.readLock().lock();
        try {
            if (this.nonCompBindings != null) {
                for (Map.Entry entry : this.nonCompBindings.entrySet()) {
                    writer.printf("%-70s : %s", this.namespace + "/" + (String)entry.getKey(), ((NonCompBinding)entry.getValue()).binding.getInjectionClassTypeName()).println();
                }
            }
        }
        finally {
            this.nonCompEnvLock.readLock().unlock();
        }
        writer.println();
        writer.println("Deferred reference data:");
        this.introspectDeferredReferenceData(writer, "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void introspectDeferredReferenceData(PrintWriter writer, String indent) {
        writer.println(indent + this.namespace);
        ArrayList<DeferredReferenceData> deferredArr = null;
        OSGiInjectionScopeData oSGiInjectionScopeData = this;
        synchronized (oSGiInjectionScopeData) {
            if (this.deferredReferenceDatas != null) {
                deferredArr = new ArrayList<DeferredReferenceData>(this.deferredReferenceDatas.keySet());
            }
        }
        if (deferredArr != null) {
            indent = indent + "\t";
            for (DeferredReferenceData entry : deferredArr) {
                entry.introspectDeferredReferenceData(writer, indent);
            }
        }
    }

    @Override
    public void destroy() {
        super.destroy();
        this.disableDeferredReferenceData();
        if (this.contributedBindings != null) {
            for (List<NonCompBinding> nonCompBindings : this.contributedBindings.values()) {
                for (NonCompBinding nonCompBinding : nonCompBindings) {
                    nonCompBinding.unref();
                }
            }
        }
    }

    @Trivial
    public ReadWriteLock compLock() {
        if (this.compLock == null) {
            this.compLock = new ReentrantReadWriteLock();
        }
        return this.compLock;
    }

    @Trivial
    public boolean isCompAllowed() {
        return this.compLock != null;
    }

    public void addCompBinding(String name, InjectionBinding<?> binding) {
        if (!this.compLock.writeLock().isHeldByCurrentThread()) {
            throw new IllegalStateException();
        }
        if (this.compBindings == null) {
            this.compBindings = new JavaColonNamespaceBindings(NamingConstants.JavaColonNamespace.COMP, InjectionBindingClassNameProvider.instance);
        }
        this.compBindings.bind(name, binding);
    }

    public void addCompEnvBindings(Map<String, InjectionBinding<?>> newBindings) {
        if (!this.compLock.writeLock().isHeldByCurrentThread()) {
            throw new IllegalStateException();
        }
        if (this.compEnvBindings == null) {
            this.compEnvBindings = new JavaColonNamespaceBindings(NamingConstants.JavaColonNamespace.COMP_ENV, InjectionBindingClassNameProvider.instance);
        }
        for (Map.Entry<String, InjectionBinding<?>> entry : newBindings.entrySet()) {
            this.compEnvBindings.bind(entry.getKey(), entry.getValue());
        }
    }

    public void validateNonCompBindings(Map<Class<?>, Map<String, InjectionBinding<?>>> newBindings) throws InjectionException {
        if (!this.nonCompEnvLock.writeLock().isHeldByCurrentThread()) {
            throw new IllegalStateException();
        }
        if (this.savedNonCompEnvBindings != null) {
            for (Map.Entry<Class<?>, Map<String, InjectionBinding<?>>> newBindingsEntry : newBindings.entrySet()) {
                Map<String, InjectionBinding<?>> injectionBindingsMap = this.savedNonCompEnvBindings.get(newBindingsEntry.getKey());
                if (injectionBindingsMap == null) continue;
                for (Map.Entry<String, InjectionBinding<?>> newBindingEntry : newBindingsEntry.getValue().entrySet()) {
                    InjectionBinding<?> savedBinding = injectionBindingsMap.get(newBindingEntry.getKey());
                    if (savedBinding == null) continue;
                    InjectionBinding<?> newBinding = newBindingEntry.getValue();
                    this.validateNonCompBinding(savedBinding, newBinding);
                }
            }
        }
    }

    @Trivial
    private <A extends Annotation> void validateNonCompBinding(InjectionBinding<A> savedBinding, InjectionBinding<?> newBinding) throws InjectionException {
        InjectionBinding<?> newBindingUnchecked = newBinding;
        savedBinding.mergeSaved(newBindingUnchecked);
    }

    private boolean isContributionTracked() {
        return this.namespace == NamingConstants.JavaColonNamespace.APP || this.namespace == NamingConstants.JavaColonNamespace.GLOBAL;
    }

    private Map<NamingConstants.JavaColonNamespace, List<NonCompBinding>> getContributedBindings() {
        if (this.contributedBindings == null) {
            this.contributedBindings = new EnumMap<NamingConstants.JavaColonNamespace, List<NonCompBinding>>(NamingConstants.JavaColonNamespace.class);
        }
        return this.contributedBindings;
    }

    public void addNonCompBindings(Map<Class<?>, Map<String, InjectionBinding<?>>> newBindings, OSGiInjectionScopeData contributor) {
        if (!newBindings.isEmpty()) {
            ArrayList<NonCompBinding> newContributedBindings = null;
            if (this.isContributionTracked()) {
                newContributedBindings = new ArrayList<NonCompBinding>();
            }
            this.addNonCompBindings(newBindings, newContributedBindings);
            if (newContributedBindings != null) {
                Map<NamingConstants.JavaColonNamespace, List<NonCompBinding>> contributedBindings = contributor.getContributedBindings();
                List<NonCompBinding> oldContributedBindings = contributedBindings.get(this.namespace);
                if (oldContributedBindings == null) {
                    contributedBindings.put(this.namespace, newContributedBindings);
                } else {
                    oldContributedBindings.addAll(newContributedBindings);
                }
            }
        }
    }

    private void addNonCompBindings(Map<Class<?>, Map<String, InjectionBinding<?>>> newBindings, Collection<NonCompBinding> contributedBindings) {
        if (this.nonCompBindings == null) {
            this.nonCompBindings = new JavaColonNamespaceBindings(this.namespace, NonCompBindingClassNameProvider.instance);
        }
        for (Map<String, InjectionBinding<?>> bindings : newBindings.values()) {
            for (Map.Entry<String, InjectionBinding<?>> entry : bindings.entrySet()) {
                InjectionBinding<?> binding = entry.getValue();
                if (!binding.isResolved()) continue;
                String qualifiedName = entry.getKey();
                String name = this.namespace.unprefix(qualifiedName);
                NonCompBinding nonCompBinding = (NonCompBinding)this.nonCompBindings.get((Object)name);
                if (nonCompBinding == null) {
                    nonCompBinding = new NonCompBinding(this, binding);
                    this.nonCompBindings.bind(name, (Object)nonCompBinding);
                } else {
                    nonCompBinding.ref();
                }
                if (contributedBindings == null) continue;
                contributedBindings.add(nonCompBinding);
            }
        }
        Map<Class<?>, Map<String, InjectionBinding<?>>> savedBindings = this.savedNonCompEnvBindings;
        if (savedBindings == null) {
            this.savedNonCompEnvBindings = newBindings;
        } else {
            for (Map.Entry<Class<?>, Map<String, InjectionBinding<?>>> newBindingsEntry : newBindings.entrySet()) {
                Class<?> processorClass = newBindingsEntry.getKey();
                Map<String, InjectionBinding<?>> injectionBindingsMap = savedBindings.get(processorClass);
                if (injectionBindingsMap == null) {
                    newBindings.put(processorClass, newBindingsEntry.getValue());
                    continue;
                }
                for (Map.Entry<String, InjectionBinding<?>> entry : newBindingsEntry.getValue().entrySet()) {
                    String qualifiedName = entry.getKey();
                    if (injectionBindingsMap.containsKey(qualifiedName)) continue;
                    injectionBindingsMap.put(qualifiedName, entry.getValue());
                }
            }
        }
    }

    void removeNonCompBinding(InjectionBinding<?> binding) {
        String qualifiedName = binding.getJndiName();
        String name = this.namespace.unprefix(qualifiedName);
        this.nonCompBindings.unbind(name);
        Iterator<Map<String, InjectionBinding<?>>> bindingsIter = this.savedNonCompEnvBindings.values().iterator();
        while (bindingsIter.hasNext()) {
            Map<String, InjectionBinding<?>> bindings = bindingsIter.next();
            if (bindings.remove(qualifiedName) == null || !bindings.isEmpty()) continue;
            bindingsIter.remove();
        }
    }

    public InjectionBinding<?> getInjectionBinding(NamingConstants.JavaColonNamespace namespace, String name) throws NamingException {
        if (namespace == NamingConstants.JavaColonNamespace.COMP) {
            return this.lookup(this.compLock, this.compBindings, name);
        }
        if (namespace == NamingConstants.JavaColonNamespace.COMP_ENV) {
            return this.lookup(this.compLock, this.compEnvBindings, name);
        }
        if (namespace == this.namespace) {
            NonCompBinding nonCompBinding = this.lookup(this.nonCompEnvLock, this.nonCompBindings, name);
            return nonCompBinding == null ? null : nonCompBinding.binding;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T lookup(ReadWriteLock lock, JavaColonNamespaceBindings<T> bindings, String name) throws NamingException {
        Lock readLock = lock.readLock();
        readLock.lock();
        try {
            Object object = bindings == null ? null : bindings.lookup(name);
            return (T)object;
        }
        finally {
            readLock.unlock();
        }
    }

    public boolean hasObjectWithPrefix(NamingConstants.JavaColonNamespace namespace, String name) throws NamingException {
        if (namespace == NamingConstants.JavaColonNamespace.COMP) {
            return this.hasObjectWithPrefix(this.compLock, this.compBindings, name);
        }
        if (namespace == NamingConstants.JavaColonNamespace.COMP_ENV) {
            return this.hasObjectWithPrefix(this.compLock, this.compEnvBindings, name);
        }
        if (namespace == this.namespace) {
            return this.hasObjectWithPrefix(this.nonCompEnvLock, this.nonCompBindings, name);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean hasObjectWithPrefix(ReadWriteLock lock, JavaColonNamespaceBindings<?> bindings, String name) throws NamingException {
        Lock readLock = lock.readLock();
        readLock.lock();
        try {
            boolean bl = bindings != null && bindings.hasObjectWithPrefix(name);
            return bl;
        }
        finally {
            readLock.unlock();
        }
    }

    public Collection<? extends NameClassPair> listInstances(NamingConstants.JavaColonNamespace namespace, String contextName) throws NamingException {
        if (namespace == NamingConstants.JavaColonNamespace.COMP) {
            return this.listInstances(this.compLock, this.compBindings, contextName);
        }
        if (namespace == NamingConstants.JavaColonNamespace.COMP_ENV) {
            return this.listInstances(this.compLock, this.compEnvBindings, contextName);
        }
        if (namespace == this.namespace) {
            return this.listInstances(this.nonCompEnvLock, this.nonCompBindings, contextName);
        }
        return Collections.emptyList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection<? extends NameClassPair> listInstances(ReadWriteLock lock, JavaColonNamespaceBindings<?> bindings, String contextName) throws NamingException {
        Lock readLock = lock.readLock();
        readLock.lock();
        try {
            List list = bindings == null ? Collections.emptyList() : bindings.listInstances(contextName);
            return list;
        }
        finally {
            readLock.unlock();
        }
    }

    public synchronized void enableDeferredReferenceData() {
        this.deferredReferenceDataEnabled = true;
        if (this.parent != null && this.deferredReferenceDatas != null) {
            this.parent.addDeferredReferenceData(this);
        }
    }

    private synchronized void disableDeferredReferenceData() {
        this.deferredReferenceDataEnabled = false;
        if (this.parent != null && this.deferredReferenceDatas != null) {
            this.parent.removeDeferredReferenceData(this);
            this.deferredReferenceDatas = null;
        }
    }

    @ManualTrace
    public synchronized void addDeferredReferenceData(DeferredReferenceData refData) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"addDeferredReferenceData", (Object[])new Object[]{"this=" + this, refData});
        }
        if (this.deferredReferenceDatas == null) {
            this.deferredReferenceDatas = new LinkedHashMap<DeferredReferenceData, Boolean>();
            if (this.parent != null && this.deferredReferenceDataEnabled) {
                this.parent.addDeferredReferenceData(this);
            }
        }
        this.deferredReferenceDatas.put(refData, null);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"addDeferredReferenceData");
        }
    }

    @ManualTrace
    public synchronized void removeDeferredReferenceData(DeferredReferenceData refData) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"removeDeferredReferenceData", (Object[])new Object[]{"this=" + this, refData});
        }
        if (this.deferredReferenceDatas != null) {
            this.deferredReferenceDatas.remove(refData);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"removeDeferredReferenceData");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    @ManualTrace
    public boolean processDeferredReferenceData() {
        Map<DeferredReferenceData, Boolean> deferredReferenceDatas;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"processDeferredReferenceData", (Object[])new Object[]{"this=" + this});
        }
        OSGiInjectionScopeData oSGiInjectionScopeData = this;
        synchronized (oSGiInjectionScopeData) {
            deferredReferenceDatas = this.deferredReferenceDatas;
            this.deferredReferenceDatas = null;
            if (this.parent != null) {
                this.parent.removeDeferredReferenceData(this);
            }
        }
        boolean any = false;
        if (deferredReferenceDatas != null) {
            for (DeferredReferenceData refData : deferredReferenceDatas.keySet()) {
                try {
                    any |= refData.processDeferredReferenceData();
                }
                catch (InjectionException injectionException) {
                    void ex;
                    FFDCFilter.processException((Throwable)injectionException, (String)"com.ibm.ws.injectionengine.osgi.internal.OSGiInjectionScopeData", (String)"540", (Object)this, (Object[])new Object[0]);
                    ex.getClass();
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"processDeferredReferenceData", (Object)any);
        }
        return any;
    }
}

