/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.injectionengine;

import com.ibm.ejs.util.Util;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.wsspi.injectionengine.InjectionBinding;
import com.ibm.wsspi.injectionengine.InjectionException;
import com.ibm.wsspi.injectionengine.InjectionTargetContext;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Type;
import java.security.AccessController;
import java.security.PrivilegedAction;

public abstract class InjectionTarget {
    private static final String CLASS_NAME = InjectionTarget.class.getName();
    private static final TraceComponent tc = Tr.register(InjectionTarget.class, (String)"Injection", (String)"com.ibm.wsspi.injectionengine.injection");
    protected InjectionBinding<?> ivInjectionBinding;
    protected boolean ivFromXML = false;

    public abstract Member getMember();

    public abstract Class<?> getInjectionClassType();

    Class<?>[] getInjectionClassTypes() {
        return new Class[]{this.getInjectionClassType()};
    }

    Object[] getInjectedObjects(Object injectedObject) {
        return new Object[]{injectedObject};
    }

    public abstract Type getGenericType();

    public String toString() {
        return super.toString() + '[' + this.getMember() + ", " + this.ivInjectionBinding.toSimpleString() + ']';
    }

    public void inject(Object objectToInject, InjectionTargetContext targetContext) throws InjectionException {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("inject : " + this.getMember() + " : " + Util.identity((Object)objectToInject) + ", " + targetContext), (Object[])new Object[0]);
        }
        Object injectedObject = this.ivInjectionBinding.getInjectableObject(objectToInject, targetContext);
        try {
            if (isTraceOn && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("injecting " + Util.identity((Object)injectedObject)), (Object[])new Object[0]);
            }
            this.injectMember(objectToInject, injectedObject);
        }
        catch (IllegalArgumentException ex) {
            FFDCFilter.processException((Throwable)ex, (String)(CLASS_NAME + ".inject"), (String)"140", (Object)this, (Object[])new Object[]{objectToInject, targetContext, injectedObject, this.ivInjectionBinding});
            String msg = Tr.formatMessage((TraceComponent)tc, (String)"INCOMPATIBLE_INJECTED_OBJECT_TYPE_CWNEN0074E", (Object[])new Object[]{injectedObject.getClass().getName(), this.ivInjectionBinding.getDisplayName(), this.getMember()});
            InjectionException targetEx = new InjectionException(msg, ex);
            if (isTraceOn && tc.isEntryEnabled()) {
                final Class[] types = this.getInjectionClassTypes();
                final Object[] injectedObjects = this.getInjectedObjects(injectedObject);
                String debug = AccessController.doPrivileged(new PrivilegedAction<String>(){

                    @Override
                    public String run() {
                        StringBuilder sb = new StringBuilder();
                        int end = Math.max(types.length, injectedObjects.length);
                        for (int i = 0; i < end; ++i) {
                            Class type;
                            if (i != 0) {
                                sb.append(", ");
                            }
                            sb.append('[').append(i).append(']');
                            sb.append(" type=");
                            if (i < types.length) {
                                type = types[i];
                                sb.append(type.getName()).append(" (loader=").append(type.getClassLoader()).append(')');
                            } else {
                                type = null;
                                sb.append("error");
                            }
                            sb.append(" object=");
                            if (i < injectedObjects.length) {
                                boolean assignable;
                                Object injectedObject = injectedObjects[i];
                                if (injectedObject == null) {
                                    assignable = type != null && !type.isPrimitive();
                                    sb.append("null");
                                } else {
                                    Class<?> injectedObjectType = injectedObjects[i].getClass();
                                    assignable = type != null && type.isAssignableFrom(injectedObjectType);
                                    sb.append(injectedObjectType.getName()).append(" (loader=").append(injectedObjectType.getClassLoader()).append(')');
                                }
                                if (type == null) continue;
                                sb.append(" assignable=").append(assignable);
                                continue;
                            }
                            sb.append("error");
                        }
                        return sb.toString();
                    }
                });
                Tr.exit((TraceComponent)tc, (String)("inject : " + debug + " : " + targetEx));
            }
            throw targetEx;
        }
        catch (Throwable ex) {
            FFDCFilter.processException((Throwable)ex, (String)(CLASS_NAME + ".inject"), (String)"97", (Object)this, (Object[])new Object[]{objectToInject, targetContext, injectedObject, this.ivInjectionBinding});
            Throwable targetEx = ex;
            if (ex instanceof InvocationTargetException && (targetEx = ex.getCause()) == null) {
                targetEx = ex;
            }
            String name = this.ivInjectionBinding.getDisplayName();
            InjectionException iex = new InjectionException("The injection engine encountered an error injecting " + name + " into " + this.getMember() + ": " + targetEx, targetEx);
            Tr.error((TraceComponent)tc, (String)"INJECTION_FAILED_CWNEN0028E", (Object[])new Object[]{name, this.getMember(), targetEx.getMessage()});
            if (isTraceOn && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)("inject : " + targetEx));
            }
            throw iex;
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("inject : " + this.ivInjectionBinding.getDisplayName() + " : " + Util.identity((Object)injectedObject)));
        }
    }

    protected abstract void injectMember(Object var1, Object var2) throws Exception;

    public InjectionBinding<?> getInjectionBinding() {
        return this.ivInjectionBinding;
    }

    public void setInjectionBinding(InjectionBinding<?> injectionBinding) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("setInjectionBinding : " + injectionBinding), (Object[])new Object[0]);
        }
        this.ivInjectionBinding = injectionBinding;
    }
}

