/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.wim;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.security.wim.ras.WIMMessageHelper;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.wim.Repository;
import com.ibm.ws.security.wim.RepositoryConfig;
import com.ibm.ws.security.wim.RepositoryWrapper;
import com.ibm.ws.security.wim.util.StringUtil;
import com.ibm.wsspi.security.wim.exception.WIMException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
abstract class AbstractRepositoryWrapper
implements RepositoryWrapper {
    private static final TraceComponent tc = Tr.register(AbstractRepositoryWrapper.class);
    private final String repositoryId;
    static final long serialVersionUID = -1980795233136669579L;

    public AbstractRepositoryWrapper(String repositoryId) {
        this.repositoryId = repositoryId;
    }

    @Override
    public Repository getRepository() throws WIMException {
        return null;
    }

    protected abstract RepositoryConfig getRepositoryConfig();

    @Override
    public void clear() {
    }

    @Override
    public Map<String, String> getRepositoryBaseEntries() {
        return this.getRepositoryConfig().getRepositoryBaseEntries();
    }

    @Override
    public Set<String> getRepositoryGroups() {
        String[] repositoriesForGroups = this.getRepositoryConfig().getRepositoriesForGroups();
        if (repositoriesForGroups != null && repositoriesForGroups.length > 0) {
            return new HashSet<String>(Arrays.asList(repositoriesForGroups));
        }
        return Collections.emptySet();
    }

    @Override
    public int isUniqueNameForRepository(String uniqueName, boolean isDn) throws WIMException {
        int repo = -1;
        if (isDn) {
            Set<String> baseEntryList = this.getRepositoryBaseEntries().keySet();
            if (baseEntryList.size() == 0) {
                throw new WIMException("MISSING_BASE_ENTRY", Tr.formatMessage((TraceComponent)tc, (String)"MISSING_BASE_ENTRY", (Object[])WIMMessageHelper.generateMsgParms((Object)this.repositoryId)));
            }
            int uLength = uniqueName.length();
            for (String baseEntry : baseEntryList) {
                int baseEntryLength = baseEntry.length();
                if (baseEntryLength == 0 && repo == -1) {
                    repo = 0;
                    continue;
                }
                if (uLength == baseEntryLength && uniqueName.equalsIgnoreCase(baseEntry)) {
                    return Integer.MAX_VALUE;
                }
                if (uLength <= baseEntryLength || !StringUtil.endsWithIgnoreCase(uniqueName, "," + baseEntry) || repo >= baseEntryLength) continue;
                repo = baseEntryLength;
            }
        }
        return repo;
    }
}

