/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jbatch.container.execution.impl;

import com.ibm.jbatch.container.execution.impl.RuntimeJobExecution;
import com.ibm.jbatch.container.execution.impl.RuntimePartitionExecution;
import com.ibm.jbatch.container.execution.impl.RuntimeSplitFlowExecution;
import com.ibm.jbatch.container.impl.BatchKernelImpl;
import com.ibm.jbatch.container.jsl.ModelResolverFactory;
import com.ibm.jbatch.container.modelresolver.PropertyResolver;
import com.ibm.jbatch.container.modelresolver.PropertyResolverFactory;
import com.ibm.jbatch.container.navigator.JobNavigatorImpl;
import com.ibm.jbatch.container.navigator.ModelNavigator;
import com.ibm.jbatch.container.navigator.NavigatorFactory;
import com.ibm.jbatch.container.persistence.jpa.JobExecutionEntity;
import com.ibm.jbatch.container.persistence.jpa.JobInstanceEntity;
import com.ibm.jbatch.container.persistence.jpa.RemotablePartitionKey;
import com.ibm.jbatch.container.services.IJobXMLSource;
import com.ibm.jbatch.container.services.IPersistenceManagerService;
import com.ibm.jbatch.container.util.SplitFlowConfig;
import com.ibm.jbatch.container.ws.PartitionPlanConfig;
import com.ibm.jbatch.container.ws.TopLevelNameInstanceExecutionInfo;
import com.ibm.jbatch.container.ws.WSJobInstance;
import com.ibm.jbatch.container.ws.events.BatchEventsPublisher;
import com.ibm.jbatch.container.ws.impl.StringUtils;
import com.ibm.jbatch.jsl.model.JSLJob;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.io.StringReader;
import java.util.Date;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.batch.operations.JobExecutionAlreadyCompleteException;
import javax.batch.operations.JobExecutionNotMostRecentException;
import javax.batch.operations.JobRestartException;
import javax.batch.operations.JobStartException;
import javax.batch.operations.NoSuchJobExecutionException;
import javax.batch.runtime.BatchStatus;
import javax.xml.transform.stream.StreamSource;

@TraceObjectField(fieldName="logger", fieldDesc="Ljava/util/logging/Logger;")
@InjectedFFDC
public class JobExecutionHelper {
    private static final String CLASSNAME = JobExecutionHelper.class.getName();
    private static final Logger logger = Logger.getLogger(CLASSNAME);
    private static final long NO_EXECUTION_ID = -1L;
    private final BatchKernelImpl batchKernelImpl;
    static final long serialVersionUID = 7349855026455723162L;

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public JobExecutionHelper(BatchKernelImpl batchKernelImpl) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.execution.impl.JobExecutionHelper", "<init>", new Object[]{batchKernelImpl});
        }
        this.batchKernelImpl = batchKernelImpl;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.jbatch.container.execution.impl.JobExecutionHelper", "<init>", this);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected IPersistenceManagerService getPersistenceManagerService() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.execution.impl.JobExecutionHelper", "getPersistenceManagerService", new Object[0]);
        }
        IPersistenceManagerService iPersistenceManagerService = this.batchKernelImpl.getPersistenceManagerService();
        if (logger != null && logger.isLoggable(Level.FINER)) {
            iPersistenceManagerService = iPersistenceManagerService;
            logger.exiting("com.ibm.jbatch.container.execution.impl.JobExecutionHelper", "getPersistenceManagerService", iPersistenceManagerService);
        }
        return iPersistenceManagerService;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public RuntimeJobExecution createJobStartExecution(WSJobInstance jobInstance, IJobXMLSource jslSource, Properties jobParameters, long executionId) throws JobStartException {
        JobExecutionEntity jobExec;
        ModelNavigator<JSLJob> navigator;
        long instanceId;
        JobInstanceEntity jobInstanceImpl;
        block5: {
            if (logger != null && logger.isLoggable(Level.FINER)) {
                logger.entering("com.ibm.jbatch.container.execution.impl.JobExecutionHelper", "createJobStartExecution", new Object[]{jobInstance, jslSource, jobParameters, executionId});
            }
            jobInstanceImpl = (JobInstanceEntity)jobInstance;
            instanceId = jobInstance.getInstanceId();
            navigator = this.createFirstExecution(jobInstanceImpl, jslSource, jobParameters);
            jobExec = null;
            try {
                jobExec = this.getPersistenceManagerService().getJobExecutionMostRecent(instanceId);
                BatchStatus currentBatchStatus = jobExec.getBatchStatus();
                if (jobExec.getExecutionId() != executionId || currentBatchStatus.equals((Object)BatchStatus.STOPPING) || currentBatchStatus.equals((Object)BatchStatus.STOPPED)) {
                    throw new JobStartException();
                }
            }
            catch (IllegalStateException currentBatchStatus) {
                FFDCFilter.processException((Throwable)currentBatchStatus, (String)"com.ibm.jbatch.container.execution.impl.JobExecutionHelper", (String)"109", (Object)this, (Object[])new Object[]{jobInstance, jslSource, jobParameters, executionId});
                jobExec = this.getPersistenceManagerService().createJobExecution(instanceId, jobParameters, new Date());
                BatchEventsPublisher eventsPublisher = this.batchKernelImpl.getBatchEventsPublisher();
                if (eventsPublisher == null) break block5;
                String correlationId = this.getCorrelationId(jobParameters);
                eventsPublisher.publishJobExecutionEvent(jobExec, "batch/jobs/execution/starting", correlationId);
            }
        }
        TopLevelNameInstanceExecutionInfo topLevelInfo = new TopLevelNameInstanceExecutionInfo(jobInstanceImpl.getJobName(), instanceId, jobExec.getExecutionId());
        RuntimeJobExecution runtimeJobExecution = new RuntimeJobExecution(topLevelInfo, jobParameters, navigator);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            runtimeJobExecution = runtimeJobExecution;
            logger.exiting("com.ibm.jbatch.container.execution.impl.JobExecutionHelper", "createJobStartExecution", runtimeJobExecution);
        }
        return runtimeJobExecution;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public RuntimeJobExecution createJobRestartExecution(long jobInstanceId, IJobXMLSource jobXML, Properties restartJobParameters, long executionId) throws JobRestartException, JobExecutionAlreadyCompleteException, JobExecutionNotMostRecentException, NoSuchJobExecutionException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.execution.impl.JobExecutionHelper", "createJobRestartExecution", new Object[]{jobInstanceId, jobXML, restartJobParameters, executionId});
        }
        JobInstanceEntity jobInstance = this.getPersistenceManagerService().getJobInstance(jobInstanceId);
        if (StringUtils.isEmpty(jobInstance.getJobXml())) {
            this.createFirstExecution(jobInstance, jobXML, restartJobParameters);
        }
        String restartOnFromLastExecution = jobInstance.getRestartOn();
        ModelNavigator<JSLJob> navigator = this.getResolvedJobNavigator(jobInstance.getJobXml(), restartJobParameters);
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("On restart execution with jobInstance Id = " + jobInstanceId + ", batchStatus = " + jobInstance.getBatchStatus().name());
        }
        JobExecutionEntity newExecution = null;
        if (executionId == -1L) {
            newExecution = this.getPersistenceManagerService().createJobExecution(jobInstanceId, restartJobParameters, new Date());
            BatchEventsPublisher eventsPublisher = this.batchKernelImpl.getBatchEventsPublisher();
            if (eventsPublisher != null) {
                String correlationId = this.getCorrelationId(restartJobParameters);
                eventsPublisher.publishJobExecutionEvent(newExecution, "batch/jobs/execution/starting", correlationId);
            }
        } else {
            newExecution = this.getPersistenceManagerService().getJobExecutionMostRecent(jobInstanceId);
            BatchStatus currentBatchStatus = newExecution.getBatchStatus();
            if (newExecution.getExecutionId() != executionId || currentBatchStatus.equals((Object)BatchStatus.STOPPING) || currentBatchStatus.equals((Object)BatchStatus.STOPPED)) {
                throw new JobRestartException();
            }
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("On restartExecution got new execution id = " + newExecution.getExecutionId());
        }
        TopLevelNameInstanceExecutionInfo topLevelInfo = new TopLevelNameInstanceExecutionInfo(navigator.getRootModelElement().getId(), jobInstanceId, newExecution.getExecutionId());
        RuntimeJobExecution runtimeJobExecution = new RuntimeJobExecution(topLevelInfo, restartJobParameters, restartOnFromLastExecution, navigator);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            runtimeJobExecution = runtimeJobExecution;
            logger.exiting("com.ibm.jbatch.container.execution.impl.JobExecutionHelper", "createJobRestartExecution", runtimeJobExecution);
        }
        return runtimeJobExecution;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public ModelNavigator<JSLJob> createFirstExecution(JobInstanceEntity jobInstance, IJobXMLSource jslSource, Properties jobParameters) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.execution.impl.JobExecutionHelper", "createFirstExecution", new Object[]{jobInstance, jslSource, jobParameters});
        }
        StreamSource jslStream = null;
        jslStream = !StringUtils.isEmpty(jobInstance.getJobXml()) ? new StreamSource(new StringReader(jobInstance.getJobXml())) : jslSource.getJSLStreamSource();
        JSLJob jobModel = ModelResolverFactory.createJobResolver().resolveModel(jslStream);
        ModelNavigator<JSLJob> navigator = this.getResolvedJobNavigator(jobModel, jobParameters, false);
        String jobName = navigator.getRootModelElement().getId();
        String jobXmlString = jslSource.getJSLString();
        jobInstance.setJobName(jobName);
        jobInstance.setJobXml(jobXmlString);
        this.getPersistenceManagerService().updateJobInstanceWithJobNameAndJSL(jobInstance.getInstanceId(), jobName, jobXmlString);
        ModelNavigator<JSLJob> modelNavigator = navigator;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            modelNavigator = modelNavigator;
            logger.exiting("com.ibm.jbatch.container.execution.impl.JobExecutionHelper", "createFirstExecution", modelNavigator);
        }
        return modelNavigator;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public RuntimeSplitFlowExecution createSplitFlowExecution(SplitFlowConfig splitFlowConfig, JSLJob splitFlowJobModel) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.execution.impl.JobExecutionHelper", "createSplitFlowExecution", new Object[]{splitFlowConfig, splitFlowJobModel});
        }
        this.getPersistenceManagerService().createSplitFlowExecution(splitFlowConfig.getRemotableSplitFlowKey(), new Date());
        ModelNavigator<JSLJob> navigator = this.getResolvedSplitFlowNavigator(splitFlowJobModel);
        RuntimeSplitFlowExecution runtimeSplitFlowExecution = new RuntimeSplitFlowExecution(splitFlowConfig, navigator);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            runtimeSplitFlowExecution = runtimeSplitFlowExecution;
            logger.exiting("com.ibm.jbatch.container.execution.impl.JobExecutionHelper", "createSplitFlowExecution", runtimeSplitFlowExecution);
        }
        return runtimeSplitFlowExecution;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public RuntimePartitionExecution createPartitionExecution(PartitionPlanConfig partitionPlanConfig, JSLJob partitionJobModel, boolean isRemoteDispatch) throws JobStartException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.execution.impl.JobExecutionHelper", "createPartitionExecution", new Object[]{partitionPlanConfig, partitionJobModel, isRemoteDispatch});
        }
        RemotablePartitionKey partitionKey = new RemotablePartitionKey(partitionPlanConfig.getTopLevelNameInstanceExecutionInfo().getExecutionId(), partitionPlanConfig.getStepName(), partitionPlanConfig.getPartitionNumber());
        this.getPersistenceManagerService().createPartitionExecution(partitionKey, new Date());
        ModelNavigator<JSLJob> navigator = this.getResolvedPartitionNavigator(partitionJobModel, partitionPlanConfig.getPartitionPlanProperties());
        RuntimePartitionExecution runtimePartitionExecution = new RuntimePartitionExecution(partitionPlanConfig, navigator, isRemoteDispatch);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            runtimePartitionExecution = runtimePartitionExecution;
            logger.exiting("com.ibm.jbatch.container.execution.impl.JobExecutionHelper", "createPartitionExecution", runtimePartitionExecution);
        }
        return runtimePartitionExecution;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private String getCorrelationId(Properties jobParameters) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.execution.impl.JobExecutionHelper", "getCorrelationId", new Object[]{jobParameters});
        }
        if (jobParameters != null) {
            String string = jobParameters.getProperty("com_ibm_ws_batch_events_correlationId", null);
            if (logger != null && logger.isLoggable(Level.FINER)) {
                string = string;
                logger.exiting("com.ibm.jbatch.container.execution.impl.JobExecutionHelper", "getCorrelationId", string);
            }
            return string;
        }
        String string = null;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            string = string;
            logger.exiting("com.ibm.jbatch.container.execution.impl.JobExecutionHelper", "getCorrelationId", string);
        }
        return string;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private ModelNavigator<JSLJob> getResolvedJobNavigator(String jobXml, Properties jobParameters) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.execution.impl.JobExecutionHelper", "getResolvedJobNavigator", new Object[]{jobXml, jobParameters});
        }
        JSLJob jobModel = ModelResolverFactory.createJobResolver().resolveModel(new StreamSource(new StringReader(jobXml)));
        ModelNavigator<JSLJob> modelNavigator = this.getResolvedJobNavigator(jobModel, jobParameters, false);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            modelNavigator = modelNavigator;
            logger.exiting("com.ibm.jbatch.container.execution.impl.JobExecutionHelper", "getResolvedJobNavigator", modelNavigator);
        }
        return modelNavigator;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private ModelNavigator<JSLJob> getResolvedJobNavigator(JSLJob jobModel, Properties jobParameters, boolean isPartitionedStep) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.execution.impl.JobExecutionHelper", "getResolvedJobNavigator", new Object[]{jobModel, jobParameters, isPartitionedStep});
        }
        PropertyResolver<JSLJob> propResolver = PropertyResolverFactory.createJSLJobPropertyResolver(isPartitionedStep);
        propResolver.substituteProperties(jobModel, jobParameters);
        JobNavigatorImpl jobNavigatorImpl = NavigatorFactory.createJobNavigator(jobModel);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            jobNavigatorImpl = jobNavigatorImpl;
            logger.exiting("com.ibm.jbatch.container.execution.impl.JobExecutionHelper", "getResolvedJobNavigator", jobNavigatorImpl);
        }
        return jobNavigatorImpl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private ModelNavigator<JSLJob> getResolvedPartitionNavigator(JSLJob jobModel, Properties partitionPlanProperties) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.execution.impl.JobExecutionHelper", "getResolvedPartitionNavigator", new Object[]{jobModel, partitionPlanProperties});
        }
        ModelNavigator<JSLJob> modelNavigator = this.getResolvedJobNavigator(jobModel, partitionPlanProperties, true);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            modelNavigator = modelNavigator;
            logger.exiting("com.ibm.jbatch.container.execution.impl.JobExecutionHelper", "getResolvedPartitionNavigator", modelNavigator);
        }
        return modelNavigator;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private ModelNavigator<JSLJob> getResolvedSplitFlowNavigator(JSLJob jobModel) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.execution.impl.JobExecutionHelper", "getResolvedSplitFlowNavigator", new Object[]{jobModel});
        }
        ModelNavigator<JSLJob> modelNavigator = this.getResolvedJobNavigator(jobModel, null, false);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            modelNavigator = modelNavigator;
            logger.exiting("com.ibm.jbatch.container.execution.impl.JobExecutionHelper", "getResolvedSplitFlowNavigator", modelNavigator);
        }
        return modelNavigator;
    }
}

