/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jbatch.container.util;

import com.ibm.jbatch.container.IThreadRootController;
import com.ibm.jbatch.container.callback.IJobExecutionEndCallbackService;
import com.ibm.jbatch.container.callback.IJobExecutionStartCallbackService;
import com.ibm.jbatch.container.controller.impl.WorkUnitThreadControllerImpl;
import com.ibm.jbatch.container.exception.BatchContainerRuntimeException;
import com.ibm.jbatch.container.execution.impl.RuntimeWorkUnitExecution;
import com.ibm.jbatch.container.services.IBatchKernelService;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.ManualTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.batch.runtime.BatchStatus;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public abstract class BatchWorkUnit
implements Runnable {
    private String CLASSNAME = BatchWorkUnit.class.getName();
    private Logger logger = Logger.getLogger(BatchWorkUnit.class.getName());
    protected RuntimeWorkUnitExecution runtimeWorkUnitExecution = null;
    protected IBatchKernelService batchKernel = null;
    protected IThreadRootController controller;
    protected List<IJobExecutionStartCallbackService> beforeCallbacks;
    protected List<IJobExecutionEndCallbackService> afterCallbacks;
    protected boolean notifyCallbackWhenDone;
    static final long serialVersionUID = 7076587665581031377L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public BatchWorkUnit(IBatchKernelService batchKernel, RuntimeWorkUnitExecution runtimeExecution, List<IJobExecutionStartCallbackService> beforeCallbacks, List<IJobExecutionEndCallbackService> afterCallbacks) {
        this(batchKernel, runtimeExecution, beforeCallbacks, afterCallbacks, true);
    }

    public BatchWorkUnit(IBatchKernelService batchKernel, RuntimeWorkUnitExecution runtimeExecution, List<IJobExecutionStartCallbackService> beforeCallbacks, List<IJobExecutionEndCallbackService> afterCallbacks, boolean notifyCallbackWhenDone) {
        this.setBatchKernel(batchKernel);
        this.runtimeWorkUnitExecution = runtimeExecution;
        this.setNotifyCallbackWhenDone(notifyCallbackWhenDone);
        this.controller = new WorkUnitThreadControllerImpl(this.runtimeWorkUnitExecution);
        this.beforeCallbacks = beforeCallbacks;
        this.afterCallbacks = afterCallbacks;
    }

    public IThreadRootController getController() {
        return this.controller;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @ManualTrace
    public void run() {
        String method = "run";
        if (this.logger.isLoggable(Level.FINER)) {
            this.logger.entering(this.CLASSNAME, method);
        }
        try {
            if (this.beforeCallbacks != null) {
                for (IJobExecutionStartCallbackService callback : this.beforeCallbacks) {
                    try {
                        callback.jobStarted(this.runtimeWorkUnitExecution);
                    }
                    catch (Throwable throwable) {
                        void t;
                        FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.jbatch.container.util.BatchWorkUnit", (String)"104", (Object)this, (Object[])new Object[0]);
                        this.runtimeWorkUnitExecution.logExecutionFailedMessage();
                        throw new BatchContainerRuntimeException("An error occurred during job log initialization.", (Throwable)t);
                    }
                }
            }
            this.runtimeWorkUnitExecution.logExecutionStartingMessage();
            this.controller.runExecutionOnThread();
            if (this.runtimeWorkUnitExecution.getBatchStatus().equals((Object)BatchStatus.COMPLETED)) {
                this.runtimeWorkUnitExecution.logExecutionCompletedMessage();
            } else if (this.runtimeWorkUnitExecution.getBatchStatus().equals((Object)BatchStatus.STOPPED)) {
                this.runtimeWorkUnitExecution.logExecutionStoppedMessage();
            } else {
                this.runtimeWorkUnitExecution.logExecutionFailedMessage();
            }
        }
        catch (Throwable throwable) {
            void t;
            FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.jbatch.container.util.BatchWorkUnit", (String)"128", (Object)this, (Object[])new Object[0]);
            this.runtimeWorkUnitExecution.logExecutionFailedMessage();
            throw new BatchContainerRuntimeException("The job failed unexpectedly.", (Throwable)t);
        }
        finally {
            this.markThreadCompleted();
        }
        if (this.logger.isLoggable(Level.FINER)) {
            this.logger.exiting(this.CLASSNAME, method);
        }
    }

    protected BatchStatus getBatchStatus() {
        return this.runtimeWorkUnitExecution.getWorkUnitJobContext().getBatchStatus();
    }

    protected String getExitStatus() {
        return this.runtimeWorkUnitExecution.getWorkUnitJobContext().getExitStatus();
    }

    public void setBatchKernel(IBatchKernelService batchKernel) {
        this.batchKernel = batchKernel;
    }

    public IBatchKernelService getBatchKernel() {
        return this.batchKernel;
    }

    public void setJobExecutionImpl(RuntimeWorkUnitExecution runtimeWorkUnitExecution) {
        this.runtimeWorkUnitExecution = runtimeWorkUnitExecution;
    }

    public RuntimeWorkUnitExecution getRuntimeWorkUnitExecution() {
        return this.runtimeWorkUnitExecution;
    }

    public void setNotifyCallbackWhenDone(boolean notifyCallbackWhenDone) {
        this.notifyCallbackWhenDone = notifyCallbackWhenDone;
    }

    public boolean isNotifyCallbackWhenDone() {
        return this.notifyCallbackWhenDone;
    }

    protected void markThreadCompleted() {
        try {
            this.getBatchKernel().workUnitCompleted(this);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.jbatch.container.util.BatchWorkUnit", (String)"179", (Object)this, (Object[])new Object[0]);
        }
        if (this.afterCallbacks != null) {
            for (IJobExecutionEndCallbackService callback : this.afterCallbacks) {
                try {
                    callback.jobEnded(this.runtimeWorkUnitExecution);
                }
                catch (Throwable throwable) {
                    FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.jbatch.container.util.BatchWorkUnit", (String)"186", (Object)this, (Object[])new Object[0]);
                }
            }
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(BatchWorkUnit.class);
    }
}

