/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webcontainer.cors;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.webcontainer.cors.CorsHelper;
import com.ibm.ws.webcontainer.osgi.interceptor.RequestInterceptor;
import com.ibm.wsspi.kernel.service.utils.AtomicServiceReference;
import java.io.IOException;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@Component(service={RequestInterceptor.class}, name="com.ibm.ws.webcontainer.cors.request.interceptor", configurationPolicy=ConfigurationPolicy.IGNORE, immediate=true, property={"service.vendor=IBM", "InterceptPoint=AfterFilters", "service.ranking:Integer=2147483647"})
public class CorsRequestInterceptor
implements RequestInterceptor {
    private static final TraceComponent tc = Tr.register(CorsRequestInterceptor.class);
    private final String KEY_CORS_HELPER = "corsHelper";
    private final AtomicServiceReference<CorsHelper> corsHelperRef = new AtomicServiceReference("corsHelper");
    static final long serialVersionUID = 2054992149989351399L;

    @Activate
    protected void activate(ComponentContext context, Map<String, Object> properties) {
        this.corsHelperRef.activate(context);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((Object)this, (TraceComponent)tc, (String)"Activating CorsRequestInterceptor", (Object[])new Object[]{properties});
        }
    }

    @Deactivate
    protected void deactivate(ComponentContext context, int reason) {
        this.corsHelperRef.deactivate(context);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((Object)this, (TraceComponent)tc, (String)("Deactivating CorsRequestInterceptor, reason=" + reason), (Object[])new Object[0]);
        }
    }

    @Reference(service=CorsHelper.class, name="corsHelper")
    protected void setCorsHelper(ServiceReference<CorsHelper> corsHelper) {
        this.corsHelperRef.setReference(corsHelper);
    }

    protected void unsetCorsHelper(ServiceReference<CorsHelper> corsHelper) {
        this.corsHelperRef.unsetReference(corsHelper);
    }

    /*
     * WARNING - void declaration
     */
    public boolean handleRequest(HttpServletRequest request, HttpServletResponse response) {
        boolean handlingRequestCompleted = false;
        CorsHelper corsHelper = (CorsHelper)this.corsHelperRef.getService();
        if (corsHelper == null) {
            block6: {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((Object)this, (TraceComponent)tc, (String)"OSGi service 'CorsHelper' is not available.", (Object[])new Object[0]);
                }
                try {
                    response.sendError(500, TraceNLS.getFormattedMessage(this.getClass(), (String)"com.ibm.ws.webcontainer.cors.internal.resources.CorsServiceMessages", (String)"OSGI_SERVICE_ERROR", (Object[])new Object[]{"CorsHelper"}, (String)"CWWKO1001E: OSGi service {0} is not available."));
                }
                catch (IOException iOException) {
                    void e;
                    FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.webcontainer.cors.CorsRequestInterceptor", (String)"91", (Object)this, (Object[])new Object[]{request, response});
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isEventEnabled()) break block6;
                    Tr.event((Object)this, (TraceComponent)tc, (String)("Exception occurred while trying to send error 500: \n response=" + response + " : \n exception=" + e), (Object[])new Object[0]);
                }
            }
            return true;
        }
        if (corsHelper.isCorsSupportEnabled()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"CORS is supported. Handling the request.", (Object[])new Object[0]);
            }
            handlingRequestCompleted = corsHelper.handleCorsRequest(request, response);
        }
        return handlingRequestCompleted;
    }
}

