/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.library.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.library.internal.LibraryGeneration;
import com.ibm.ws.library.internal.LibraryPackageExporter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.artifact.ArtifactContainer;
import com.ibm.wsspi.artifact.factory.ArtifactContainerFactory;
import com.ibm.wsspi.classloading.ApiType;
import com.ibm.wsspi.classloading.ClassLoadingService;
import com.ibm.wsspi.config.Fileset;
import com.ibm.wsspi.kernel.service.utils.PathUtils;
import com.ibm.wsspi.library.Library;
import com.ibm.wsspi.library.LibraryChangeListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Dictionary;
import java.util.EnumSet;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.util.tracker.ServiceTracker;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class SharedLibraryImpl
implements Library {
    private static final TraceComponent tc = Tr.register(SharedLibraryImpl.class);
    private static final LibraryChangeListener[] EMPTY_LIBRARY_LISTENERS = new LibraryChangeListener[0];
    private volatile boolean deleted;
    private volatile ServiceTracker<LibraryChangeListener, LibraryChangeListener> libraryListenersTracker = null;
    private volatile ServiceRegistration<Library> libraryReg = null;
    final BundleContext ctx;
    private final ClassLoadingService classLoadingService;
    private final ConfigurationAdmin configAdmin;
    private final String resolvedBasePath;
    final Object generationLock = new Object(){
        static final long serialVersionUID = 2483639803450672373L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(1.class);
        }
    };
    private volatile LibraryGeneration currentGeneration = null;
    private LibraryGeneration nextGeneration = null;
    final ArtifactContainerFactory artifactContainerFactory;
    private final LibraryPackageExporter packageExporter;
    static final long serialVersionUID = 6288237618632180389L;

    SharedLibraryImpl(BundleContext ctx, ClassLoadingService classLoadingService, ConfigurationAdmin configAdmin, String resolvedBasePath, ArtifactContainerFactory artifactContainerFactory, LibraryPackageExporter packageExporter) {
        this.ctx = ctx;
        this.classLoadingService = classLoadingService;
        this.configAdmin = configAdmin;
        this.resolvedBasePath = resolvedBasePath;
        this.artifactContainerFactory = artifactContainerFactory;
        this.packageExporter = packageExporter;
    }

    boolean isDeleted() {
        return this.deleted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    void update(Dictionary<String, Object> props) {
        LibraryGeneration nextGen;
        if (this.deleted) {
            return;
        }
        String instancePid = (String)props.get("service.pid");
        String instanceId = (String)props.get("id");
        if (instanceId == null) {
            Tr.error((TraceComponent)tc, (String)"cls.library.id.missing", (Object[])new Object[0]);
        }
        if (this.libraryListenersTracker == null) {
            Filter listenerFilter = null;
            try {
                listenerFilter = FrameworkUtil.createFilter((String)("(&(objectClass=" + LibraryChangeListener.class.getName() + ")(|(library=" + instanceId + ")(libraryRef=*" + instancePid + "*)))"));
            }
            catch (InvalidSyntaxException invalidSyntaxException) {
                void e;
                FFDCFilter.processException((Throwable)invalidSyntaxException, (String)"com.ibm.ws.library.internal.SharedLibraryImpl", (String)"112", (Object)this, (Object[])new Object[]{props});
                Tr.error((TraceComponent)tc, (String)"cls.library.id.invalid", (Object[])new Object[]{instanceId, e.toString()});
            }
            ServiceTracker tracker = new ServiceTracker(this.ctx, listenerFilter, null);
            tracker.open();
            this.libraryListenersTracker = tracker;
        }
        Object object = this.generationLock;
        synchronized (object) {
            nextGen = this.nextGeneration;
            if (nextGen != null) {
                this.nextGeneration = null;
                nextGen.cancel();
            }
            this.nextGeneration = nextGen = new LibraryGeneration(this, instanceId, props);
        }
        nextGen.fetchFilesets();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void delete() {
        this.deleted = true;
        if (this.libraryListenersTracker != null) {
            this.libraryListenersTracker.close();
            this.libraryListenersTracker = null;
        }
        Object object = this.generationLock;
        synchronized (object) {
            LibraryGeneration libGen = this.nextGeneration;
            if (libGen != null) {
                this.nextGeneration = null;
                libGen.cancel();
            }
            if ((libGen = this.currentGeneration) != null) {
                this.currentGeneration = null;
                libGen.cancel();
            }
        }
        if (this.libraryReg != null) {
            this.libraryReg.unregister();
            this.libraryReg = null;
        }
        this.packageExporter.delete(this);
    }

    @Override
    public String id() {
        LibraryGeneration currentGen = this.currentGeneration;
        return currentGen != null ? currentGen.getLibraryId() : null;
    }

    @Override
    public ClassLoader getClassLoader() {
        return this.classLoadingService.getSharedLibraryClassLoader(this);
    }

    @Override
    public EnumSet<ApiType> getApiTypeVisibility() {
        LibraryGeneration currentGen = this.currentGeneration;
        return currentGen == null ? null : currentGen.getApiTypeVisibility();
    }

    public String toString() {
        LibraryGeneration currentGen = this.currentGeneration;
        String genStr = currentGen == null ? "<uninitialized>" : currentGen.getLibraryId();
        return String.format("Shared Library %s @ %x", genStr, this.hashCode());
    }

    @Override
    public Collection<File> getFiles() {
        LibraryGeneration currentGen = this.currentGeneration;
        return currentGen == null ? null : currentGen.getFiles();
    }

    @Override
    public Collection<File> getFolders() {
        LibraryGeneration currentGen = this.currentGeneration;
        return currentGen == null ? null : currentGen.getFolders();
    }

    @Override
    public Collection<Fileset> getFilesets() {
        LibraryGeneration currentGen = this.currentGeneration;
        return currentGen == null ? null : currentGen.getFilesets();
    }

    @Override
    public Collection<ArtifactContainer> getContainers() {
        LibraryGeneration currentGen = this.currentGeneration;
        return currentGen == null ? null : currentGen.getContainers();
    }

    void setLibraryServiceProperties(Dictionary<String, Object> svcProps) {
        ServiceRegistration svcReg;
        if (this.deleted) {
            return;
        }
        if (this.libraryReg == null) {
            svcReg = this.libraryReg = this.ctx.registerService(Library.class, (Object)this, svcProps);
        } else {
            svcReg = this.libraryReg;
            svcReg.setProperties(svcProps);
            this.packageExporter.refreshExporters(this);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("svc prop keys are " + Arrays.toString(svcReg.getReference().getPropertyKeys())), (Object[])new Object[0]);
        }
    }

    /*
     * WARNING - void declaration
     */
    void notifyListeners() {
        if (this.deleted) {
            return;
        }
        ServiceTracker<LibraryChangeListener, LibraryChangeListener> ls = this.libraryListenersTracker;
        if (ls == null) {
            return;
        }
        for (LibraryChangeListener listener : (LibraryChangeListener[])ls.getServices((Object[])EMPTY_LIBRARY_LISTENERS)) {
            if (this.deleted) {
                return;
            }
            if (listener == null) continue;
            try {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("notifying listener: " + listener), (Object[])new Object[0]);
                }
                listener.libraryNotification();
            }
            catch (Exception exception) {
                void e;
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.library.internal.SharedLibraryImpl", (String)"260", (Object)this, (Object[])new Object[0]);
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)tc, (String)("caught exception from listener: " + listener), (Object[])new Object[]{e});
            }
        }
    }

    Collection<File> retrieveFiles(String[] pids, String displayId) {
        if (pids == null || pids.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<File> result = new ArrayList<File>();
        for (String pid : pids) {
            try {
                Configuration config = this.configAdmin.getConfiguration(pid, this.ctx.getBundle().getLocation());
                Dictionary configProps = config.getProperties();
                if (configProps == null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("setFiles: Configuration not found for " + pid), (Object[])new Object[0]);
                    }
                    config.delete();
                    continue;
                }
                String fileName = (String)configProps.get("name");
                File f = null;
                if (fileName != null && !fileName.isEmpty()) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("setFiles: found" + fileName), (Object[])new Object[0]);
                    }
                    if ((f = new File(this.normalizePath(fileName))).exists() && !f.isDirectory()) {
                        result.add(f);
                    }
                }
                if (!tc.isWarningEnabled() || f != null && !f.isDirectory() && f.exists()) continue;
                Tr.warning((TraceComponent)tc, (String)"cls.library.file.invalid", (Object[])new Object[]{displayId, fileName});
            }
            catch (IOException iOException) {
                FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.library.internal.SharedLibraryImpl", (String)"304", (Object)this, (Object[])new Object[]{pids, displayId});
            }
        }
        return result;
    }

    Collection<File> retrieveFolders(String instanceId, String[] pids, String displayId) {
        if (pids == null || pids.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<File> result = new ArrayList<File>();
        for (String pid : pids) {
            try {
                Configuration config = this.configAdmin.getConfiguration(pid, this.ctx.getBundle().getLocation());
                Dictionary configProps = config.getProperties();
                if (configProps == null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("setFolders: Configuration not found for " + pid), (Object[])new Object[0]);
                    }
                    config.delete();
                    continue;
                }
                String dir = (String)configProps.get("dir");
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("setFolders: Found " + dir), (Object[])new Object[0]);
                }
                File f = null;
                if (dir != null && !"".equals(dir) && (f = new File(this.normalizePath(dir))).isDirectory()) {
                    result.add(f);
                }
                if (!tc.isWarningEnabled() || f != null && (!f.exists() || f.isDirectory()) && (f.exists() || "global".equals(instanceId))) continue;
                Tr.warning((TraceComponent)tc, (String)"cls.library.folder.invalid", (Object[])new Object[]{displayId, dir});
            }
            catch (IOException iOException) {
                FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.library.internal.SharedLibraryImpl", (String)"349", (Object)this, (Object[])new Object[]{instanceId, pids, displayId});
            }
        }
        return result;
    }

    private String normalizePath(String path) {
        String result = PathUtils.slashify((String)path);
        if (!PathUtils.pathIsAbsolute((String)result)) {
            result = this.resolvedBasePath + result;
        }
        result = PathUtils.normalize((String)result);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void publishGeneration(LibraryGeneration libraryGeneration) {
        Object object = this.generationLock;
        synchronized (object) {
            if (libraryGeneration.isCancelled()) {
                return;
            }
            LibraryGeneration libGen = this.currentGeneration;
            this.currentGeneration = libraryGeneration;
            if (libGen != null) {
                libGen.cancel();
            }
        }
        this.setLibraryServiceProperties(libraryGeneration.getProperties());
        this.notifyListeners();
    }
}

