/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.recoverylog.spi;

import com.ibm.tx.util.logging.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.recoverylog.spi.RLSUtils;
import java.nio.ByteBuffer;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public abstract class LogRecord {
    private static final com.ibm.tx.util.logging.TraceComponent tc;
    protected static final byte TRUE = 1;
    protected static final byte FALSE = 0;
    protected ByteBuffer _buffer = null;
    private int _absolutePosition;
    protected static final byte[] RECORD_MAGIC_NUMBER;
    public static final int HEADER_SIZE;
    static final long serialVersionUID = -8050754277670823697L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    protected LogRecord(ByteBuffer buffer, int absolutePosition) {
        if (tc.isEntryEnabled()) {
            Tr.entry((com.ibm.tx.util.logging.TraceComponent)tc, (String)"LogRecord", (Object)new Object[]{buffer, new Integer(absolutePosition)});
        }
        this._buffer = buffer;
        this._absolutePosition = absolutePosition;
        if (tc.isEntryEnabled()) {
            Tr.exit((com.ibm.tx.util.logging.TraceComponent)tc, (String)"LogRecord", (Object)this);
        }
    }

    protected int position() {
        if (tc.isEntryEnabled()) {
            Tr.entry((com.ibm.tx.util.logging.TraceComponent)tc, (String)"position", (Object)this);
        }
        int position = this._absolutePosition + this._buffer.position();
        if (tc.isEntryEnabled()) {
            Tr.exit((com.ibm.tx.util.logging.TraceComponent)tc, (String)"position", (Object)new Integer(position));
        }
        return position;
    }

    protected void position(int newPosition) {
        if (tc.isEntryEnabled()) {
            Tr.entry((com.ibm.tx.util.logging.TraceComponent)tc, (String)"position", (Object)new Object[]{this, new Integer(newPosition)});
        }
        this._buffer.position(newPosition -= this._absolutePosition);
        if (tc.isEntryEnabled()) {
            Tr.exit((com.ibm.tx.util.logging.TraceComponent)tc, (String)"position");
        }
    }

    protected int absolutePosition() {
        if (tc.isEntryEnabled()) {
            Tr.entry((com.ibm.tx.util.logging.TraceComponent)tc, (String)"absolutePosition", (Object)this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((com.ibm.tx.util.logging.TraceComponent)tc, (String)"absolutePosition", (Object)new Integer(this._absolutePosition));
        }
        return this._absolutePosition;
    }

    protected void advancePosition(int bytes) {
        if (tc.isEntryEnabled()) {
            Tr.entry((com.ibm.tx.util.logging.TraceComponent)tc, (String)"advancePosition", (Object)new Object[]{this, new Integer(bytes)});
        }
        int newPosition = this._buffer.position() + bytes;
        this._buffer.position(newPosition);
        if (tc.isDebugEnabled()) {
            Tr.debug((com.ibm.tx.util.logging.TraceComponent)tc, (String)("Buffer's position now " + newPosition));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((com.ibm.tx.util.logging.TraceComponent)tc, (String)"advancePosition");
        }
    }

    protected void get(byte[] bytes) {
        if (tc.isEntryEnabled()) {
            Tr.entry((com.ibm.tx.util.logging.TraceComponent)tc, (String)"get", (Object)new Object[]{this, new Integer(bytes.length)});
        }
        this._buffer.get(bytes);
        if (tc.isDebugEnabled()) {
            Tr.debug((com.ibm.tx.util.logging.TraceComponent)tc, (String)RLSUtils.toHexString(bytes, 32));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((com.ibm.tx.util.logging.TraceComponent)tc, (String)"get");
        }
    }

    protected int getInt() {
        if (tc.isEntryEnabled()) {
            Tr.entry((com.ibm.tx.util.logging.TraceComponent)tc, (String)"getInt", (Object)this);
        }
        int data = this._buffer.getInt();
        if (tc.isEntryEnabled()) {
            Tr.exit((com.ibm.tx.util.logging.TraceComponent)tc, (String)"getInt", (Object)new Integer(data));
        }
        return data;
    }

    protected long getLong() {
        if (tc.isEntryEnabled()) {
            Tr.entry((com.ibm.tx.util.logging.TraceComponent)tc, (String)"getLong", (Object)this);
        }
        long data = this._buffer.getLong();
        if (tc.isEntryEnabled()) {
            Tr.exit((com.ibm.tx.util.logging.TraceComponent)tc, (String)"getLong", (Object)new Long(data));
        }
        return data;
    }

    protected short getShort() {
        if (tc.isEntryEnabled()) {
            Tr.entry((com.ibm.tx.util.logging.TraceComponent)tc, (String)"getShort", (Object)this);
        }
        short data = this._buffer.getShort();
        if (tc.isEntryEnabled()) {
            Tr.exit((com.ibm.tx.util.logging.TraceComponent)tc, (String)"getShort", (Object)new Short(data));
        }
        return data;
    }

    protected boolean getBoolean() {
        byte dataByte;
        boolean data;
        if (tc.isEntryEnabled()) {
            Tr.entry((com.ibm.tx.util.logging.TraceComponent)tc, (String)"getBoolean", (Object)this);
        }
        boolean bl = data = (dataByte = this._buffer.get()) == 1;
        if (tc.isEntryEnabled()) {
            Tr.exit((com.ibm.tx.util.logging.TraceComponent)tc, (String)"getBoolean", (Object)new Boolean(data));
        }
        return data;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = com.ibm.websphere.ras.Tr.register(LogRecord.class);
        tc = Tr.register(LogRecord.class, (String)"Transaction", null);
        RECORD_MAGIC_NUMBER = new byte[]{82, 67, 82, 68};
        HEADER_SIZE = RECORD_MAGIC_NUMBER.length + 8 + 4 + 8;
    }
}

