/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.microprofile.client.cdi;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.enterprise.context.Dependent;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.Default;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.inject.spi.PassivationCapable;
import javax.enterprise.util.AnnotationLiteral;
import org.apache.cxf.common.classloader.ClassLoaderUtils;
import org.apache.cxf.microprofile.client.CxfTypeSafeClientBuilder;
import org.apache.cxf.microprofile.client.config.ConfigFacade;
import org.eclipse.microprofile.rest.client.inject.RestClient;

public class RestClientBean
implements Bean<Object>,
PassivationCapable {
    public static final String REST_URL_FORMAT = "%s/mp-rest/url";
    public static final String REST_SCOPE_FORMAT = "%s/mp-rest/scope";
    private static final Default DEFAULT_LITERAL = new DefaultLiteral();
    private final Class<?> clientInterface;
    private final Class<? extends Annotation> scope;
    private final BeanManager beanManager;

    RestClientBean(Class<?> clientInterface, BeanManager beanManager) {
        this.clientInterface = clientInterface;
        this.beanManager = beanManager;
        this.scope = this.readScope();
    }

    public String getId() {
        return this.clientInterface.getName();
    }

    public Class<?> getBeanClass() {
        return this.clientInterface;
    }

    public Set<InjectionPoint> getInjectionPoints() {
        return Collections.emptySet();
    }

    public boolean isNullable() {
        return false;
    }

    public Object create(CreationalContext<Object> creationalContext) {
        CxfTypeSafeClientBuilder builder = new CxfTypeSafeClientBuilder();
        String baseUrl = this.getBaseUrl();
        try {
            return builder.baseUrl(new URL(baseUrl)).build(this.clientInterface);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("The value of URL was invalid " + baseUrl);
        }
    }

    public void destroy(Object instance, CreationalContext<Object> creationalContext) {
    }

    public Set<Type> getTypes() {
        return Collections.singleton(this.clientInterface);
    }

    public Set<Annotation> getQualifiers() {
        return new HashSet<Annotation>(Arrays.asList(DEFAULT_LITERAL, RestClient.RestClientLiteral.LITERAL));
    }

    public Class<? extends Annotation> getScope() {
        return this.scope;
    }

    public String getName() {
        return this.clientInterface.getName();
    }

    public Set<Class<? extends Annotation>> getStereotypes() {
        return Collections.emptySet();
    }

    public boolean isAlternative() {
        return false;
    }

    private String getBaseUrl() {
        String property = String.format(REST_URL_FORMAT, this.clientInterface.getName());
        String baseURL = ConfigFacade.getValue(property, String.class);
        if (baseURL == null) {
            throw new IllegalStateException("Unable to determine base URL from configuration");
        }
        return baseURL;
    }

    private Class<? extends Annotation> readScope() {
        Annotation[] annotations;
        String property = String.format(REST_SCOPE_FORMAT, this.clientInterface.getName());
        String configuredScope = ConfigFacade.getOptionalValue(property, String.class).orElse(null);
        if (configuredScope != null) {
            try {
                return ClassLoaderUtils.loadClass((String)configuredScope, this.getClass(), Annotation.class);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("The scope " + configuredScope + " is invalid", e);
            }
        }
        ArrayList<Annotation> possibleScopes = new ArrayList<Annotation>();
        for (Annotation annotation : annotations = this.clientInterface.getDeclaredAnnotations()) {
            if (!this.beanManager.isScope(annotation.annotationType())) continue;
            possibleScopes.add(annotation);
        }
        if (possibleScopes.isEmpty()) {
            return Dependent.class;
        }
        if (possibleScopes.size() == 1) {
            return ((Annotation)possibleScopes.get(0)).annotationType();
        }
        throw new IllegalArgumentException("The client interface " + this.clientInterface + " has multiple scopes defined " + possibleScopes);
    }

    private static final class DefaultLiteral
    extends AnnotationLiteral<Default>
    implements Default {
        private static final long serialVersionUID = 1L;

        private DefaultLiteral() {
        }
    }
}

