/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webcontainer.osgi;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.webcontainer.osgi.DynamicVirtualHost;
import com.ibm.ws.webcontainer.osgi.DynamicVirtualHostConfiguration;
import com.ibm.ws.webcontainer.osgi.PluginParser;
import com.ibm.ws.webcontainer.osgi.WebContainer;
import com.ibm.wsspi.http.HttpContainer;
import com.ibm.wsspi.http.VirtualHost;
import com.ibm.wsspi.kernel.service.location.WsLocationAdmin;
import com.ibm.wsspi.kernel.service.location.WsResource;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.osgi.service.component.ComponentContext;

public class DynamicVirtualHostManager
implements Runnable {
    private static final TraceComponent tc = Tr.register(DynamicVirtualHostManager.class, (String)"webcontainer", (String)"com.ibm.ws.webcontainer.resources.LShimMessages");
    private final ConcurrentHashMap<String, DynamicVirtualHost> hostMap = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, VirtualHost> transportMap = new ConcurrentHashMap();
    private volatile WsLocationAdmin locationService = null;
    private volatile ScheduledExecutorService schedExecutor = null;
    private Map<String, Set<String>> pluginCfgVhostUris = null;
    private static final String PLUGIN_CFG = "plugin-cfg.xml";

    public void activate(ComponentContext compcontext) {
        PluginParser pp = new PluginParser();
        WsResource pluginCfgXml = this.locationService.getServerResource(PLUGIN_CFG);
        if (pluginCfgXml != null) {
            try {
                pp.parse(pluginCfgXml);
                this.pluginCfgVhostUris = pp.getVhostUris();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.schedExecutor.schedule(this, 30L, TimeUnit.SECONDS);
    }

    @Override
    public void run() {
        ArrayList<String> missingHosts = new ArrayList<String>();
        for (DynamicVirtualHost host : this.hostMap.values()) {
            String name = host.getName();
            if (this.transportMap.get(name) != null) continue;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Missing host = " + host.hashCode() + " : this = " + this), (Object[])new Object[0]);
            }
            missingHosts.add(name);
        }
        if (!missingHosts.isEmpty()) {
            Tr.warning((TraceComponent)tc, (String)"UNKNOWN_VIRTUAL_HOST", (Object[])new Object[]{missingHosts});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void purge() {
        DynamicVirtualHostManager dynamicVirtualHostManager = this;
        synchronized (dynamicVirtualHostManager) {
            for (DynamicVirtualHost host : this.hostMap.values()) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Purge host : " + host.hashCode() + ", this : " + this), (Object[])new Object[0]);
                }
                host.getHostConfiguration().setConfiguration(null);
            }
            this.hostMap.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void purgeHost(String hostName) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"purgeHost", (Object[])new Object[]{"hostName ->[" + hostName + "] ,this : " + this});
        }
        DynamicVirtualHostManager dynamicVirtualHostManager = this;
        synchronized (dynamicVirtualHostManager) {
            Iterator<String> contexts;
            DynamicVirtualHost host = this.hostMap.get(hostName);
            if (host != null && !(contexts = host.getHostConfiguration().getActiveContext()).hasNext()) {
                host.getHostConfiguration().setConfiguration(null);
                this.hostMap.remove(hostName);
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Remove host from map : " + hostName + ",host : " + host.hashCode() + ", this : " + this), (Object[])new Object[0]);
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"purgeHost");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DynamicVirtualHost getVirtualHost(String name, WebContainer parent) {
        if (name == null) {
            name = "default_host";
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getVirtualHost", (Object[])new Object[]{"name ->[" + name + "] , parent ->[" + parent + "] ,this : " + this});
        }
        DynamicVirtualHost vhost = null;
        boolean setpredefinedCtxRoots = false;
        DynamicVirtualHostManager dynamicVirtualHostManager = this;
        synchronized (dynamicVirtualHostManager) {
            vhost = this.hostMap.get(name);
            if (vhost == null && parent != null) {
                DynamicVirtualHostConfiguration vhostCfg = new DynamicVirtualHostConfiguration(name);
                vhost = new DynamicVirtualHost(vhostCfg, parent);
                DynamicVirtualHost prev = this.hostMap.putIfAbsent(name, vhost);
                if (prev != null) {
                    vhost = prev;
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    if (prev == null) {
                        Tr.debug((TraceComponent)tc, (String)("add host to map " + vhost.hashCode() + ", this :" + this), (Object[])new Object[0]);
                    } else {
                        Tr.debug((TraceComponent)tc, (String)("found host in map " + vhost.hashCode() + ", this : " + this), (Object[])new Object[0]);
                    }
                }
                vhost.getHostConfiguration().setConfiguration(this.transportMap.get(name));
                setpredefinedCtxRoots = true;
            }
        }
        if (setpredefinedCtxRoots && this.pluginCfgVhostUris != null) {
            Set<String> predefinedCtxRoots = this.pluginCfgVhostUris.get(name);
            vhost.setPredefinedContextRoots(predefinedCtxRoots);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event((Object)this, (TraceComponent)tc, (String)("Virtual Host created " + name), (Object[])new Object[]{vhost});
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getVirtualHost", (Object)vhost);
        }
        return vhost;
    }

    protected void setLocationService(WsLocationAdmin locAdmin) {
        this.locationService = locAdmin;
    }

    protected void unsetLocationService(WsLocationAdmin locAdmin) {
    }

    protected void setScheduledExececutor(ScheduledExecutorService schedExec) {
        this.schedExecutor = schedExec;
    }

    protected void unsetScheduledExececutor(ScheduledExecutorService schedExec) {
    }

    protected void setVirtualHost(VirtualHost vhost) {
        DynamicVirtualHost dynamicHost;
        String name = vhost.getName();
        this.transportMap.put(name, vhost);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((Object)this, (TraceComponent)tc, (String)("Virtual Host registered " + vhost), (Object[])new Object[0]);
        }
        if ((dynamicHost = this.hostMap.get(name)) != null) {
            this.updateDynamicHost(dynamicHost, vhost);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Set host : " + dynamicHost.hashCode() + ", this : " + this), (Object[])new Object[0]);
            }
        }
    }

    protected void updatedVirtualHost(VirtualHost vhost) {
        DynamicVirtualHost dynamicHost;
        String name = vhost.getName();
        this.transportMap.put(name, vhost);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((Object)this, (TraceComponent)tc, (String)("Virtual Host updated " + vhost), (Object[])new Object[0]);
        }
        if ((dynamicHost = this.hostMap.get(name)) != null) {
            this.updateDynamicHost(dynamicHost, vhost);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Update host : " + dynamicHost.hashCode() + ", this : " + this), (Object[])new Object[0]);
            }
        }
    }

    private void updateDynamicHost(DynamicVirtualHost dynamicHost, VirtualHost vhost) {
        DynamicVirtualHostConfiguration config = dynamicHost.getHostConfiguration();
        config.setConfiguration(vhost);
        Iterator<String> activeContexts = config.getActiveContext();
        while (activeContexts.hasNext()) {
            vhost.addContextRoot(activeContexts.next(), (HttpContainer)dynamicHost);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((Object)this, (TraceComponent)tc, (String)"Update virtual host configuration", (Object[])new Object[]{vhost, dynamicHost, activeContexts});
        }
    }

    protected void unsetVirtualHost(VirtualHost vhost) {
        String name = vhost.getName();
        if (this.transportMap.remove(name, vhost)) {
            DynamicVirtualHost dynamicHost = this.hostMap.get(name);
            if (dynamicHost != null) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Unset host : " + dynamicHost.hashCode() + ", this : " + this), (Object[])new Object[0]);
                }
                dynamicHost.getHostConfiguration().setConfiguration(null);
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Removed virtual host configuration", (Object[])new Object[]{vhost, dynamicHost});
            }
        }
    }

    public Iterator<DynamicVirtualHost> getVirtualHosts() {
        return this.hostMap.values().iterator();
    }
}

