/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.microprofile.openapi;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.container.service.app.deploy.ApplicationInfo;
import com.ibm.ws.container.service.state.ApplicationStateListener;
import com.ibm.ws.container.service.state.StateChangeException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.microprofile.openapi.ApplicationProcessor;
import com.ibm.ws.microprofile.openapi.utils.OpenAPIUtils;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@Component(service={ApplicationStateListener.class}, configurationPolicy=ConfigurationPolicy.IGNORE, immediate=true)
public class ApplicationListener
implements ApplicationStateListener {
    private static final TraceComponent tc = Tr.register(ApplicationListener.class);
    private ApplicationProcessor appProcessor = null;
    static final long serialVersionUID = 1608415227789141675L;

    /*
     * WARNING - void declaration
     */
    public void applicationStarting(ApplicationInfo appInfo) throws StateChangeException {
        block5: {
            if (this.appProcessor != null) {
                try {
                    if (OpenAPIUtils.isEventEnabled(tc)) {
                        Tr.event((TraceComponent)tc, (String)("Application starting process started: " + appInfo), (Object[])new Object[0]);
                    }
                    this.appProcessor.addApplication(appInfo);
                    if (OpenAPIUtils.isEventEnabled(tc)) {
                        Tr.event((TraceComponent)tc, (String)("Application starting process ended: " + appInfo), (Object[])new Object[0]);
                    }
                }
                catch (Throwable throwable) {
                    void e;
                    FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.microprofile.openapi.ApplicationListener", (String)"45", (Object)this, (Object[])new Object[]{appInfo});
                    if (!OpenAPIUtils.isEventEnabled(tc)) break block5;
                    Tr.event((TraceComponent)tc, (String)("Failed to process application: " + e.getMessage()), (Object[])new Object[0]);
                }
            }
        }
    }

    public void applicationStarted(ApplicationInfo appInfo) throws StateChangeException {
    }

    /*
     * WARNING - void declaration
     */
    public void applicationStopping(ApplicationInfo appInfo) {
        block3: {
            if (this.appProcessor != null) {
                try {
                    this.appProcessor.removeApplication(appInfo);
                }
                catch (Throwable throwable) {
                    void e;
                    FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.microprofile.openapi.ApplicationListener", (String)"63", (Object)this, (Object[])new Object[]{appInfo});
                    if (!OpenAPIUtils.isEventEnabled(tc)) break block3;
                    Tr.event((TraceComponent)tc, (String)("Failed to remove application: " + e.getMessage()), (Object[])new Object[0]);
                }
            }
        }
    }

    public void applicationStopped(ApplicationInfo appInfo) {
    }

    @Reference(service=ApplicationProcessor.class, policy=ReferencePolicy.DYNAMIC, cardinality=ReferenceCardinality.MANDATORY, policyOption=ReferencePolicyOption.GREEDY)
    protected void setApplicationProcessor(ApplicationProcessor appProcessor) {
        this.appProcessor = appProcessor;
    }

    protected void unsetApplicationProcessor(ApplicationProcessor appProcessor) {
        this.appProcessor = null;
    }
}

