/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.csiv2.server.config.css;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.websphere.security.cred.WSCredential;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.authentication.utility.SubjectHelper;
import com.ibm.ws.security.context.SubjectManager;
import com.ibm.ws.transport.iiop.security.config.css.CSSSASIdentityToken;
import com.ibm.ws.transport.iiop.security.util.Util;
import javax.security.auth.Subject;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.NO_PERMISSION;
import org.omg.CSI.IdentityToken;
import org.omg.IOP.Codec;

@TraceOptions(traceGroup="CSIv2", messageBundle="com.ibm.ws.security.csiv2.server.internal.resources.CSIv2ServerContainerMessages")
@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class ClientSASITTDistinguishedName
implements CSSSASIdentityToken {
    private static TraceComponent tc = Tr.register(ClientSASITTDistinguishedName.class);
    static final long serialVersionUID = 9181673613326636571L;

    @FFDCIgnore(value={Exception.class})
    public IdentityToken encodeIdentityToken(Codec codec) {
        IdentityToken token = null;
        String distinguishedName = null;
        try {
            distinguishedName = this.getDistinguishedName();
            token = this.createIdentityToken(codec, distinguishedName);
        }
        catch (Exception e) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("The client cannot create the ITTDistinguishedName identity assertion token for distinguished name " + distinguishedName + ". The exception message is: " + e.getMessage()), (Object[])new Object[0]);
            }
            String messageFromBundle = Tr.formatMessage((TraceComponent)tc, (String)"CSIv2_CLIENT_ASSERTION_CANNOT_ENCODE_DN", (Object[])new Object[]{distinguishedName, e.getMessage()});
            throw new NO_PERMISSION(messageFromBundle, 1229066386, CompletionStatus.COMPLETED_NO);
        }
        return token;
    }

    private String getDistinguishedName() throws Exception {
        Subject subject = this.getClientSubject();
        SubjectHelper subjectHelper = new SubjectHelper();
        WSCredential wsCredential = subjectHelper.getWSCredential(subject);
        return wsCredential.getUniqueSecurityName();
    }

    private Subject getClientSubject() {
        SubjectManager subjectManager = new SubjectManager();
        Subject subject = subjectManager.getInvocationSubject();
        if (subject == null) {
            subject = subjectManager.getCallerSubject();
        }
        return subject;
    }

    private IdentityToken createIdentityToken(Codec codec, String distinguishedName) throws Exception {
        byte[] encodedDN = Util.encodeDN((Codec)codec, (String)distinguishedName);
        IdentityToken token = new IdentityToken();
        token.dn(encodedDN);
        return token;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        this.toString("", buf);
        return buf.toString();
    }

    @Trivial
    public void toString(String spaces, StringBuilder buf) {
        buf.append(spaces).append("ClientSASITTDistinguishedName: [\n");
        buf.append(spaces).append("]\n");
    }

    public int getType() {
        return 8;
    }
}

