/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.csiv2.server.config.tss;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.AccessIdUtil;
import com.ibm.ws.security.authentication.AuthenticationException;
import com.ibm.ws.security.csiv2.Authenticator;
import com.ibm.ws.security.token.TokenManager;
import com.ibm.ws.transport.iiop.security.SASException;
import com.ibm.ws.transport.iiop.security.SASInvalidEvidenceException;
import com.ibm.ws.transport.iiop.security.config.tss.TSSASMechConfig;
import com.ibm.ws.transport.iiop.security.util.Util;
import com.ibm.wsspi.security.csiv2.TrustedIDEvaluator;
import com.ibm.wsspi.security.ltpa.Token;
import javax.security.auth.Subject;
import org.omg.CSI.EstablishContext;
import org.omg.CSIIOP.AS_ContextSec;
import org.omg.IOP.Codec;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class ServerLTPAMechConfig
extends TSSASMechConfig {
    public static final String LTPA_OID = "oid:1.3.18.0.2.30.2";
    public static final String LTPA = "LTPA";
    private final transient Authenticator authenticator;
    private final transient TokenManager tokenManager;
    private final String targetName;
    private final boolean required;
    static final long serialVersionUID = -3144653036731130893L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public ServerLTPAMechConfig(Authenticator authenticator, TokenManager tokenManager, String targetName, boolean required) {
        this.authenticator = authenticator;
        this.tokenManager = tokenManager;
        this.targetName = targetName;
        this.required = required;
    }

    public ServerLTPAMechConfig(AS_ContextSec context) {
        this.targetName = Util.decodeGSSExportedName((byte[])context.target_name).getName();
        this.required = context.target_requires == 64;
        this.authenticator = null;
        this.tokenManager = null;
    }

    public short getSupports() {
        return 64;
    }

    public short getRequires() {
        return this.required ? (short)64 : 0;
    }

    public AS_ContextSec encodeIOR(Codec codec) throws Exception {
        AS_ContextSec result = new AS_ContextSec();
        result.target_supports = (short)64;
        result.target_requires = (short)(this.required ? 64 : 0);
        result.client_authentication_mech = Util.encodeOID((String)LTPA_OID);
        result.target_name = Util.encodeGSSExportName((String)LTPA_OID, (String)this.targetName);
        return result;
    }

    @FFDCIgnore(value={AuthenticationException.class})
    public Subject check(EstablishContext msg, Codec codec) throws SASException {
        Subject authenticationLayerSubject = null;
        if (msg != null && msg.client_authentication_token != null && msg.client_authentication_token.length > 0) {
            byte[] decodedTokenBytes = Util.decodeLTPAToken((Codec)codec, (byte[])msg.client_authentication_token);
            try {
                authenticationLayerSubject = this.authenticator.authenticate(decodedTokenBytes);
            }
            catch (AuthenticationException e) {
                throw new SASInvalidEvidenceException(e.getMessage(), 1229079296);
            }
        } else if (this.required) {
            throw new SASInvalidEvidenceException("Client authentication is required at the server, but there was no client authentication token sent by the client.", 1229079296);
        }
        return authenticationLayerSubject;
    }

    @FFDCIgnore(value={Exception.class})
    public boolean isTrusted(TrustedIDEvaluator trustedIDEvaluator, EstablishContext msg, Codec codec) {
        boolean trusted = false;
        if (msg != null && msg.client_authentication_token != null && msg.client_authentication_token.length > 0) {
            try {
                byte[] decodedTokenBytes = Util.decodeLTPAToken((Codec)codec, (byte[])msg.client_authentication_token);
                Token ltpaToken = this.tokenManager.recreateTokenFromBytes(decodedTokenBytes);
                String[] accessIDs = ltpaToken.getAttributes("u");
                if (accessIDs != null && accessIDs.length > 0) {
                    String serverIdFromToken = AccessIdUtil.getUniqueId((String)accessIDs[0]);
                    trusted = trustedIDEvaluator.isTrusted(serverIdFromToken);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return trusted;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        this.toString("", buf);
        return buf.toString();
    }

    @Trivial
    public void toString(String spaces, StringBuilder buf) {
        String moreSpaces = spaces + "  ";
        buf.append(spaces).append("ServerLTPAMechConfig: [\n");
        buf.append(moreSpaces).append("targetName:   ").append(this.targetName).append("\n");
        buf.append(moreSpaces).append("required  :   ").append(this.required).append("\n");
        buf.append(spaces).append("]\n");
    }

    public String getMechanism() {
        return LTPA;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(ServerLTPAMechConfig.class);
    }
}

