/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.artifact.overlay.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.artifact.overlay.internal.DirectoryBasedOverlayContainerImpl;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.artifact.ArtifactContainer;
import com.ibm.wsspi.artifact.ArtifactEntry;
import com.ibm.wsspi.artifact.ArtifactNotifier;
import com.ibm.wsspi.artifact.DefaultArtifactNotification;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class DirectoryBasedOverlayNotifier
implements ArtifactNotifier,
ArtifactNotifier.ArtifactListener {
    private final DirectoryBasedOverlayContainerImpl root;
    private final ArtifactContainer overlayContainer;
    private final ArtifactContainer overlaidContainer;
    private boolean listeningToContainers;
    private final Map<String, Collection<ArtifactNotifier.ArtifactListener>> listeners;
    private final Set<String> pathsMonitored = new HashSet<String>();
    private final DirectoryBasedOverlayNotifier parentNotifier;
    private final String pathOfEntryInParent;
    static final long serialVersionUID = 582578843842957056L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public DirectoryBasedOverlayNotifier(DirectoryBasedOverlayContainerImpl root, ArtifactContainer artifactContainer, DirectoryBasedOverlayNotifier parent, ArtifactEntry entryInParent) {
        this.root = root;
        this.overlayContainer = artifactContainer;
        this.overlaidContainer = root.getContainerBeingOverlaid();
        this.listeningToContainers = false;
        this.parentNotifier = parent;
        this.pathOfEntryInParent = entryInParent != null ? entryInParent.getPath() : null;
        this.listeners = new ConcurrentHashMap<String, Collection<ArtifactNotifier.ArtifactListener>>();
    }

    private void verifyTargets(ArtifactNotifier.ArtifactNotification targets) throws IllegalArgumentException {
        if (targets.getContainer().getRoot() != this.root) {
            throw new IllegalArgumentException();
        }
    }

    private boolean addTarget(String path, ArtifactNotifier.ArtifactListener listener) {
        boolean pathIsNew = true;
        for (String lpath : this.listeners.keySet()) {
            if (!path.equals(lpath) && !path.startsWith(lpath + "/")) continue;
            pathIsNew = false;
        }
        Collection<ArtifactNotifier.ArtifactListener> list = this.listeners.get(path);
        if (list == null) {
            list = new ConcurrentLinkedQueue<ArtifactNotifier.ArtifactListener>();
            this.listeners.put(path, list);
        }
        list.add(listener);
        return pathIsNew;
    }

    private void collapsePaths(Collection<String> input) {
        HashSet<String> subPathsToRemove = new HashSet<String>();
        for (String path : input) {
            if (path.startsWith("!") || subPathsToRemove.contains(path)) continue;
            for (String testAgainst : input) {
                String pathToCompare;
                if (subPathsToRemove.contains(testAgainst)) continue;
                String string = pathToCompare = path.equals("/") ? "/" : path + "/";
                if (path == testAgainst || path.length() == testAgainst.length() || !testAgainst.startsWith(pathToCompare)) continue;
                subPathsToRemove.add(testAgainst);
            }
        }
        input.removeAll(subPathsToRemove);
    }

    public synchronized boolean registerForNotifications(ArtifactNotifier.ArtifactNotification targets, ArtifactNotifier.ArtifactListener callbackObject) throws IllegalArgumentException {
        this.verifyTargets(targets);
        HashSet<String> pathsToMonitor = new HashSet<String>();
        for (String path : targets.getPaths()) {
            boolean addToMonitorList = this.addTarget(path, callbackObject);
            if (!addToMonitorList) continue;
            pathsToMonitor.add(path);
        }
        pathsToMonitor.addAll(this.pathsMonitored);
        this.collapsePaths(pathsToMonitor);
        if (this.listeningToContainers) {
            this.overlayContainer.getArtifactNotifier().removeListener((ArtifactNotifier.ArtifactListener)this);
            this.overlaidContainer.getArtifactNotifier().removeListener((ArtifactNotifier.ArtifactListener)this);
        }
        this.pathsMonitored.clear();
        this.pathsMonitored.addAll(pathsToMonitor);
        this.overlayContainer.getArtifactNotifier().registerForNotifications((ArtifactNotifier.ArtifactNotification)new DefaultArtifactNotification(this.overlayContainer, this.pathsMonitored), (ArtifactNotifier.ArtifactListener)this);
        this.overlaidContainer.getArtifactNotifier().registerForNotifications((ArtifactNotifier.ArtifactNotification)new DefaultArtifactNotification(this.overlaidContainer, this.pathsMonitored), (ArtifactNotifier.ArtifactListener)this);
        this.listeningToContainers = true;
        return true;
    }

    public synchronized boolean removeListener(ArtifactNotifier.ArtifactListener listenerToRemove) {
        boolean success = false;
        HashSet<String> pathsToRemove = new HashSet<String>();
        for (Map.Entry<String, Collection<ArtifactNotifier.ArtifactListener>> listenersByPath : this.listeners.entrySet()) {
            for (ArtifactNotifier.ArtifactListener listener : listenersByPath.getValue()) {
                if (listener != listenerToRemove) continue;
                pathsToRemove.add(listenersByPath.getKey());
            }
        }
        for (String path : pathsToRemove) {
            Collection<ArtifactNotifier.ArtifactListener> listenersForPath = this.listeners.get(path);
            if (listenersForPath.size() == 1) {
                this.listeners.remove(path);
                continue;
            }
            listenersForPath.remove(listenerToRemove);
        }
        this.pathsMonitored.clear();
        this.pathsMonitored.addAll(this.listeners.keySet());
        this.collapsePaths(this.pathsMonitored);
        if (this.listeningToContainers) {
            this.overlayContainer.getArtifactNotifier().removeListener((ArtifactNotifier.ArtifactListener)this);
            this.overlaidContainer.getArtifactNotifier().removeListener((ArtifactNotifier.ArtifactListener)this);
        }
        if (this.pathsMonitored.size() > 0) {
            this.overlayContainer.getArtifactNotifier().registerForNotifications((ArtifactNotifier.ArtifactNotification)new DefaultArtifactNotification(this.overlayContainer, this.pathsMonitored), (ArtifactNotifier.ArtifactListener)this);
            this.overlaidContainer.getArtifactNotifier().registerForNotifications((ArtifactNotifier.ArtifactNotification)new DefaultArtifactNotification(this.overlaidContainer, this.pathsMonitored), (ArtifactNotifier.ArtifactListener)this);
        } else {
            this.listeningToContainers = false;
        }
        if (pathsToRemove.size() > 0) {
            success = true;
        }
        return success;
    }

    public boolean setNotificationOptions(long interval, boolean useMBean) {
        this.overlaidContainer.getArtifactNotifier().setNotificationOptions(interval, useMBean);
        this.overlayContainer.getArtifactNotifier().setNotificationOptions(interval, useMBean);
        return true;
    }

    private Set<String> filterOverlaidPaths(Collection<String> notificationPaths) {
        HashSet<String> paths = new HashSet<String>();
        for (String path : notificationPaths) {
            if (this.root.isOverlaid(path) || this.root.isMasked(path)) continue;
            paths.add(path);
        }
        return paths;
    }

    private Set<String> filterExistingPaths(Collection<String> notificationPaths) {
        HashSet<String> paths = new HashSet<String>();
        for (String path : notificationPaths) {
            if ("/".equals(path) || this.root.getContainerBeingOverlaid().getEntry(path) == null || this.root.isMasked(path)) continue;
            paths.add(path);
        }
        return paths;
    }

    private Set<String> filterMaskedPaths(Collection<String> notificationPaths) {
        HashSet<String> paths = new HashSet<String>();
        for (String path : notificationPaths) {
            if (this.root.isMasked(path)) continue;
            paths.add(path);
        }
        return paths;
    }

    public void notifyEntryChange(ArtifactNotifier.ArtifactNotification added, ArtifactNotifier.ArtifactNotification removed, ArtifactNotifier.ArtifactNotification modified) {
        Set<String> filteredRemoved;
        Set<String> filteredAdd;
        if (this.listeners.isEmpty()) {
            return;
        }
        if (added.getContainer() == this.overlayContainer) {
            filteredAdd = this.filterExistingPaths(added.getPaths());
            filteredRemoved = this.filterExistingPaths(removed.getPaths());
            HashSet<String> newAdd = new HashSet<String>(this.filterMaskedPaths(added.getPaths()));
            newAdd.removeAll(filteredAdd);
            HashSet<String> newRemoved = new HashSet<String>(this.filterMaskedPaths(removed.getPaths()));
            newRemoved.removeAll(filteredRemoved);
            HashSet<String> newModified = new HashSet<String>(modified.getPaths().size());
            newModified.addAll(this.filterMaskedPaths(modified.getPaths()));
            newModified.addAll(filteredAdd);
            newModified.addAll(filteredRemoved);
            this.notifyAllListeners(newAdd, newRemoved, newModified);
        }
        if (added.getContainer() == this.overlaidContainer) {
            filteredAdd = this.filterOverlaidPaths(added.getPaths());
            filteredRemoved = this.filterOverlaidPaths(removed.getPaths());
            Set<String> filteredModified = this.filterOverlaidPaths(modified.getPaths());
            this.notifyAllListeners(filteredAdd, filteredRemoved, filteredModified);
        }
        if (added.getContainer() == this.root) {
            this.notifyAllListeners(added.getPaths(), removed.getPaths(), modified.getPaths());
        }
    }

    private ArtifactNotifier.ArtifactNotification collectNotificationsForPrefix(String prefix, Collection<String> paths) {
        HashSet<String> gatheredPaths = new HashSet<String>();
        boolean notRecurse = prefix.startsWith("!");
        if (notRecurse) {
            prefix = prefix.substring(1);
        }
        if ("/".equals(prefix)) {
            gatheredPaths.addAll(paths);
        } else {
            for (String path : paths) {
                if (!path.startsWith(prefix + "/") && !path.equals(prefix)) continue;
                if (notRecurse) {
                    String fragment = path.substring(prefix.length());
                    if (fragment.indexOf("/") >= 1) continue;
                    gatheredPaths.add(path);
                    continue;
                }
                gatheredPaths.add(path);
            }
        }
        return new DefaultArtifactNotification((ArtifactContainer)this.root, gatheredPaths);
    }

    private void notifyAllListeners(Collection<String> created, Collection<String> deleted, Collection<String> modified) {
        if (this.parentNotifier != null) {
            this.parentNotifier.notifyAllListeners(Collections.emptySet(), Collections.emptySet(), Collections.singleton(this.pathOfEntryInParent));
        }
        for (Map.Entry<String, Collection<ArtifactNotifier.ArtifactListener>> listenersForPath : this.listeners.entrySet()) {
            String path = listenersForPath.getKey();
            ArtifactNotifier.ArtifactNotification createdForPath = this.collectNotificationsForPrefix(path, created);
            ArtifactNotifier.ArtifactNotification modifiedForPath = this.collectNotificationsForPrefix(path, modified);
            ArtifactNotifier.ArtifactNotification deletedForPath = this.collectNotificationsForPrefix(path, deleted);
            if (createdForPath.getPaths().isEmpty() && modifiedForPath.getPaths().isEmpty() && deletedForPath.getPaths().isEmpty()) continue;
            for (ArtifactNotifier.ArtifactListener listener : listenersForPath.getValue()) {
                listener.notifyEntryChange(createdForPath, deletedForPath, modifiedForPath);
            }
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(DirectoryBasedOverlayNotifier.class);
    }
}

